/*
    TCFbESimfinderCommandLineParser.h    January 13, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbESimfinderCommandLineParserH
#define TCFbESimfinderCommandLineParserH
//---------------------------------------------------------------------------
#include <system.hpp>
#include <Classes.hpp>

#include "TCFbECustomCommandLineParser.h"

#include "TCFbETypes.h"
#include "EDocfbeError.h"

#include "TCFbESimilarityComputationAlgorithm.h"
#include "TCFbEPredictionAlgorithm.h"

#include "TCFbECosineSimilarity.h"
#include "TCFbEAdjustedCosineSimilarityWithAverage.h"
#include "TCFbEAdjustedCosineSimilarityWithMedian.h"
#include "TCFbECorrelationCoefficientWithAverage.h"
#include "TCFbECorrelationCoefficientWithMedian.h"
#include "TCFbERankCorrelation.h"
#include "TCFbEDistanceSimilarityWithAverage.h"
#include "TCFbEDistanceSimilarityWithMedian.h"

#include "TCFbEWeightedSum.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfColumn.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfColumn.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfNeighbors.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfNeighbors.h"
#include "TCFbEAdjustedWeightedSumWithAverageOfRow.h"
#include "TCFbEAdjustedWeightedSumWithMedianOfRow.h"
#include "TCFbEAmplifiedWeightedSumWithAveragedMultiplier.h"
#include "TCFbEAmplifiedWeightedSumWithMedianOfMultiplier.h"
#include "TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier.h"
//---------------------------------------------------------------------------
class TCFbESimfinderCommandLineParser : public TCFbECustomCommandLineParser
{
public:
    virtual __fastcall TCFbESimfinderCommandLineParser(int argc=0, char* argv[]=NULL);  // RXgN^
    __fastcall ~TCFbESimfinderCommandLineParser();      // fXgN^
    virtual AnsiString __fastcall GetHelpString(void);  // wvԂ
    virtual int __fastcall DoParse(void);  // R}hCp[XăG[R[hԂ

protected:

private:

};
//---------------------------------------------------------------------------
#endif
