/*
    TCFbESimilarityComputationAlgorithm.h    June 6, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbESimilarityComputationAlgorithmH
#define TCFbESimilarityComputationAlgorithmH
//---------------------------------------------------------------------------
#include <Classes.hpp>

#include "TCFbECustomTableEx.h"
//---------------------------------------------------------------------------
class TCFbESimilarityComputationAlgorithm : public TPersistent
{
public:
    virtual __fastcall TCFbESimilarityComputationAlgorithm(void);    // RXgN^
    __fastcall ~TCFbESimilarityComputationAlgorithm();    // fXgN^

    // vZɕKvȃLbV
    virtual void __fastcall PrepareCache(TCFbECustomTableEx* SimilarityComputationTable) = 0;

    // TargetRowIndex  AnotherRowIndex ̗ގxvZ
    virtual double __fastcall ComputeSimilarity(TCFbECustomTableEx* SimilarityComputationTable, int TargetRowIndex, int ComparedRowIndex) = 0;

protected:

    TCFbECustomTableEx* SimilarityComputationTable;

private:

};
//---------------------------------------------------------------------------
#endif
