/*
    TCFbETestCase8.cpp    December 28, 2004.

    Copyright (C) 2003-2005 CFbE Research Group,
    Software Engineering Laboratory,
    Graduate School of Information Science,
    Nara Institute of Science and Technology,
    All rights reserved.

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, (at your option) or
    any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GNU Emacs; see the file COPYING.  If not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
//---------------------------------------------------------------------------
#ifndef TCFbETestCase8H
#define TCFbETestCase8H
//---------------------------------------------------------------------------
#pragma hdrstop
//---------------------------------------------------------------------------
#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestRunner.h>

USING_NAMESPACE_CPPUNIT
//---------------------------------------------------------------------------
#include <System.hpp>

#include "TCFbETypes.h"
#include "TCFbETableEx.h"
#include "TCFbEDataSetEx.h"
#include "TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier.h"
#include "TCFbECorrelationCoefficientWithAverage.h"
#include "TCFbERankCorrelation.h"
#include "TCFbESimfinderCommandLineParser.h"
#include "TCFbESimfinderDataLoader.h"
#include "TCFbESimfinderOutputCache.h"
//---------------------------------------------------------------------------
// eXgP[X8
class TCFbETestCase8 : public TestCase
{
    // RXgN^
    TEST_CASE_COMMON(TCFbETestCase8)

public:
    // eXg
    // FILENAME BUG	LOC	N_COMM	HALVOL	SCPMN
    // module_1	10	800	0.3	    3600	4
    // module_2	0	250	0.2	    3200	3.5
    // module_3	8	500	0	    3200
    // module_4	5	700	0.25		    4
    // module_5	9	600		    3200	2.5
    // module_6	15		0.35	3800	4.1
    virtual void setUp() {
        TStringList* TestStringList = new TStringList();
        TestStringList->Add("FILENAME,  BUG,    LOC,    N_COMM, HALVOL, SCPMN");
        TestStringList->Add("module_1,  10,     800,    0.3,    3600,   4");
        TestStringList->Add("module_2,  0,      250,    0.2,    3200,   3.5");
        TestStringList->Add("module_3,  8,      500,    0,      3200,   ");
        TestStringList->Add("module_4,  5,      700,    0.25,   ,       4");
        TestStringList->Add("module_5,  9,      600,    ,       3200,   2.5");
        TestStringList->Add("module_6,  15,     ,       0.35,   3800,   4.1");
        this->DataSetEx = new TCFbEDataSetEx(TestStringList);
        delete TestStringList;
    }

    // eXǧЕt
    virtual void tearDown() {
        delete this->DataSetEx;
    }

    virtual void Test_PredictedValues_vbNormalizedValue_abRow_VW() {
        TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier* vwwm = new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier();
        this->DataSetEx->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), vwwm, 0, false, 0.0, false, 1.0, new TCFbERankCorrelation(), new TCFbECorrelationCoefficientWithAverage());

        this->DataSetEx->TemporallyUnable(0, 0);
        TEST_ASSERT_EQUALS_DOUBLE(0.000694845, this->DataSetEx->GetPredictedValueByIndex(0, 0), 1E-6);

        this->DataSetEx->TemporallyUnable(1, 0);
        TEST_ASSERT_EQUALS_DOUBLE(3.983377787, this->DataSetEx->GetPredictedValueByIndex(1, 0), 1E-6);

        this->DataSetEx->TemporallyUnable(2, 0);
        TEST_ASSERT_EQUALS_DOUBLE(2.672515286, this->DataSetEx->GetPredictedValueByIndex(2, 0), 1E-6);

        this->DataSetEx->TemporallyUnable(3, 0);
        TEST_ASSERT_EQUALS_DOUBLE(9.810145873, this->DataSetEx->GetPredictedValueByIndex(3, 0), 1E-6);

        this->DataSetEx->TemporallyUnable(4, 0);
        TEST_ASSERT_EQUALS_DOUBLE(3.439411374, this->DataSetEx->GetPredictedValueByIndex(4, 0), 1E-6);

        this->DataSetEx->TemporallyUnable(5, 0);
        TEST_ASSERT_EQUALS_DOUBLE(5.27931514, this->DataSetEx->GetPredictedValueByIndex(5, 0), 1E-6);
    }

    //  FILENAME	module_1	module_2	module_3	module_4	module_5	module_6
    //  module_1	1	-0.680952833	0.785612971	-0.2526392	0.88562333	0.731998724
    //  module_2	-0.680952833	1	-0.516482434	0.417378895	-0.530921743	-0.925502221
    //  module_3	0.785612971	-0.516482434	1	-0.625431786	0.988094829	0.619150708
    //  module_4	-0.2526392	0.417378895	-0.625431786	1	-0.675950268	-0.903556837
    //  module_5	0.88562333	-0.530921743	0.988094829	-0.675950268	1	0.637332381
    //  module_6	0.731998724	-0.925502221	0.619150708	-0.903556837	0.637332381	1
    virtual void Test_Similarity_vbNormalizedValue_abRow_VW() {
        TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier* vwwm = new TCFbEAmplifiedWeightedSumWithVWWeightedMultiplier();
        this->DataSetEx->PrepareCF(vbNormalizedValue, abRow, new TCFbECorrelationCoefficientWithAverage(), vwwm, 0, false, 0.0, false, 1.0, new TCFbERankCorrelation(), new TCFbECorrelationCoefficientWithAverage());

        //  module_1	1	-0.680952833	0.785612971	-0.2526392	0.88562333	0.731998724
        TEST_ASSERT_EQUALS_DOUBLE(1,            this->DataSetEx->GetSimilarityByIndex(0, 0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.680952833, this->DataSetEx->GetSimilarityByIndex(0, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.785612971,  this->DataSetEx->GetSimilarityByIndex(0, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.2526392,   this->DataSetEx->GetSimilarityByIndex(0, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.88562333,   this->DataSetEx->GetSimilarityByIndex(0, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.731998724,  this->DataSetEx->GetSimilarityByIndex(0, 5, 0), 1E-6);

        //  module_2	-0.680952833	1	-0.516482434	0.417378895	-0.530921743	-0.925502221
        TEST_ASSERT_EQUALS_DOUBLE(-0.680952833, this->DataSetEx->GetSimilarityByIndex(1, 0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            this->DataSetEx->GetSimilarityByIndex(1, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.516482434, this->DataSetEx->GetSimilarityByIndex(1, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.417378895,  this->DataSetEx->GetSimilarityByIndex(1, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.530921743, this->DataSetEx->GetSimilarityByIndex(1, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.925502221, this->DataSetEx->GetSimilarityByIndex(1, 5, 0), 1E-6);

        //  module_3	0.785612971	-0.516482434	1	-0.625431786	0.988094829	0.619150708
        TEST_ASSERT_EQUALS_DOUBLE(0.785612971,  this->DataSetEx->GetSimilarityByIndex(2, 0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.516482434, this->DataSetEx->GetSimilarityByIndex(2, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            this->DataSetEx->GetSimilarityByIndex(2, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.625431786, this->DataSetEx->GetSimilarityByIndex(2, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.988094829,  this->DataSetEx->GetSimilarityByIndex(2, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.619150708,  this->DataSetEx->GetSimilarityByIndex(2, 5, 0), 1E-6);

        //  module_4	-0.2526392	0.417378895	-0.625431786	1	-0.675950268	-0.903556837
        TEST_ASSERT_EQUALS_DOUBLE(-0.2526392,   this->DataSetEx->GetSimilarityByIndex(3, 0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.417378895,  this->DataSetEx->GetSimilarityByIndex(3, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.625431786, this->DataSetEx->GetSimilarityByIndex(3, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            this->DataSetEx->GetSimilarityByIndex(3, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.675950268, this->DataSetEx->GetSimilarityByIndex(3, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.903556837, this->DataSetEx->GetSimilarityByIndex(3, 5, 0), 1E-6);

        //  module_5	0.88562333	-0.530921743	0.988094829	-0.675950268	1	0.637332381
        TEST_ASSERT_EQUALS_DOUBLE(0.88562333,   this->DataSetEx->GetSimilarityByIndex(4, 0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.530921743, this->DataSetEx->GetSimilarityByIndex(4, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.988094829,  this->DataSetEx->GetSimilarityByIndex(4, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.675950268, this->DataSetEx->GetSimilarityByIndex(4, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            this->DataSetEx->GetSimilarityByIndex(4, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.637332381,  this->DataSetEx->GetSimilarityByIndex(4, 5, 0), 1E-6);

        //  module_6	0.731998724	-0.925502221	0.619150708	-0.903556837	0.637332381	1
        TEST_ASSERT_EQUALS_DOUBLE(0.731998724,  this->DataSetEx->GetSimilarityByIndex(5, 0, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.925502221, this->DataSetEx->GetSimilarityByIndex(5, 1, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.619150708,  this->DataSetEx->GetSimilarityByIndex(5, 2, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(-0.903556837, this->DataSetEx->GetSimilarityByIndex(5, 3, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(0.637332381,  this->DataSetEx->GetSimilarityByIndex(5, 4, 0), 1E-6);
        TEST_ASSERT_EQUALS_DOUBLE(1,            this->DataSetEx->GetSimilarityByIndex(5, 5, 0), 1E-6);
    }

    virtual void Test_TCFbeSimfinderCommandLineParser_vbNormalizedValue_abRow_VW() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-t=BUG"
            , "-l=test\\learningdata_testcase8.csv"
            , "-s=CorrelationCoefficientWithAverage"
            , "-vs=RankCorrelation"
        };

        TCFbESimfinderCommandLineParser* Parser = new TCFbESimfinderCommandLineParser(6, argv);
        Parser->DoParse();

        TEST_ASSERT_EQUALS(0,   Parser->ErrorCode);
        TEST_ASSERT_EQUALS("",  Parser->ErrorParameter.c_str());
        TEST_ASSERT_EQUALS((int)false,  (int)Parser->HelpEnabled);
        TEST_ASSERT_EQUALS(1,   Parser->LearningDataFileNameList->Count);
        TEST_ASSERT_EQUALS("test\\learningdata_testcase8.csv",  Parser->LearningDataFileNameList->Strings[0].c_str());
        TEST_ASSERT_EQUALS("CorrelationCoefficientWithAverage", Parser->SimilarityComputationName.c_str());
        TEST_ASSERT_EQUALS((int)vbNormalizedValue,  (int)Parser->ValueBase);
        TEST_ASSERT_EQUALS((int)abRow,  (int)Parser->AlgorithmBase);
        TEST_ASSERT_EQUALS(1,       Parser->TargetColumnLabelList->Count);
        TEST_ASSERT_EQUALS("BUG",   Parser->TargetColumnLabelList->Strings[0].c_str());
        TEST_ASSERT_EQUALS((int)false,  (int)Parser->DefaultValueEnabled);
        TEST_ASSERT_EQUALS_DOUBLE(0.0,   Parser->DefaultValue, 1E-6);
        TEST_ASSERT_EQUALS((int)false,  (int)Parser->InverseCaseFrequencyEnabled);
        TEST_ASSERT_EQUALS("RankCorrelation",   Parser->VWSimilarityComputationName.c_str());
        TEST_ASSERT_EQUALS("",   Parser->OutputFileName.c_str());

        delete Parser;
    }

    virtual void Test_TCFbEOutputCache_vbNormalizedValue_abRow_VW() {
        char* argv[] = { "docfbe_test"
            , "-n=normalize"
            , "-t=BUG"
            , "-l=test\\learningdata_testcase8.csv"
            , "-s=CorrelationCoefficientWithAverage"
            , "-vs=RankCorrelation"
        };

        TCFbESimfinderCommandLineParser* Parser = new TCFbESimfinderCommandLineParser(6, argv);
        Parser->DoParse();
        TCFbESimfinderDataLoader* Loader = new TCFbESimfinderDataLoader(Parser);
        TCFbESimfinderOutputCache* OutputCache = new TCFbESimfinderOutputCache(Parser, Loader, false);

        TStringList* ExpectedStringList = new TStringList();
        ExpectedStringList->Add("Target,BUG");
        ExpectedStringList->Add("");
        ExpectedStringList->Add(",module_1,module_2,module_3,module_4,module_5,module_6");
        ExpectedStringList->Add("module_1,1.0,-0.680952833144542,0.785612971473106,-0.25263919998461,0.885623330424841,0.731998724221164");
        ExpectedStringList->Add("module_2,-0.680952833144542,1.0,-0.516482433860391,0.417378894501079,-0.530921742798046,-0.925502220715539");
        ExpectedStringList->Add("module_3,0.785612971473106,-0.516482433860391,1.0,-0.625431785695645,0.988094828809199,0.619150708067061");
        ExpectedStringList->Add("module_4,-0.25263919998461,0.417378894501079,-0.625431785695645,1.0,-0.675950268234556,-0.903556837309401");
        ExpectedStringList->Add("module_5,0.885623330424841,-0.530921742798046,0.988094828809199,-0.675950268234556,1.0,0.637332381295001");
        ExpectedStringList->Add("module_6,0.731998724221164,-0.925502220715539,0.619150708067061,-0.903556837309401,0.637332381295001,1.0");
        ExpectedStringList->Add("");
        ExpectedStringList->Add("");

        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[0].c_str(), OutputCache->GetOutputStringList()->Strings[0].c_str());
        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[1].c_str(), OutputCache->GetOutputStringList()->Strings[1].c_str());
        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[2].c_str(), OutputCache->GetOutputStringList()->Strings[2].c_str());
        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[3].c_str(), OutputCache->GetOutputStringList()->Strings[3].c_str());
        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[4].c_str(), OutputCache->GetOutputStringList()->Strings[4].c_str());
        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[5].c_str(), OutputCache->GetOutputStringList()->Strings[5].c_str());
        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[6].c_str(), OutputCache->GetOutputStringList()->Strings[6].c_str());
        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[7].c_str(), OutputCache->GetOutputStringList()->Strings[7].c_str());
        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[8].c_str(), OutputCache->GetOutputStringList()->Strings[8].c_str());
        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[9].c_str(), OutputCache->GetOutputStringList()->Strings[9].c_str());
        TEST_ASSERT_EQUALS(ExpectedStringList->Strings[10].c_str(), OutputCache->GetOutputStringList()->Strings[10].c_str());

        delete ExpectedStringList;
        delete Parser;
        delete Loader;
        delete OutputCache;
    }

protected:
    TCFbEDataSetEx* DataSetEx;
};

//---------------------------------------------------------------------------
#endif


