using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace HydeCalc {
	public class NumericTextBox : TextBox {
		const int WM_PASTE = 0x302;

		protected override void WndProc(ref Message m) {
			if (m.Msg == WM_PASTE) {
				IDataObject iData = Clipboard.GetDataObject();
				//񂪃Nbv{[hɂ邩
				if (iData.GetDataPresent(DataFormats.Text)) {
					string clipStr = (string) iData.GetData(DataFormats.Text);
					//Nbv{[h̕񂪐ׂ
					if (!System.Text.RegularExpressions.Regex.IsMatch(clipStr, @"^\d+$")) {
						return;
					}
				}
			}

			base.WndProc(ref m);
		}
	}
}
