/* 
 * xfce4-newsreader-plugin
 * A lightweight RSS/Atom news feed reader on xfce4-panel 
 * Copyright (C) 2005 mueki <mueki@users.sourceforge.jp>
 *
 * datetimeparse.c
 *
 * Based on code from: 
 * ne_dates.c
 * Copyright (C) 1999-2004, Joe Orton <joe@manyfish.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "config.h"
#include <sys/types.h>
#include <time.h>

/* ISO8601: 2001-01-01T12:30:00Z */
#define ISO8601_FORMAT_Z "%04d-%02d-%02dT%02d:%02d:%lfZ"
#define ISO8601_FORMAT_M "%04d-%02d-%02dT%02d:%02d:%lf-%02d:%02d"
#define ISO8601_FORMAT_P "%04d-%02d-%02dT%02d:%02d:%lf+%02d:%02d"
#define ISO8601_FORMAT_PT "%04d-%02d-%02dT%02d:%02d:%lf"
#define ISO8601_FORMAT_HM "%04d-%02d-%02dT%02d:%02d"
#define ISO8601_FORMAT_FD "%04d-%02d-%02d"

#if defined(HAVE_STRUCT_TM_TM_GMTOFF)
#define GMTOFF(t) ((t).tm_gmtoff)
#else
/* FIXME: work out the offset anyway. */
#define GMTOFF(t) (0)
#endif

time_t datetime_parse(const char *date) 
{
    struct tm gmt = {0};
    int off_hour, off_min;
    double sec;
    off_t fix;
    int n;

    /*  it goes: ISO8601: 2001-01-01T12:30:00+03:30 */
    if ((n = sscanf(date, ISO8601_FORMAT_P,
					&gmt.tm_year, &gmt.tm_mon, &gmt.tm_mday,
					&gmt.tm_hour, &gmt.tm_min, &sec,
					&off_hour, &off_min)) == 8) {
		gmt.tm_sec = (int)sec;
		fix = - off_hour * 3600 - off_min * 60;
    }
    /*  it goes: ISO8601: 2001-01-01T12:30:00-03:30 */
    else if ((n = sscanf(date, ISO8601_FORMAT_M,
						 &gmt.tm_year, &gmt.tm_mon, &gmt.tm_mday,
						 &gmt.tm_hour, &gmt.tm_min, &sec,
						 &off_hour, &off_min)) == 8) {
		gmt.tm_sec = (int)sec;
		fix = off_hour * 3600 + off_min * 60;
    }
    /*  it goes: ISO8601: 2001-01-01T12:30:00Z */
    else if ((n = sscanf(date, ISO8601_FORMAT_Z,
						 &gmt.tm_year, &gmt.tm_mon, &gmt.tm_mday,
						 &gmt.tm_hour, &gmt.tm_min, &sec)) == 6) {
		gmt.tm_sec = (int)sec;
		fix = 0;
    }
	/* it goes: ISO8601: 2005-01-01T12:30:00 */
    else if ((n = sscanf(date, ISO8601_FORMAT_PT,
						 &gmt.tm_year, &gmt.tm_mon, &gmt.tm_mday,
						 &gmt.tm_hour, &gmt.tm_min, &sec)) == 6) {
		gmt.tm_sec = (int)sec;
		fix = 0;
    }
	/* it goes: ISO8601: 2005-01-01T12:30 */
    else if ((n = sscanf(date, ISO8601_FORMAT_HM,
						 &gmt.tm_year, &gmt.tm_mon, &gmt.tm_mday,
						 &gmt.tm_hour, &gmt.tm_min)) == 5) {
		gmt.tm_sec = (int)0;
		fix = 0;
    }
	/* it goes: YYYY-MM-DD: 2005-01-01 */
    else if ((n = sscanf(date, ISO8601_FORMAT_FD,
						 &gmt.tm_year, &gmt.tm_mon, &gmt.tm_mday)) == 3) {
		gmt.tm_hour = (int)0;
		gmt.tm_min = (int)0;
		gmt.tm_sec = (int)0;
		fix = 0;
    }
    else {
		return (time_t)-1;
    }

    gmt.tm_year -= 1900;
    gmt.tm_isdst = -1;
    gmt.tm_mon--;

    return mktime(&gmt) + fix + GMTOFF(gmt);
}

#ifdef _MAIN_INCLUDE_
int main(int argc, char* argv[])
{
	time_t tmTime;

	if(argc < 2){
		printf("usage: datetime_parse <date_time>\n");
		return 1;
	}
	
	tmTime = datetime_parse(argv[1]);

	if(tmTime > 0){
		printf("%s\n", ctime(&tmTime));
	}
	else{
		printf("parse error\n");
	}
	
	return 0;
}

#endif
