#include <GL/glut.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <stdio.h>
#include <time.h>
#include "./dxf2dat.h"          //DXFファイルを中間ファイルに変換する関係
#include "./middlefile.h"       //中間ファイルから座標情報を読み取る関係
#include "./delta.h"
#include "bitmap.h"
#include "conffile.h"
#define DELTA_MIDDLEFILENAME "delta.dat"        //最大変形の差分が入った中間ファイルの名前
#define REDRAW_TIME (1000.0/12.0)       //12 fps
#define PI 3.141592654

#define DRAW_MODE_FUNC glOrtho(-1.2, 1.2, -1.2, 1.2, 0.01, 100) //同じ関数を同じ状態で呼び出さなければならないのでこんな変なことしてます。（ミス防止）読みづらいですね。

conffile conf;

int g_window_width, g_window_height;
double g_starttime;

double shoki_kaitenkaku[3];     //x,y,zの3つ
double g_bairitu;               //拡大縮小する倍率
double g_buttaisize;
int g_FaceN;                    //全面数
double g_Multipie, g_passtime;
FACE_CORNER *g_faces;           //原型の面の座標情報
FACE_CORNER *g_DeltaFaces;      //原型と最大変形との差分のデータ

//図形を回転して見る時の、回転角；（各軸に対して）
GLfloat theta_x;
GLfloat theta_y;
GLfloat theta_z;

//図形を移動して見るときの、移動量;(各軸方向に対して)
GLfloat g_idou_x = 0.0;
GLfloat g_idou_y = 0.0;
GLfloat g_idou_z = 0.0;

double g_shuki = 0.0;
double g_nowtime = 0.0;

//****** 時間毎に呼び出される関数 *******//
//アニメーションで、変形を表示するために利用しています。
void timer(int value)
{
    g_nowtime += (REDRAW_TIME / 1000);
    double nowtime = g_nowtime;
    if (conf.avioutput() == true)
      {
          if (conf.avioutputtime("start") < nowtime
              && nowtime < conf.avioutputtime("end"))
              capture_screen(g_window_width, g_window_height);  //**画面キャプチャ
      }
    glutTimerFunc((int) REDRAW_TIME, timer, 1);
    g_passtime = fmod((double) g_passtime + (REDRAW_TIME / 1000), g_shuki);
    g_Multipie = sin((g_passtime / g_shuki) * 2 * PI);  //変形させる
    glutPostRedisplay();
}


int width, height;

void Draw(int i)
{
    int j;
    double x,y,z;
    GLfloat vertex[3][4];
    for(j=0;j<4;j++)
      {
          vertex[0][j] = g_faces[i].x[j] - g_DeltaFaces[i].x[j] * g_Multipie;
          vertex[1][j] = g_faces[i].y[j] - g_DeltaFaces[i].y[j] * g_Multipie;
          vertex[2][j] = g_faces[i].z[j] - g_DeltaFaces[i].z[j] * g_Multipie-100.0;
      }

    glVertexPointer(4,GL_FLOAT,0,vertex);
    glDrawArrays(GL_POLYGON, 0, 4);
    //glViewport(0, 0, width, height);
}

void disp(void)
{
    int i, j, k;
    double x, y, z;
    GLfloat green[] = { 0.0, 1.0, 0.0, 1.0 };
    GLfloat black[] = { 0.0, 0.0, 0.0, 1.0 };
    GLfloat white[] = { 1.0, 1.0, 1.0, 1.0 };

    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glEnable(GL_DEPTH_TEST);

    glPolygonMode(GL_FRONT, GL_LINE);
    glPolygonMode(GL_BACK, GL_LINE);
    glClearColor(0.0, 0.0, 0.0, 1.0);
    glRotatef(theta_z, 0.0, 0.0, 1.0);
    glRotatef(theta_y, 0.0, 1.0, 0.0);
    glRotatef(theta_x, 1.0, 0.0, 0.0);

    gluLookAt(g_idou_x, g_idou_y, g_idou_z + 5.0, g_idou_x, g_idou_y, g_idou_z,
              0.0, 1.0, 0.0);

    // *** 各面を描画する ***//
    // 各面に対してのループ
    for (i = 0; i < g_FaceN; i++)
      {
          glPushMatrix();
          glColor4fv(green);
          Draw(i);
          glPopMatrix();
//          glPushMatrix();
//          glColor4fv(green);
//          Draw();
//          glPopMatrix();

          glFlush();
      }
}





static void keyboardCallback(unsigned char key, int x, int y)
{
    switch (key)                //キーボード入力での操作
      {
      case 'n':
          glScalef(1 / 1.05f, 1 / 1.05f, 1 / 1.05f);
          break;
      case 'p':
          glScalef(1.05f, 1.05f, 1.05f);
          break;
      case 'q':                //終了
          exit(EXIT_SUCCESS);
          break;
      case 'e':                //移動
          g_idou_z += 0.100;
          glutPostRedisplay();
          break;
      case 'w':                //移動
          g_idou_z -= 0.100;
          glutPostRedisplay();
          break;
      case 'g':                //移動
          g_idou_x -= 0.100;
          glutPostRedisplay();
          break;
      case 's':                //移動
          g_idou_x += 0.100;
          glutPostRedisplay();
          break;
      case 'f':                //移動
          g_idou_y += 0.100;
          glutPostRedisplay();
          break;
      case 'd':                //回転
          g_idou_y -= 0.100;
          glutPostRedisplay();
          break;
      case 'i':                //回転
          theta_z = fmod(theta_z + 2.5, 360.0);
          glutPostRedisplay();
          break;
      case 'o':                //回転
          theta_z = fmod(theta_z - 2.5, 360.0);
          glutPostRedisplay();
          break;
      case 'j':                //回転
          theta_y = fmod(theta_y + 2.5, 360.0);
          glutPostRedisplay();
          break;
      case 'k':                //回転
          theta_y = fmod(theta_y - 2.5, 360.0);
          glutPostRedisplay();
          break;
      case 'h':                //回転
          theta_x = fmod(theta_x - 2.5, 360.0);
          glutPostRedisplay();
          break;
      case 'l':                //回転
          theta_x = fmod(theta_x + 2.5, 360.0);
          glutPostRedisplay();
          break;
      case 'R':
          glutPostRedisplay();
          break;
      default:
          break;
      }
}





void reshape(int w, int h)
{
    width = w;
    height = h;
//    DRAW_MODE_FUNC;
    disp();
}

int main(int argc, char **argv)
{
    int i;
    glutInit(&argc, argv);
    glutInitWindowPosition(100, 50);
    glutInitWindowSize(400, 300);
    glutInitDisplayMode(GLUT_SINGLE | GLUT_RGBA | GLUT_DEPTH);

    // *** プロジェクトを開く *** //
    char *projectname = new char[strlen(argv[1]) + 1];
    strcpy(projectname, argv[1]);
    char *inputfile, *nextfile;
    conf.readfile(projectname);
    inputfile = conf.dxffilepath("nonallaxis");
    nextfile = conf.dxffilepath("allaxis");
    g_shuki = conf.cycle();
    double bairitu = conf.deltap();
    theta_x = conf.angle("x");
    theta_y = conf.angle("y");
    theta_z = conf.angle("z");
    g_bairitu = conf.scale();
    g_idou_x = conf.positiond("x");
    g_idou_y = conf.positiond("y");
    g_idou_z = conf.positiond("z");
    g_passtime = 0.0;
    //* dxfファイル読み込み *//
    //変形前のdxfファイル
    g_FaceN = dxf2dat(inputfile, "nfem3ap_middlefile.dat");     //中間ファイルのせいせい
    g_faces = new FACE_CORNER[g_FaceN]; //元図形の座標データを入れる領域作成
    double average[3];          //[0]:x [1]:y [2]:z 各座標軸の平均値
    read_datfile(g_FaceN, g_faces, "nfem3ap_middlefile.dat", average);  //元図形の座標データ読み込み
    if (g_idou_x == (double) NULL)
        g_idou_x = average[0];
    if (g_idou_y == (double) NULL)
        g_idou_y = average[1];
    if (g_idou_z == (double) NULL)
        g_idou_z = average[2];
    int j;
    //初期起動時に表示されている真ん中の所を原点に設定する
    for (i = 0; i < g_FaceN; i++)
      {
          for (j = 0; j < 4; j++)
            {
                g_faces[i].x[j] -= g_idou_x;
                g_faces[i].y[j] -= g_idou_y;
                g_faces[i].z[j] -= g_idou_z;
            }
      }
    g_idou_x = 0;
    g_idou_y = 0;
    g_idou_z = 0;
    makedelta(inputfile, nextfile, "delta.dxf");
    dxf2dat("delta.dxf", DELTA_MIDDLEFILENAME);

    g_DeltaFaces = new FACE_CORNER[g_FaceN];
    double gomi_date[3];
    read_datfile(g_FaceN, g_DeltaFaces, DELTA_MIDDLEFILENAME, gomi_date);       //前記差分の読み込み

    for (j = 0; j < g_FaceN; j++)
      {
          for (i = 0; i < 4; i++)
            {
                g_DeltaFaces[j].x[i] *= bairitu;
                g_DeltaFaces[j].y[i] *= bairitu;
                g_DeltaFaces[j].z[i] *= bairitu;
            }
      }


    glutCreateWindow(projectname);
    glutTimerFunc((int) REDRAW_TIME, timer, 1);
    glutDisplayFunc(disp);
    glutKeyboardFunc(keyboardCallback);
    glutReshapeFunc(reshape);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glFrustum(-1, 1, -1, 1, 2, 10);

    glEnableClientState(GL_VERTEX_ARRAY);

    glutMainLoop();
    return 0;
}
