// EDU mk2 test program

// main for EDU2(ATmega64)
// by takuya matsubara
// http://nicotak.com


#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include "vram.h"
#include "textx.h"
#include "sw.h"
#include "str.h"
#include "keyboard.h"
#include "akiled.h"
#include "sio.h"
#include "i2c.h"

#include "stime.h"	//FAT file system by ChaN
#include "tff.h"	//FAT file system by ChaN
#include "diskio.h"	//FAT file system by ChaN

// ChaNFAT file systemgĂ܂B
// gpĂt@C
// integer.h / stime.S / stime.h / mmc.c / tff.c / tff.h / diskio.h
// IWĩR[h͂
// http://elm-chan.org/
// http://elm-chan.org/fsw/ff/00index_j.html


FATFS fatfs;

//FUSE bit
//          -FX11111111 -FH11011001 -FL11100100
/*
  ATmega103 compatible mode: DISABLED
  JTAG : DISABLED
  Clock : Calibrated Internal RC Oscillator 8MHz
*/

unsigned char getkey(char brink);
char fileselect (void);
void loadtxtfile (char *fname,char euc);


void bas_print(char *p);
void bas_print2(char *p);
void bas_printd(int val);
void bas_printhex(unsigned char x);


//	^C}[0
#ifndef F_CPU
	#define F_CPU 8000000	// CPUNbNg[Hz]
#endif


#define T0INTRCYCLE  700	//荞ݎ[Hz]
#define T0PRESCALE  256	// ^C}0vXP[l
#define T0PRESCALER 6		// ^C}0vXP[ݒ
	// 1=div1 / 2=div8 / 3=div32 / 4=div64 / 5=128 / 6=256 /7=div1K
#define T0STA (0x100-((F_CPU/T0PRESCALE)/T0INTRCYCLE))


unsigned char cnt10ms;	//ėp^C}
unsigned char tintcnt=0;

SIGNAL (SIG_OVERFLOW0)
{
	TCNT0 =T0STA;        // ^C}0̏lݒ   
	sei();

	led_disp();
	tintcnt++;
	if(tintcnt >= (T0INTRCYCLE/100)){//-----------------------100Hz
		tintcnt=0;
		disk_timerproc();	/* Drive timer procedure of low level disk I/O module */
		lcd_disp2();

		if(cnt10ms)cnt10ms--;
	}
}

DWORD get_fattime ()
{
	struct tm *tmr;
	time_t t=0;

	tmr = gmtime(&t);
	return	  ((DWORD)(tmr->tm_year - 80) << 25)
			| ((DWORD)(tmr->tm_mon + 1) << 21)
			| ((DWORD)tmr->tm_mday << 16)
			| (WORD)(tmr->tm_hour << 11)
			| (WORD)(tmr->tm_min << 5)
			| (WORD)(tmr->tm_sec >> 1);
/*
	return	((2006UL-1980) << 25)	// Year = 2006
			| (2UL << 21)			// Month = Feb
			| (9UL << 16)			// Day = 9
			| (22U << 11)			// Hour = 22
			| (30U << 5)			// Min = 30
			| (0U >> 1)				// Sec = 0
			;
*/
}


//------------------------------------------------------------
void waitloop(long cnt)
{
	while(cnt--);
}

#define GETKEY_A 2
#define GETKEY_B 3


unsigned char getkey(char brink)
{
#define BRINKCYCLE 14000	// cursor brink time
#define NOKEYCNT 40
	char nokey=NOKEYCNT;
	unsigned char key;

//	text_setcolor(1);
//	lcd_disp();
	while(1){
//		if(sio_rxflag()){
//			key=sio_rx();	// SIO1oCgM
//			break;
//		}
		key = kb_getbuff();	// input keyboard
		if(key != 0)break;	// no data

		key=sw_get();
		if(nokey){	// input disable
			if(key==0)
				nokey--;
			else
				nokey=NOKEYCNT;
			continue;
		}

		if(key==SW_UP){
			key=KEYBOARD_UP;
			break;
		}else if(key==SW_DOWN){
			key=KEYBOARD_DOWN;
			break;
		}else if(key==SW_RIGHT){
			key=KEYBOARD_RIGHT;
			break;
		}else if(key==SW_LEFT){
			key=KEYBOARD_LEFT;
			break;
		}else if(key==SW_A){
			key=GETKEY_A;
			break;
		}else if(key==SW_B){
			key=GETKEY_B;
			break;
		}
	}

	return(key);
}
//-----------------------------------------------------
void sio_test(int baud)
{
	unsigned char key;
	char xcnt=0;	
//	unsigned int i=0;

	sio_init(baud);

	bas_print2("sio baudrate");
	bas_printd(baud);
	bas_print2("bps");

	while(1)
	{
		if(sio_rxflag()){
			bas_printhex(sio_rx());
			text_putch(' ');
			xcnt++;
			if(xcnt >= 3){
				xcnt=0;
			}
//			text_putch(sio_rx());
		}
		key = kb_getbuff();	// input keyboard
		if(key != 0){
			sio_tx(key);
		}
		if(sw_get()==SW_B){
			break;
		}
//		i++;
//		if(i==0){
//			DDRB |= (1<<4);
//			PORTB ^= (1<<4);
//			text_putch(13);
//			if(PORTB & (1<<4)){
//				text_putch('H');
//			}else{
//				text_putch('L');
//			}
//		}
	}
	sio_close();
}

//-----------------------------------------------------
//read i2c eeprom
void i2c_test(void)
{
	unsigned long addr;
	unsigned char dat_a;
	unsigned char dat_b;

	for(addr=0x0; addr<0x100; addr++)
	{
//		bas_printhex(addr >> 8);
//		bas_printhex(addr & 0xff);
//		bas_print(":");

		i2c_eeprom_read(EEPROMSLA, addr , &dat_a,1);
//		dat_a = ~dat_a;
		bas_printhex(dat_a);
//		lcd_disp();

//		i2c_eeprom_write(EEPROMSLA, addr , &dat_a,1);
//		cnt10ms = 2;
 //		while(cnt10ms){
//			lcd_disp();
//		}	//20msec waitKv

//		i2c_eeprom_read(EEPROMSLA, addr , &dat_b,1);

//		if(dat_a == dat_b){
//			bas_print2("OK");
//		}else{
//			bas_print2("NG");
//		}
//		dat_a = ~dat_a;
//		i2c_eeprom_write(EEPROMSLA, addr , &dat_a,1);
//		cnt10ms = 10;
//		while(cnt10ms){	//20msec waitKv
//			bas_print2("W");
//		}
		if(sw_get()==SW_B){
			break;
		}
	}
}


void sw_test(void)
{
	unsigned char swdata;

	bas_print2("(Press any sw)");

	while(1)
	{
		swdata=sw_get();
		if(swdata & SW_UP)    bas_print("UP ");
		if(swdata & SW_DOWN)  bas_print("DOWN ");
		if(swdata & SW_RIGHT) bas_print("RIGHT ");
		if(swdata & SW_LEFT)  bas_print("LEFT ");
		if(swdata & SW_A)     bas_print("A ");
		if(swdata)     bas_print2("");
		if(swdata & SW_B)     break;
	}
}

//---------------------------
// xmem test
void xmem_test(void)
{
	unsigned char *pxmem;
	unsigned int addr;
	unsigned char testcode;

	led_enable(0);	//LED disable

	//RAM̃f[^𔽓]ďŏƍAɔ]ď
	for(addr=0x1100; addr<=0x90FF; addr++)
	{
		bas_printhex(addr >> 8);
		bas_printhex(addr & 0xff);
		text_putch(':');

		pxmem = (unsigned char *)addr;
		testcode = ~*pxmem;		//memory read
		*pxmem = testcode;	//memory write

		if(testcode == *pxmem){
			bas_print2("OK");
		}else{
			bas_print2("NG");
		}
		*pxmem = ~testcode;	//memory write
		if(sw_get()==SW_B){
			break;
		}
	}
	led_enable(1);	//LED enable
}

//---------------------------
// font test
void fontdat_test(void)
{
	unsigned int codew=0x8140;
	unsigned int i;
	char key;

	while(1){
		for(i=0; i<(12*4); i++)
		{
			text_putchw(codew + i);
		}
		key = getkey(1);
		if (key == GETKEY_B){	//cancel
			break;
		}else if((key == KEYBOARD_LEFT)||(key == KEYBOARD_UP)){
			codew -= (12*4);
			if (codew < 0x8140)
				codew = 0x8140;
		}else if((key == KEYBOARD_RIGHT)||(key == KEYBOARD_DOWN)) {
			codew += (12*4);
			if (codew > (0x9880-(12*4)))	codew = (0x9880-(12*4));
		}
	}
}

void kanj_rom(void)
{
	FIL file;
	unsigned int addr=0;
	int i;
	char j,x,y;
	int bytecnt = 35736;	//font.dat̑Sf[^[bytes]
	unsigned char bitdata[512];
	UINT cnt;

	bas_print2("MAKE KANJI_ROM");
	bas_print2("font.dat to I2CEEPROM");
	bas_print2("[A]start  [B]cancel");
	
	if(getkey(1)==GETKEY_B)return;

	// tHgt@CJ
	if (f_open(&file, "font.dat", FA_OPEN_EXISTING | FA_READ)){

		bas_print2("card error");
		return;
	}
	x=0;
	y=32-8;
	while(bytecnt){
		f_read(&file, bitdata, 512, &cnt);
		bytecnt -= cnt;

		if(sw_get()==SW_B){
			break;
		}

		for(i=0; i<cnt; i++)
		{
			i2c_eeprom_write(EEPROMSLA, addr++ , &bitdata[i],1);
			cnt10ms = 2;
			while(cnt10ms){
				waitloop(1);
			}	//20msec waitKv

			for(j=0 ;j<8 ;j++) {
				if((0x80 >> j)& bitdata[i]){
					vram_pset(x+j, y+(i % 8), 1);
				}
			}
			if((i % 8)==7){
				x+=9;
				if(x>(122-9)){
					x=0;
					y+=9;
					if(y >= 32){
						y = (32-9);
						vram_scroll(0,9);
					}
				}
			}
		}
	}
	f_close(&file);	// t@C

	bas_print2("complate!");
}

void keyb_test(void)
{
	unsigned char ch;

	bas_print2("(Press any key)");

	while(1)
	{
		ch = kb_getbuff();
		if(ch != 0){
			text_putch(ch);
		}
		if(sw_get()==SW_B){
			break;
		}
	}
}

//------------------------------------------------
//   122/5=24
//    32/7=4
//    24*4=96
#define TEXTW (122/(FONTW+1))	//1s̕ 
#define TEXTH (32/(FONTH+1))		//1ʂ̍s
#define TEXTMAX (TEXTW*TEXTH)	//1ʂ̕


void mmc_test(void)
{
	int fn;
	FILINFO finfo;
	DIR dir;
	BYTE res;

	fn = 0;

	res = f_opendir(&dir, "/");	//Dir

	if (res) {
		bas_print2("opendir error");
		return;//error
	}

	for(;;) {
		res = f_readdir(&dir, &finfo);
		if ((res != FR_OK) || !finfo.fname[0]) break;
		if(finfo.fattrib & AM_DIR) continue;
		bas_print(finfo.fname);	//t@C\
		bas_print(" ");
	}

	bas_print2("OK");
}


//------------------------------------------------------------
//
void read_kanj(void)
{
	unsigned char key;
	int i;
	int fn,fnmax;
	FILINFO finfo;
	DIR dir;
	BYTE res;
	char filetemp[12+1]="";	// 8+3+1+1

	fn = 0;
	while(1){
		text_locate(0,0);		
		vram_clear();

		res = f_opendir(&dir, "/");	//Dir
		if (res) {
			bas_print("ERR_CARD");
			break;
		}

		for(fnmax=0 ;;) {
			res = f_readdir(&dir, &finfo);
			if ((res != FR_OK) || !finfo.fname[0]) break;
			if(finfo.fattrib & AM_DIR) continue;

			i=str_len((char *)finfo.fname);
			if(i < 4)continue;
			i -= 4;
			if(str_cmp(finfo.fname+i,".txt")) continue;
			if(fnmax==fn){
				str_cpy(filetemp,(char *)finfo.fname);
			}
			fnmax++;
		}
		bas_print2(filetemp);
		bas_printd(fn+1);
		bas_print("/");
		bas_printd(fnmax);

		key = getkey(1);
		vram_clear();
		if ((key == GETKEY_A)||(key==KEYBOARD_ENTER)){
			break;
		}else if (key == GETKEY_B){	//cancel
			filetemp[0] = '\0';//null
			break;
		}else if((key == KEYBOARD_LEFT)||(key == KEYBOARD_UP)){
			fn--;
			if (fn < 0)
				fn = fnmax-1;
		}else if((key == KEYBOARD_RIGHT)||(key == KEYBOARD_DOWN)) {
			fn++;
			if (fn >= fnmax)	fn = 0;
		}
	}

	if(filetemp[0] == '\0')
		return;	//not open

	loadtxtfile(filetemp,0);
}


//----------------------------------
void loadtxtfile (char *fname,char euc)
{
	FIL file;
	BYTE buff[512];			/* Working buffer / 1sector */
	int i;
	char loopflag = 1;
	unsigned char ch;
	unsigned char chh=0;
	UINT cnt;
	BYTE res;

	// t@CJ
	text_setcolor(1);
	res = f_open(&file, fname, FA_OPEN_EXISTING | FA_READ);
	if (res) {
		bas_print2("open err");
		//error
	}else{
		while(loopflag){
			res = f_read(&file, buff, sizeof(buff), &cnt);	//read 1sector
			if (res || (cnt == 0)) break;   // error or eof

			for(i=0; i<cnt; i++){
				ch = buff[i];
				if((ch != 13)&&(ch < 0x20)){
					continue;
				}

				if(euc){	//euc
					if(chh != 0){	//high byte = exist
				        if (chh == 0x8E) {
							// hankaku kana
						}else{
							text_putchw( euc_to_sjis(chh , ch) );
						}
						chh=0;
					}else{
						if (ch < 0x80) {
							text_putch(ch);	//normal code
						}else{
							chh = ch;
						}
					}
				}else{	//SJIS
					if(chh != 0){	//high byte = exist
						text_putchw(((unsigned int)chh << 8) | ch);
						chh=0;
					}else{			 //high byte = empty
						if((ch >= 0x81)&&(ch < 0x98)){
							chh = ch;
						}else{
							text_putch(ch);	//normal code
						}
					}
				}
				cnt10ms = 7;	//70msec
				while(cnt10ms){
					waitloop(1);
				}
				if(sw_get()==SW_B){
					loopflag=0;
					break;
				}
			}
		}
		f_close(&file);
	}
}

//--------------------------------------------------------------------

void timer_init(void)
{
	//---------------^C}荞
   	TCCR0= T0PRESCALER;   // ^C}0 vXP[ݒ
   	TCNT0 = T0STA;        // ^C}0 lݒ
    TIFR |= (1 << TOV0);  // ^C}0 OVFtONA
    TIMSK |= (1 << TOIE0); // ^C}0 OVF荞݋
}

//---------------menu
PROGMEM char pgm_menu[]=
	"SRAM_TEST\0"
	"I2C_TEST\0"
	"SIO9600\0"
	"SIO4800\0"
	"SIO2400\0"
	"FONTDAT\0"
	"MMC_TEST\0"
	"SW_TEST\0"
	"KEYB_TEST\0"
	"KANJ_ROM\0"
	"READ_KANJ\0"
;

#define MENUID_XMEM    0
#define MENUID_I2C     1
#define MENUID_SIO9600 2
#define MENUID_SIO4800 3
#define MENUID_SIO2400 4
#define MENUID_FONT    5
#define MENUID_MMC     6
#define MENUID_SW      7
#define MENUID_KEYB    8
#define MENUID_KANJROM 9
#define MENUID_READKANJ 10

#define MENUID_MAX     11


void menu(void)
{
	char cnt=0;
	unsigned char key;
	char strtemp[10];

	while(1){
		prm_strcpy(strtemp, pgm_menu, cnt);
		text_setcolor(2);	//xor
		text_locate(0,-1);
		bas_print(strtemp);
		key = getkey(1);
		text_locate(0,-1);
		bas_print(strtemp);

		if((key==GETKEY_A)||(key==KEYBOARD_ENTER)){	//A
			bas_print2("");
			if(cnt==MENUID_XMEM){
				xmem_test();
			}else if(cnt==MENUID_I2C){
				i2c_test();
			}else if(cnt==MENUID_SIO9600){
				sio_test(9600);
			}else if(cnt==MENUID_SIO4800){
				sio_test(4800);
			}else if(cnt==MENUID_SIO2400){
				sio_test(2400);
			}else if(cnt==MENUID_FONT){
				fontdat_test();
			}else if(cnt==MENUID_SW){
				sw_test();
			}else if(cnt==MENUID_MMC){
				mmc_test();
			}else if(cnt==MENUID_KEYB){
				keyb_test();
			}else if(cnt==MENUID_KANJROM){
				kanj_rom();
			}else if(cnt==MENUID_READKANJ){
				read_kanj();
			}
			bas_print2("");
//			getkey(1);	//hitany
			break;
		}else if((key==KEYBOARD_UP)||(key==KEYBOARD_LEFT)){	//
			cnt--;
			if(cnt < 0)cnt=MENUID_MAX-1;
		}else if((key==KEYBOARD_DOWN)||(key==KEYBOARD_RIGHT)){	//
			cnt++;
			if(cnt >= MENUID_MAX)cnt=0;
		}
	}
}

//-------------------------------------------------------
int main(void)
{
	sw_init();
	vram_init();
	kb_init(); // Initialize keyboard reception
	i2c_init();
	led_init();
	timer_init();

	f_mount(0, &fatfs);

	sei();

	cnt10ms = 100;	//1sec
	while(cnt10ms){
		waitloop(1);
//		bas_printhex(cnt10ms);
//		lcd_disp();
	}

	while(1)
	{
		menu();
	}
	return 0;
}



//---------------------------------------------------------------------
void bas_print(char *p)
{
	unsigned char ch;

	while(1){
		ch = *p++;
		if(ch == 0)break;
		text_putch(ch);
	}
	//lcd_disp();
}
//---------------------------------------------------------------------
void bas_print2(char *p)
{
	bas_print(p);
	text_putch(13);
//#if HARDTYPE==HARD_EDUMK2
//	lcd_disp();
//#endif
}
//---------------------------------------------------------------------


void bas_printd(int val)
{
	unsigned char tempch;
	char putflag=0;
	int ketaval=10000;

	if(val<0){
		text_putch('-');
		val=-val;
	}
	while (ketaval != 0) {
		tempch='0';
		while(val >= ketaval){
			val -= ketaval;
			tempch++;
		}
		if((ketaval==1)||(tempch!='0')) putflag=1;
		if(putflag)	text_putch(tempch);

		ketaval /= 10;
	}
	//lcd_disp();
}



//--------------------------------------------------------------

void bas_printhex(unsigned char x)
{
	unsigned char tempch;
	char shiftcnt=4;

	while (1) {
		tempch = (x >> shiftcnt) & 0xF;
		if(tempch < 10)
			tempch += '0';
		else
			tempch += ('A'-10);

		text_putch(tempch);
		if(shiftcnt==0)break;
		shiftcnt >>= 4;
	}
}

