/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NullNestPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;

public class NestedProperty
implements Property,
Serializable {
    private static final String MSG_00001 = "Illegal NestedProperty : ";
    protected Property thisProperty;
    protected Property nestProperty;

    public NestedProperty() {
    }

    public NestedProperty(Property prop, Property nestProp) {
        this.thisProperty = prop;
        this.nestProperty = nestProp;
    }

    public void setThisProperty(Property prop) {
        this.thisProperty = prop;
    }

    public Property getThisProperty() {
        return this.thisProperty;
    }

    public void setNestedProperty(Property nestProp) {
        this.nestProperty = nestProp;
    }

    public Property getNestedProperty() {
        return this.nestProperty;
    }

    public void parse(String prop) throws IllegalArgumentException {
        int index = prop.indexOf(46);
        if (index == -1 || index == 0 || index == prop.length() - 1) {
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        this.thisProperty = PropertyFactory.createProperty(prop.substring(0, index));
        this.nestProperty = PropertyFactory.createProperty(prop.substring(index + 1));
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Object thisObj = this.thisProperty.getProperty(obj);
        if (thisObj == null) {
            throw new NullNestPropertyException(obj.getClass(), this.thisProperty.getPropertyName());
        }
        return this.nestProperty.getProperty(thisObj);
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Object thisObj = this.thisProperty.getProperty(obj);
        if (thisObj == null) {
            throw new NullNestPropertyException(obj.getClass(), this.thisProperty.getPropertyName());
        }
        this.nestProperty.setProperty(thisObj, value);
    }

    public String getPropertyName() {
        return this.thisProperty.getPropertyName() + '.' + this.nestProperty.getPropertyName();
    }

    public String toString() {
        return "NestedProperty{" + this.thisProperty.toString() + '.' + this.nestProperty.toString() + '}';
    }
}

