/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NoSuchReadablePropertyException;
import jp.ossc.nimbus.beans.NoSuchWritablePropertyException;
import jp.ossc.nimbus.beans.Property;

public class SimpleProperty
implements Property,
Serializable {
    private static final String MSG_00001 = "Length of property literal must be more than 1.";
    protected static final Object[] NULL_ARGS = new Object[0];
    protected String property;
    protected transient Map getMethodCache = new HashMap();
    protected transient Map setMethodCache = new HashMap();

    public SimpleProperty() {
    }

    public SimpleProperty(String prop) throws IllegalArgumentException {
        this.setPropertyName(prop);
    }

    public void parse(String prop) throws IllegalArgumentException {
        this.setPropertyName(prop);
    }

    public String getPropertyName() {
        return this.property;
    }

    protected void setPropertyName(String prop) throws IllegalArgumentException {
        if (prop == null || prop.length() == 0) {
            throw new IllegalArgumentException(MSG_00001);
        }
        this.property = prop;
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(obj.getClass(), this.property);
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(this.property);
        }
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.getMethodCache.get(clazz);
        } else {
            PropertyDescriptor descriptor = this.getPropertyDescriptor(obj);
            readMethod = descriptor.getReadMethod();
            if (readMethod == null || readMethod.getParameterTypes().length != 0) {
                throw new NoSuchReadablePropertyException(clazz, this.property);
            }
            this.getMethodCache.put(clazz, readMethod);
        }
        try {
            return readMethod.invoke(obj, NULL_ARGS);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        if (this.property == null) {
            throw new NoSuchPropertyException(obj.getClass(), this.property);
        }
        if (obj instanceof Map) {
            ((Map)obj).put(this.property, value);
        } else {
            Class<?> clazz = obj.getClass();
            Method writeMethod = null;
            if (this.setMethodCache.containsKey(clazz)) {
                writeMethod = (Method)this.setMethodCache.get(clazz);
            } else {
                PropertyDescriptor descriptor = this.getPropertyDescriptor(obj);
                writeMethod = descriptor.getWriteMethod();
                if (writeMethod == null || writeMethod.getParameterTypes().length != 1) {
                    throw new NoSuchWritablePropertyException(clazz, this.property);
                }
                this.setMethodCache.put(clazz, writeMethod);
            }
            try {
                writeMethod.invoke(obj, value);
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(clazz, this.property, e);
            }
        }
    }

    protected PropertyDescriptor getPropertyDescriptor(Object obj) throws NoSuchPropertyException {
        Class<?> clazz = obj.getClass();
        int modifier = clazz.getModifiers();
        if (this.isAccessableClass(clazz)) {
            return this.getPropertyDescriptor(clazz);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!this.isAccessableClass(interfaces[i])) continue;
            try {
                return this.getPropertyDescriptor(interfaces[i]);
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
        }
        throw new NoSuchPropertyException(clazz, this.property);
    }

    protected boolean isAccessableClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isPublic(modifier) || (Modifier.isProtected(modifier) || !Modifier.isPublic(modifier) && !Modifier.isProtected(modifier) && !Modifier.isPrivate(modifier)) && this.getClass().getPackage().equals(clazz.getPackage());
    }

    protected PropertyDescriptor getPropertyDescriptor(Class clazz) throws NoSuchPropertyException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new NoSuchPropertyException(clazz, this.property, e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            throw new NoSuchPropertyException(clazz, this.property);
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (!this.property.equals(descriptors[i].getName())) continue;
            return descriptors[i];
        }
        throw new NoSuchPropertyException(clazz, this.property);
    }

    public String toString() {
        return super.toString() + '{' + this.property + '}';
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = new HashMap();
        this.setMethodCache = new HashMap();
    }
}

