/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.ossc.nimbus.beans.ServiceNameArrayEditor;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.ServiceNameRefArrayEditor;
import jp.ossc.nimbus.beans.ServiceNameRefEditor;
import jp.ossc.nimbus.core.DefaultServiceManagerServiceMBean;
import jp.ossc.nimbus.core.FactoryService;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.RegistrationBroadcaster;
import jp.ossc.nimbus.core.RegistrationEvent;
import jp.ossc.nimbus.core.RegistrationListener;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceBaseSupport;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.core.ServiceProxy;
import jp.ossc.nimbus.core.ServiceProxyFactory;
import jp.ossc.nimbus.core.ServiceStateBroadcaster;
import jp.ossc.nimbus.core.ServiceStateChangeEvent;
import jp.ossc.nimbus.core.ServiceStateListener;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.repository.Repository;

public class DefaultServiceManagerService
extends ServiceBase
implements ServiceManager,
RegistrationBroadcaster,
DefaultServiceManagerServiceMBean {
    private static final String SVCM_ = "SVCM_";
    private static final String SVCM_0 = "SVCM_0";
    private static final String SVCM_00 = "SVCM_00";
    private static final String SVCM_000 = "SVCM_000";
    private static final String SVCM_0000 = "SVCM_0000";
    private static final String SVCM_00001 = "SVCM_00001";
    private static final String SVCM_00002 = "SVCM_00002";
    private static final String SVCM_00003 = "SVCM_00003";
    private static final String SVCM_00004 = "SVCM_00004";
    private static final String SVCM_00005 = "SVCM_00005";
    private static final String SVCM_00006 = "SVCM_00006";
    private static final String SVCM_00007 = "SVCM_00007";
    private static final String SVCM_00008 = "SVCM_00008";
    private static final String SVCM_00009 = "SVCM_00009";
    private static final String SVCM_00010 = "SVCM_00010";
    private static final String SVCM_00011 = "SVCM_00011";
    private static final String SVCM_00012 = "SVCM_00012";
    private static final String SVCM_00013 = "SVCM_00013";
    private static final String SVCM_00014 = "SVCM_00014";
    private static final String SVCM_00024 = "SVCM_00024";
    private static final String SVCM_00025 = "SVCM_00025";
    private static final String SVCM_00026 = "SVCM_00026";
    private static final String SVCM_00027 = "SVCM_00027";
    private static final String SVCM_00028 = "SVCM_00028";
    private static final String SVCM_00029 = "SVCM_00029";
    private static final String SVCM_00030 = "SVCM_00030";
    private static final String SVCM_00031 = "SVCM_00031";
    private static final String SVCM_00032 = "SVCM_00032";
    private static final String SVCM_00033 = "SVCM_00033";
    private static final String SVCM_00034 = "SVCM_00034";
    private static final String SVCM_00035 = "SVCM_00035";
    private static final String SVCM_00036 = "SVCM_00036";
    private static final String SVCM_00037 = "SVCM_00037";
    private static final String SVCM_00038 = "SVCM_00038";
    private static final String SVCM_00039 = "SVCM_00039";
    private static final String SVCM_00040 = "SVCM_00040";
    private static final String SVCM_00041 = "SVCM_00041";
    private static final String SVCM_00042 = "SVCM_00042";
    private static final String SVCM_00043 = "SVCM_00043";
    private static final String SVCM_00044 = "SVCM_00044";
    private static final String SVCM_00045 = "SVCM_00045";
    private static final String SVCM_00046 = "SVCM_00046";
    private static final String SETTER_NAME_PREFIX = "set";
    private final Set myLoaders = new HashSet();
    private final Set managerDatas = new HashSet();
    private final Properties managerProperties = new Properties();
    private final Map waitingServices = new Hashtable();
    private final Map failedServices = new Hashtable();
    private Repository repository = new DefaultRepository();
    private List registrationListeners = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;

    public Service getService(String name) throws ServiceNotFoundException {
        Object obj = this.repository.get(name);
        if (obj == null) {
            throw new ServiceNotFoundException(this.getServiceName(), name);
        }
        Service service = null;
        service = obj instanceof Service ? (Service)obj : this.convertObjectToService(name, obj);
        return service;
    }

    public Object getServiceObject(String name) throws ServiceNotFoundException {
        Object target = this.convertServiceToObject(this.getService(name));
        if (target != null && target instanceof FactoryService) {
            target = ((FactoryService)target).newInstance();
        }
        return target;
    }

    public ServiceStateBroadcaster getServiceStateBroadcaster(String name) throws ServiceNotFoundException {
        Object obj = this.repository.get(name);
        if (obj == null) {
            throw new ServiceNotFoundException(this.getServiceName(), name);
        }
        ServiceStateBroadcaster broadcaster = null;
        if (obj instanceof ServiceStateBroadcaster) {
            broadcaster = (ServiceStateBroadcaster)obj;
        }
        return broadcaster;
    }

    public ServiceMetaData getServiceMetaData(String name) throws ServiceNotFoundException {
        Iterator loaders = this.myLoaders.iterator();
        while (loaders.hasNext()) {
            ServiceLoader loader = (ServiceLoader)loaders.next();
            ServiceMetaData serviceData = loader.getServiceMetaData(this.getServiceName(), name);
            if (serviceData == null) continue;
            return serviceData;
        }
        throw new ServiceNotFoundException(this.getServiceName(), name);
    }

    public boolean registerService(String name, Object obj) {
        return this.registerService(name, this.convertObjectToService(name, obj));
    }

    public boolean registerService(String name, Service service) {
        Logger logger = this.getLogger();
        logger.write(SVCM_00001, new Object[]{name, service});
        boolean result = this.repository.register(name, service);
        if (result) {
            service.setServiceManagerName(this.getServiceName());
            this.processRegisterd(service);
            logger.write(SVCM_00002, new Object[]{this.getServiceName(), name});
        } else {
            logger.write(SVCM_00003, new Object[]{this.getServiceName(), name});
        }
        return result;
    }

    public boolean unregisterService(String name) {
        Logger logger = this.getLogger();
        logger.write(SVCM_00004, (Object)name);
        Service service = null;
        try {
            service = this.getService(name);
        }
        catch (ServiceNotFoundException e) {
            return true;
        }
        boolean result = this.repository.unregister(name);
        if (result) {
            this.processUnregisterd(service);
            logger.write(SVCM_00005, new Object[]{this.getServiceName(), name});
        } else {
            logger.write(SVCM_00006, new Object[]{this.getServiceName(), name});
        }
        return result;
    }

    public boolean isRegisteredService(String name) {
        return this.repository.isRegistered(name);
    }

    public Set serviceNameSet() {
        return this.repository.nameSet();
    }

    public Set serviceSet() {
        return this.repository.registeredSet();
    }

    public Set serviceObjectSet() {
        Iterator serviceNames = this.serviceNameSet().iterator();
        HashSet<Object> result = new HashSet<Object>();
        while (serviceNames.hasNext()) {
            Object obj = null;
            try {
                obj = this.getServiceObject((String)serviceNames.next());
            }
            catch (ServiceNotFoundException e) {
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public boolean setServiceRepository(final String manager, final String service) {
        if (ServiceManagerFactory.isRegisteredService(manager, service) && ServiceManagerFactory.getService(manager, service).getState() == 3) {
            return this.setServiceRepository(ServiceManagerFactory.getService(manager, service));
        }
        ServiceManagerFactory.addServiceStateListener(manager, service, new ServiceStateListener(){

            public void stateChanged(ServiceStateChangeEvent e) throws Exception {
                ServiceManagerFactory.removeServiceStateListener(manager, service, this);
                DefaultServiceManagerService.this.setServiceRepository(manager, service);
            }

            public boolean isEnabledState(int st) {
                return st == 3;
            }
        });
        return false;
    }

    private boolean setServiceRepository(Service repositoryService) {
        Repository newRep = null;
        final String managerName = repositoryService.getServiceManagerName();
        final String serviceName = repositoryService.getServiceName();
        try {
            newRep = (Repository)ServiceManagerFactory.getServiceObject(managerName, serviceName);
        }
        catch (ServiceNotFoundException e) {
            return false;
        }
        boolean isReplaced = this.setServiceRepository(newRep);
        if (isReplaced) {
            ServiceManagerFactory.addServiceStateListener(managerName, serviceName, new ServiceStateListener(){

                public void stateChanged(ServiceStateChangeEvent e) throws Exception {
                    DefaultServiceManagerService.this.setServiceRepository((Repository)ServiceManagerFactory.getServiceObject(managerName, serviceName));
                }

                public boolean isEnabledState(int st) {
                    return st == 3;
                }
            });
            final DefaultRepository defaultRep = new DefaultRepository();
            ServiceManagerFactory.addServiceStateListener(managerName, serviceName, new ServiceStateListener(){

                public void stateChanged(ServiceStateChangeEvent e) throws Exception {
                    DefaultServiceManagerService.this.setServiceRepository(defaultRep);
                }

                public boolean isEnabledState(int st) {
                    return st == 5;
                }
            });
        }
        return isReplaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setServiceRepository(Repository newRep) {
        Logger logger = this.getLogger();
        Repository repository = this.repository;
        synchronized (repository) {
            String name;
            if (newRep == null || this.repository.equals(newRep)) {
                return false;
            }
            boolean success = true;
            HashSet<String> registered = new HashSet<String>();
            Iterator names = this.repository.nameSet().iterator();
            while (names.hasNext()) {
                name = (String)names.next();
                Object service = this.repository.get(name);
                if (service == null) continue;
                if (!newRep.register(name, service)) {
                    success = false;
                    continue;
                }
                registered.add(name);
            }
            if (!success) {
                names = registered.iterator();
                while (names.hasNext()) {
                    name = (String)names.next();
                    newRep.unregister(name);
                }
                logger.write(SVCM_00007, newRep);
                return false;
            }
            names = newRep.nameSet().iterator();
            while (names.hasNext()) {
                name = (String)names.next();
                this.repository.unregister(name);
            }
            this.repository = newRep;
            logger.write(SVCM_00008, newRep);
        }
        return true;
    }

    public Repository getServiceRepository() {
        return this.repository;
    }

    private Object convertServiceToObject(Service service) {
        Object child;
        Object target = service;
        while (target instanceof ServiceProxy && (child = ((ServiceProxy)target).getTarget()) != target) {
            target = child;
        }
        return target;
    }

    public Service convertObjectToService(String name, Object obj) {
        if (obj == null) {
            return null;
        }
        Service service = null;
        if (obj instanceof Service) {
            service = (Service)obj;
        } else if (obj instanceof ServiceBaseSupport) {
            ServiceBaseSupport support = (ServiceBaseSupport)obj;
            service = ServiceProxyFactory.createServiceBaseProxy(support);
        } else {
            service = ServiceProxyFactory.createServiceBaseProxy(obj);
        }
        service.setServiceManagerName(this.getServiceName());
        service.setServiceName(name);
        return service;
    }

    public void addServiceLoader(ServiceLoader loader) {
        if (!this.myLoaders.contains(loader)) {
            this.myLoaders.add(loader);
            ManagerMetaData managerData = loader.getServerMetaData().getManager(this.getServiceName());
            this.managerDatas.add(managerData);
            this.managerProperties.putAll((Map<?, ?>)managerData.getProperties());
        }
    }

    public void removeServiceLoader(ServiceLoader loader) {
        if (this.myLoaders.contains(loader)) {
            this.myLoaders.remove(loader);
            ManagerMetaData managerData = loader.getServerMetaData().getManager(this.getServiceName());
            this.managerDatas.remove(managerData);
            Iterator<Object> keys = managerData.getProperties().keySet().iterator();
            while (keys.hasNext()) {
                this.managerProperties.remove(keys.next());
            }
        }
    }

    public Set getServiceLoaders() {
        return this.myLoaders;
    }

    public Set getManagerMetaDatas() {
        return this.managerDatas;
    }

    public String getProperty(String name) {
        return this.managerProperties.getProperty(name);
    }

    protected boolean isNecessaryToCreate() {
        return true;
    }

    protected void preCreateService() throws Exception {
        Logger logger = this.getLogger();
        this.state = 0;
        this.processStateChanged(0);
        if (this.getServiceName() != null) {
            if (this.isRegisteredService(this.getServiceName())) {
                Service registeredService = this.getService(this.getServiceName());
                if (registeredService != this) {
                    logger.write(SVCM_00013, new Object[]{this.getServiceName(), this.getServiceName()});
                    this.stopService(this.getServiceName());
                    this.destroyService(this.getServiceName());
                    if (this.isRegisteredService(this.getServiceName())) {
                        this.unregisterService(this.getServiceName());
                    }
                    this.registerService(this.getServiceName(), this);
                }
            } else {
                this.registerService(this.getServiceName(), this);
            }
            if (ServiceManagerFactory.isRegisteredManager(this.getServiceName())) {
                ServiceManager registeredManager = ServiceManagerFactory.findManager(this.getServiceName());
                if (registeredManager != this) {
                    logger.write(SVCM_00014, (Object)this.getServiceName());
                    registeredManager.destroy();
                    if (ServiceManagerFactory.isRegisteredManager(this.getServiceName())) {
                        ServiceManagerFactory.unregisterManager(this.getServiceName());
                    }
                    ServiceManagerFactory.registerManager(this.getServiceName(), this);
                }
            } else {
                ServiceManagerFactory.registerManager(this.getServiceName(), this);
            }
        }
    }

    protected boolean isNecessaryToStart() throws Exception {
        if (this.state == 7 || this.state == 8) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new IllegalStateException(message.findEmbedMessage(SVCM_00009, new Object[]{this.getServiceName(), Service.STATES[this.state]}));
        }
        return true;
    }

    protected void preDestroyService() throws Exception {
        if (this.state != 5) {
            this.stop();
        }
        this.state = 6;
        this.processStateChanged(6);
        if (this.getServiceName() != null) {
            this.unregisterService(this.getServiceName());
        }
    }

    protected void postDestroyService() throws Exception {
        if (this.getServiceName() != null) {
            ServiceManagerFactory.unregisterManager(this.getServiceName());
        }
        this.state = 7;
        this.processStateChanged(7);
    }

    public void createService() throws Exception {
        this.createAllService();
    }

    public void startService() throws Exception {
        Logger logger = this.getLogger();
        MessageRecordFactory message = this.getMessageRecordFactory();
        this.startAllService();
        if (this.existWaitingService()) {
            Iterator waitingServices = this.getWaitingServices().iterator();
            while (waitingServices.hasNext()) {
                String waitingServiceName = (String)waitingServices.next();
                Set causes = this.getWaitingCauses(waitingServiceName);
                logger.write(SVCM_00024, new Object[]{this.getServiceName(), waitingServiceName, causes});
            }
        }
    }

    public void stopService() throws Exception {
        Logger logger = this.getLogger();
        this.stopAllService();
        this.clearWaitingServices();
        if (this.existFailedService()) {
            Iterator failedServiceNames = this.getFailedServices().iterator();
            while (failedServiceNames.hasNext()) {
                String name = (String)failedServiceNames.next();
                ServiceMetaData data = null;
                try {
                    data = this.getServiceMetaData(name);
                }
                catch (ServiceNotFoundException e) {
                    // empty catch block
                }
                if (data == null) continue;
                ServiceLoader loader = data.getServiceLoader();
                loader.deployService(data);
            }
            this.clearFailedServices();
        }
    }

    public void destroyService() throws Exception {
        this.destroyAllService();
    }

    public void createService(String name) throws Exception {
        this.createService(name, new HashSet());
    }

    public void createService(String name, Set completed) throws Exception {
        this.changeServiceState(name, 0, completed);
    }

    public void createService(Set names) {
        this.changeServiceState(names, 0);
    }

    public void createAllService() {
        this.changeAllServiceState(0);
    }

    public void startService(String name) throws Exception {
        this.startService(name, new HashSet());
    }

    public void startService(String name, Set completed) throws Exception {
        this.changeServiceState(name, 2, completed);
    }

    public void startService(Set names) {
        this.changeServiceState(names, 2);
    }

    public void startAllService() {
        this.changeAllServiceState(2);
    }

    public void stopService(String name) {
        this.stopService(name, new HashSet());
    }

    public void stopService(String name, Set completed) {
        Logger logger = this.getLogger();
        try {
            this.changeServiceState(name, 4, completed);
        }
        catch (Exception e) {
            logger.write(SVCM_00035, e);
        }
    }

    public void stopService(Set names) {
        this.changeServiceState(names, 4);
    }

    public void stopAllService() {
        this.changeAllServiceState(4);
    }

    public void destroyService(String name) {
        this.destroyService(name, new HashSet());
    }

    public void destroyService(String name, Set completed) {
        Logger logger = this.getLogger();
        try {
            this.changeServiceState(name, 6, completed);
        }
        catch (Exception e) {
            logger.write(SVCM_00035, e);
        }
    }

    public void destroyService(Set names) {
        this.changeServiceState(names, 6);
    }

    public void destroyAllService() {
        this.changeAllServiceState(6);
    }

    protected void changeAllServiceState(int state) {
        this.changeServiceState(this.serviceNameSet(), state);
    }

    protected void changeServiceState(Set serviceNames, int state) {
        Logger logger = this.getLogger();
        HashSet completed = new HashSet();
        String myName = this.getServiceName();
        Iterator names = serviceNames.iterator();
        block6: while (names.hasNext()) {
            String name = (String)names.next();
            if (name.equals(myName) || completed.contains(name)) continue;
            try {
                this.changeServiceState(name, state, completed);
            }
            catch (Exception e) {
                switch (this.getState()) {
                    case 0: {
                        logger.write(SVCM_00033, new Object[]{myName, name}, (Throwable)e);
                        this.destroyService(name, new HashSet());
                        this.addFailedServiceCause(name, e);
                        continue block6;
                    }
                    case 2: {
                        logger.write(SVCM_00034, new Object[]{myName, name}, (Throwable)e);
                        this.destroyService(name, new HashSet());
                        this.addFailedServiceCause(name, e);
                        continue block6;
                    }
                }
                logger.write(SVCM_00035, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeServiceState(String name, int state, Set completed) throws Exception {
        Service service = null;
        try {
            service = this.getService(name);
        }
        catch (ServiceNotFoundException e) {
            return;
        }
        if (this.getServiceName().equals(service.getServiceManagerName())) {
            Service service2 = service;
            synchronized (service2) {
                switch (state) {
                    case 0: {
                        if (completed != null && completed.contains(name)) break;
                        this.changeServiceState(service, state);
                        if (completed == null) break;
                        completed.add(name);
                        break;
                    }
                    case 2: {
                        if (!this.processDepends(this, name, state, completed)) break;
                        if (completed == null || !completed.contains(name)) {
                            this.changeServiceState(service, state);
                            if (completed != null) {
                                completed.add(name);
                            }
                        }
                        this.processDepended(this, name, state, completed);
                        break;
                    }
                    case 4: {
                        if (!this.processDepended(this, name, state, completed) || completed != null && completed.contains(name)) break;
                        this.changeServiceState(service, state);
                        if (completed == null) break;
                        completed.add(name);
                        break;
                    }
                    case 6: {
                        if (service.getState() != 5) {
                            this.changeServiceState(name, 4, new HashSet());
                        }
                        if (completed != null && completed.contains(name)) break;
                        this.changeServiceState(service, state);
                        if (completed == null) break;
                        completed.add(name);
                        break;
                    }
                    default: {
                        MessageRecordFactory message = this.getMessageRecordFactory();
                        throw new IllegalArgumentException(message.findEmbedMessage(SVCM_00010, new Object[]{this.getServiceName(), name, Service.STATES[state], this.getStateString()}));
                    }
                }
            }
        }
    }

    private void addWaitingServiceCause(ServiceName causeService, String waitService) {
        HashSet<ServiceName> causes = this.getWaitingCauses(waitService);
        if (causes == null) {
            causes = new HashSet<ServiceName>();
            this.waitingServices.put(waitService, causes);
        }
        if (!causes.contains(causeService)) {
            causes.add(causeService);
        }
    }

    private void removeWaitingServiceCause(ServiceName causeService, String waitService) {
        Set causes = this.getWaitingCauses(waitService);
        if (causes == null) {
            return;
        }
        if (causes.contains(causeService)) {
            causes.remove(causeService);
            if (causes.size() == 0) {
                this.waitingServices.remove(waitService);
            }
        }
    }

    public Set getWaitingCauses(String waitService) {
        Set causes = null;
        if (this.waitingServices.containsKey(waitService)) {
            causes = (Set)this.waitingServices.get(waitService);
        }
        return causes;
    }

    public void clearWaitingServices() {
        this.waitingServices.clear();
    }

    public boolean existWaitingService() {
        return this.waitingServices.size() != 0;
    }

    public Set getWaitingServices() {
        return this.waitingServices.keySet();
    }

    private void addFailedServiceCause(String failedService, Throwable cause) {
        this.failedServices.put(failedService, cause);
    }

    private void removeFailedServiceCause(String failedService) {
        this.failedServices.remove(failedService);
    }

    public Throwable getFailedCause(String failedService) {
        Throwable cause = null;
        if (this.failedServices.containsKey(failedService)) {
            cause = (Throwable)this.failedServices.get(failedService);
        }
        return cause;
    }

    public void clearFailedServices() {
        this.failedServices.clear();
    }

    public boolean existFailedService() {
        return this.failedServices.size() != 0;
    }

    public Set getFailedServices() {
        return this.failedServices.keySet();
    }

    private void waitServiceStateProcess(Service target, final ServiceManager manager, final String waitService, final int state, final Set completed) {
        final Logger logger = this.getLogger();
        Service targetService = null;
        if (!(target instanceof ServiceStateBroadcaster)) {
            String managerName = target.getServiceManagerName();
            ServiceManager mng = ServiceManagerFactory.findManager(managerName);
            targetService = mng;
        } else {
            targetService = target;
        }
        final ServiceStateBroadcaster broad = (ServiceStateBroadcaster)((Object)targetService);
        final ServiceName cause = new ServiceName(target.getServiceManagerName(), target.getServiceName());
        this.addWaitingServiceCause(cause, waitService);
        broad.addServiceStateListener(new ServiceStateListener(){

            public void stateChanged(ServiceStateChangeEvent e) {
                DefaultServiceManagerService.this.removeWaitingServiceCause(cause, waitService);
                broad.removeServiceStateListener(this);
                if (!completed.contains(waitService)) {
                    try {
                        switch (state) {
                            case 0: {
                                manager.createService(waitService, completed);
                                break;
                            }
                            case 2: {
                                manager.startService(waitService, completed);
                                break;
                            }
                            case 4: {
                                manager.stopService(waitService, completed);
                                break;
                            }
                            case 6: {
                                manager.destroyService(waitService, completed);
                                break;
                            }
                        }
                    }
                    catch (Exception ex) {
                        String messageId = null;
                        switch (DefaultServiceManagerService.this.getState()) {
                            case 0: {
                                messageId = DefaultServiceManagerService.SVCM_00033;
                                break;
                            }
                            case 2: {
                                messageId = DefaultServiceManagerService.SVCM_00034;
                                break;
                            }
                            default: {
                                logger.write(DefaultServiceManagerService.SVCM_00035, ex);
                                return;
                            }
                        }
                        logger.write(messageId, new Object[]{manager.getServiceName(), waitService}, (Throwable)ex);
                    }
                }
            }

            public boolean isEnabledState(int st) {
                if (state == 0) {
                    return st == 1;
                }
                if (state == 2) {
                    return st == 3;
                }
                return false;
            }
        });
        String messageId = null;
        switch (state) {
            case 0: {
                messageId = SVCM_00025;
                break;
            }
            case 2: {
                messageId = SVCM_00026;
                break;
            }
            case 4: {
                messageId = SVCM_00027;
                break;
            }
            case 6: {
                messageId = SVCM_00028;
                break;
            }
        }
        logger.write(messageId, new Object[]{targetService.getServiceManagerName(), targetService.getServiceName(), this.getServiceName(), waitService});
    }

    private void waitRegistrationManagerProcess(final String targetMng, final String targetService, final String waitService, final Set completed) {
        final Logger logger = this.getLogger();
        final ServiceName cause = new ServiceName(targetMng, targetMng);
        this.addWaitingServiceCause(cause, waitService);
        ServiceManagerFactory.addRegistrationListener(new RegistrationListener(){
            private final int state;
            {
                this.state = DefaultServiceManagerService.this.getState();
            }

            public void registered(RegistrationEvent e) {
                ServiceManager manager = (ServiceManager)e.getRegistration();
                if (!manager.getServiceName().equals(targetMng)) {
                    return;
                }
                ServiceManagerFactory.removeRegistrationListener(this);
                DefaultServiceManagerService.this.removeWaitingServiceCause(cause, waitService);
                Service service = null;
                try {
                    service = manager.getService(targetService);
                }
                catch (ServiceNotFoundException ex) {
                    DefaultServiceManagerService.this.waitRegistrationServiceProcess(manager, targetService, waitService, this.state, completed);
                    return;
                }
                if (!DefaultServiceManagerService.this.isMatchingState(service, this.state)) {
                    DefaultServiceManagerService.this.waitServiceStateProcess(service, DefaultServiceManagerService.this, waitService, this.state, completed);
                } else if (!completed.contains(waitService)) {
                    try {
                        DefaultServiceManagerService.this.changeServiceState(waitService, this.state, completed);
                    }
                    catch (Exception ex) {
                        String messageId = null;
                        switch (DefaultServiceManagerService.this.getState()) {
                            case 0: {
                                messageId = DefaultServiceManagerService.SVCM_00033;
                                break;
                            }
                            case 2: {
                                messageId = DefaultServiceManagerService.SVCM_00034;
                                break;
                            }
                            default: {
                                logger.write(DefaultServiceManagerService.SVCM_00035, ex);
                                return;
                            }
                        }
                        logger.write(messageId, new Object[]{DefaultServiceManagerService.this.getServiceName(), waitService}, (Throwable)ex);
                    }
                }
            }

            public void unregistered(RegistrationEvent e) {
            }
        });
        String messageId = null;
        switch (this.getState()) {
            case 0: {
                messageId = SVCM_00031;
                break;
            }
            case 2: {
                messageId = SVCM_00032;
                break;
            }
        }
        logger.write(messageId, new Object[]{targetMng, this.getServiceName(), waitService});
    }

    private void waitRegistrationServiceProcess(final ServiceManager targetMng, final String targetService, final String waitService, final int state, final Set completed) {
        final Logger logger = this.getLogger();
        final ServiceName cause = new ServiceName(targetMng.getServiceName(), targetService);
        this.addWaitingServiceCause(cause, waitService);
        targetMng.addRegistrationListener(new RegistrationListener(){

            public void registered(RegistrationEvent e) {
                Service service = (Service)e.getRegistration();
                if (!service.getServiceName().equals(targetService)) {
                    return;
                }
                DefaultServiceManagerService.this.removeWaitingServiceCause(cause, waitService);
                targetMng.removeRegistrationListener(this);
                if (!DefaultServiceManagerService.this.isMatchingState(service, state)) {
                    DefaultServiceManagerService.this.waitServiceStateProcess(service, DefaultServiceManagerService.this, waitService, state, completed);
                } else if (!completed.contains(waitService)) {
                    try {
                        DefaultServiceManagerService.this.changeServiceState(waitService, state, completed);
                    }
                    catch (Exception ex) {
                        String messageId = null;
                        switch (DefaultServiceManagerService.this.getState()) {
                            case 0: {
                                messageId = DefaultServiceManagerService.SVCM_00033;
                                break;
                            }
                            case 2: {
                                messageId = DefaultServiceManagerService.SVCM_00034;
                                break;
                            }
                            default: {
                                logger.write(DefaultServiceManagerService.SVCM_00035, ex);
                                return;
                            }
                        }
                        logger.write(messageId, new Object[]{DefaultServiceManagerService.this.getServiceName(), waitService}, (Throwable)ex);
                    }
                }
            }

            public void unregistered(RegistrationEvent e) {
            }
        });
        String messageId = null;
        switch (state) {
            case 0: {
                messageId = SVCM_00029;
                break;
            }
            case 2: {
                messageId = SVCM_00030;
                break;
            }
        }
        logger.write(messageId, new Object[]{targetMng.getServiceName(), targetService, this.getServiceName(), waitService});
    }

    private boolean processDepends(ServiceManager manager, String serviceName, int state, Set completed) throws Exception {
        Logger logger = this.getLogger();
        boolean result = true;
        Iterator loaders = this.myLoaders.iterator();
        while (loaders.hasNext()) {
            ServiceLoader loader = (ServiceLoader)loaders.next();
            List dependsList = loader.getDepends(manager.getServiceName(), serviceName);
            if (dependsList == null) continue;
            Iterator services = dependsList.iterator();
            while (services.hasNext()) {
                ServiceMetaData.DependsMetaData dependsData = (ServiceMetaData.DependsMetaData)services.next();
                String managerName = dependsData.getManagerName();
                String dependsServiceName = dependsData.getServiceName();
                ServiceManager mng = null;
                Service dependsService = null;
                boolean isMyService = managerName.equals(this.getServiceName());
                if (isMyService) {
                    mng = manager;
                    try {
                        dependsService = this.getService(dependsServiceName);
                    }
                    catch (ServiceNotFoundException e) {
                        dependsService = null;
                    }
                } else {
                    mng = ServiceManagerFactory.findManager(managerName);
                    if (mng == null) {
                        this.waitRegistrationManagerProcess(managerName, dependsServiceName, serviceName, completed);
                        result = false;
                        continue;
                    }
                    try {
                        dependsService = mng.getService(dependsServiceName);
                    }
                    catch (ServiceNotFoundException e) {
                        dependsService = null;
                    }
                }
                if (dependsService == null) {
                    this.waitRegistrationServiceProcess(mng, dependsServiceName, serviceName, state, completed);
                    result = false;
                    continue;
                }
                if (this.isDepends(mng, dependsServiceName, manager, serviceName)) {
                    logger.write(SVCM_00036, new Object[]{manager.getServiceName(), serviceName, mng.getServiceName(), dependsServiceName});
                    result = false;
                    continue;
                }
                if (this.isMatchingState(dependsService, state)) continue;
                if (!isMyService) {
                    this.waitServiceStateProcess(dependsService, manager, serviceName, state, completed);
                    result = false;
                    continue;
                }
                if (completed.contains(dependsServiceName)) continue;
                this.changeServiceState(dependsServiceName, state, completed);
                if (completed.contains(dependsServiceName)) continue;
                this.waitServiceStateProcess(dependsService, manager, serviceName, state, completed);
                result = false;
            }
        }
        return result;
    }

    private boolean processDepended(ServiceManager manager, String serviceName, int state, Set completed) throws Exception {
        Logger logger = this.getLogger();
        boolean result = true;
        Iterator loaders = ServiceManagerFactory.getLoaders().iterator();
        while (loaders.hasNext()) {
            ServiceLoader loader = (ServiceLoader)loaders.next();
            List dependedList = loader.getDependedServices(manager.getServiceName(), serviceName);
            Iterator services = dependedList.iterator();
            while (services.hasNext()) {
                ServiceMetaData serviceData = (ServiceMetaData)services.next();
                String dependsManagerName = serviceData.getManager().getName();
                ServiceManager mng = ServiceManagerFactory.findManager(dependsManagerName);
                if (mng == null) continue;
                String dependsServiceName = serviceData.getName();
                Service dependsService = null;
                try {
                    dependsService = mng.getService(dependsServiceName);
                }
                catch (ServiceNotFoundException e) {
                    if (state != 0) continue;
                    serviceData.getServiceLoader().deployService(serviceData);
                    dependsService = mng.getService(dependsServiceName);
                }
                if (this.isDepends(manager, serviceName, mng, dependsServiceName)) {
                    logger.write(SVCM_00036, new Object[]{manager.getServiceName(), serviceName, mng.getServiceName(), dependsServiceName});
                    result = false;
                    continue;
                }
                if (this.isMatchingState(dependsService, state) || completed.contains(dependsServiceName)) continue;
                switch (state) {
                    case 2: {
                        if (mng.getState() != 3) break;
                        mng.startService(dependsServiceName, completed);
                        break;
                    }
                    case 4: {
                        mng.stopService(dependsServiceName, completed);
                        break;
                    }
                }
            }
        }
        return result;
    }

    private boolean isDepends(ServiceManager manager1, String service1, ServiceManager manager2, String service2) {
        Iterator loaders = manager1.getServiceLoaders().iterator();
        while (loaders.hasNext()) {
            ServiceLoader loader = (ServiceLoader)loaders.next();
            List dependsList = loader.getDepends(manager1.getServiceName(), service1);
            if (dependsList == null) continue;
            Iterator services = dependsList.iterator();
            while (services.hasNext()) {
                ServiceMetaData.DependsMetaData dependsData = (ServiceMetaData.DependsMetaData)services.next();
                if (!dependsData.getServiceName().equals(service2) || !dependsData.getManagerName().equals(manager2.getServiceName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMatchingState(Service service, int state) throws IllegalStateException {
        int serviceState = service.getState();
        switch (state) {
            case 0: 
            case 1: {
                return serviceState == 1 || serviceState == 2 || serviceState == 3;
            }
            case 2: 
            case 3: {
                return serviceState == 3;
            }
            case 4: 
            case 5: {
                return serviceState == 5 || serviceState == 6 || serviceState == 7;
            }
            case 6: 
            case 7: {
                return serviceState == 7;
            }
        }
        MessageRecordFactory message = this.getMessageRecordFactory();
        throw new IllegalStateException(message.findEmbedMessage(SVCM_00011, new Object[]{this.getServiceName(), this.name, Service.STATES[state], Service.STATES[serviceState]}));
    }

    private void changeServiceState(Service service, int state) throws Exception {
        Logger logger = this.getLogger();
        String managerName = service.getServiceManagerName();
        String serviceName = service.getServiceName();
        switch (state) {
            case 0: {
                int serviceState = service.getState();
                if (serviceState == 1 || serviceState == 0 || serviceState == 3) {
                    return;
                }
                ServiceManager manager = null;
                manager = managerName.equals(this.getServiceName()) ? this : ServiceManagerFactory.findManager(managerName);
                service.create();
                try {
                    ServiceMetaData serviceData = manager.getServiceMetaData(serviceName);
                    this.setAttributes(this.convertServiceToObject(service), serviceData);
                }
                catch (ServiceNotFoundException e) {}
                break;
            }
            case 2: {
                service.start();
                break;
            }
            case 4: {
                service.stop();
                break;
            }
            case 6: {
                service.destroy();
                break;
            }
            default: {
                MessageRecordFactory message = this.getMessageRecordFactory();
                throw new IllegalStateException(message.findEmbedMessage(SVCM_00012, new Object[]{managerName, serviceName, Service.STATES[state]}));
            }
        }
    }

    private void setAttributes(Object target, ServiceMetaData serviceData) {
        if (serviceData == null) {
            return;
        }
        Map methodMap = this.getSetterMethods(serviceData);
        Iterator attrs = serviceData.getAttributes().iterator();
        while (attrs.hasNext()) {
            ServiceMetaData.AttributeMetaData attr = (ServiceMetaData.AttributeMetaData)attrs.next();
            String name = attr.getName();
            Map setters = (Map)methodMap.get(name);
            this.setAttribute(target, serviceData, attr, setters);
        }
    }

    private void setAttribute(Object target, ServiceMetaData serviceData, ServiceMetaData.AttributeMetaData attr, Map setters) {
        Logger logger = this.getLogger();
        String name = attr.getName();
        String textValue = attr.getValue();
        textValue = Utility.replaceManagerProperty(this, textValue);
        textValue = Utility.replaceSystemProperty(textValue);
        String typeStr = attr.getType();
        Class<Object> type = null;
        if (typeStr != null) {
            if (Byte.TYPE.getName().equals(typeStr)) {
                type = Byte.TYPE;
            } else if (Character.TYPE.getName().equals(typeStr)) {
                type = Character.TYPE;
            } else if (Short.TYPE.getName().equals(typeStr)) {
                type = Short.TYPE;
            } else if (Integer.TYPE.getName().equals(typeStr)) {
                type = Integer.TYPE;
            } else if (Long.TYPE.getName().equals(typeStr)) {
                type = Long.TYPE;
            } else if (Float.TYPE.getName().equals(typeStr)) {
                type = Float.TYPE;
            } else if (Double.TYPE.getName().equals(typeStr)) {
                type = Double.TYPE;
            } else {
                try {
                    type = Class.forName(typeStr, true, NimbusClassLoader.getInstance());
                }
                catch (Exception e) {
                    logger.write(SVCM_00037, new Object[]{serviceData.getManager().getName(), serviceData.getName(), name, typeStr}, (Throwable)e);
                    return;
                }
            }
        }
        Method setter = null;
        if (setters != null) {
            if (type == null) {
                type = setters.size() == 1 ? (Class)setters.keySet().iterator().next() : (class$java$lang$String == null ? (class$java$lang$String = DefaultServiceManagerService.class$("java.lang.String")) : class$java$lang$String);
            }
            setter = (Method)setters.get(type);
        }
        if (setter != null) {
            this.setAccessorAttribute(target, serviceData, setter, type, textValue);
        } else if (target instanceof Map) {
            this.setMapAttribute((Map)target, serviceData, name, type, textValue);
        } else {
            logger.write(SVCM_00038, new Object[]{serviceData.getManager().getName(), serviceData.getName(), name});
        }
    }

    private void setAccessorAttribute(Object target, ServiceMetaData serviceData, Method setter, Class type, String textValue) {
        Logger logger = this.getLogger();
        Class<?>[] params = setter.getParameterTypes();
        if (params == null || params.length != 1) {
            logger.write(SVCM_00039, new Object[]{serviceData.getManager().getName(), serviceData.getName(), setter.getName()});
            return;
        }
        Object value = null;
        try {
            value = type != null ? this.convertTextToValue(serviceData, type, textValue) : this.convertTextToValue(serviceData, params[0], textValue);
        }
        catch (Exception e) {
            logger.write(SVCM_00042, new Object[]{serviceData.getManager().getName(), serviceData.getName(), setter.getName(), textValue}, (Throwable)e);
            return;
        }
        if (value == null) {
            logger.write(SVCM_00042, new Object[]{serviceData.getManager().getName(), serviceData.getName(), setter.getName(), textValue});
            return;
        }
        try {
            setter.invoke(target, value);
            logger.write(SVCM_00045, new Object[]{serviceData.getManager().getName(), serviceData.getName(), setter.getName(), value});
        }
        catch (Exception e) {
            logger.write(SVCM_00043, new Object[]{serviceData.getManager().getName(), serviceData.getName(), setter.getName(), value}, (Throwable)e);
            return;
        }
    }

    private void setMapAttribute(Map target, ServiceMetaData serviceData, String name, Class type, String textValue) {
        Logger logger = this.getLogger();
        Object value = null;
        try {
            value = this.convertTextToValue(serviceData, type, textValue);
        }
        catch (Exception e) {
            logger.write(SVCM_00042, new Object[]{serviceData.getManager().getName(), serviceData.getName(), name, textValue}, (Throwable)e);
            return;
        }
        try {
            target.put(name, value);
            logger.write(SVCM_00046, new Object[]{serviceData.getManager().getName(), serviceData.getName(), name, value});
        }
        catch (NullPointerException e) {
            logger.write(SVCM_00044, new Object[]{serviceData.getManager().getName(), serviceData.getName(), name, value});
        }
    }

    private Object convertTextToValue(ServiceMetaData serviceData, Class type, String textValue) {
        if (type == null) {
            return textValue;
        }
        Logger logger = this.getLogger();
        PropertyEditor editor = serviceData.getServiceLoader().findEditor(type);
        if (editor == null) {
            logger.write(SVCM_00040, type);
            return null;
        }
        if (editor instanceof ServiceNameEditor) {
            ((ServiceNameEditor)editor).setServiceManagerName(serviceData.getManager().getName());
        } else if (editor instanceof ServiceNameArrayEditor) {
            ((ServiceNameArrayEditor)editor).setServiceManagerName(serviceData.getManager().getName());
        } else if (editor instanceof ServiceNameRefEditor) {
            ((ServiceNameRefEditor)editor).setServiceManagerName(serviceData.getManager().getName());
        } else if (editor instanceof ServiceNameRefArrayEditor) {
            ((ServiceNameRefArrayEditor)editor).setServiceManagerName(serviceData.getManager().getName());
        }
        editor.setAsText(textValue);
        return editor.getValue();
    }

    private Map getSetterMethods(ServiceMetaData serviceData) {
        Logger logger = this.getLogger();
        String code = serviceData.getCode();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(code, true, NimbusClassLoader.getInstance());
        }
        catch (ClassNotFoundException e) {
            logger.write(SVCM_00041, new Object[]{serviceData.getManager().getName(), serviceData.getName(), code});
            return null;
        }
        Method[] methods = clazz.getMethods();
        HashMap methodMap = new HashMap();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes = methods[i].getParameterTypes();
            if (paramTypes.length != 1) continue;
            String methodName = methods[i].getName();
            Class<?> paramType = paramTypes[0];
            Map<Class<?>, Method> typeMethods = null;
            if (methodMap.containsKey(methodName)) {
                typeMethods = (Map)methodMap.get(methodName);
            } else {
                typeMethods = new HashMap();
                methodMap.put(methodName, typeMethods);
            }
            typeMethods.put(paramType, methods[i]);
        }
        HashMap<String, Map> result = new HashMap<String, Map>();
        Iterator attrs = serviceData.getAttributes().iterator();
        while (attrs.hasNext()) {
            ServiceMetaData.AttributeMetaData attr = (ServiceMetaData.AttributeMetaData)attrs.next();
            String name = attr.getName();
            String setterName = SETTER_NAME_PREFIX + name.toUpperCase().charAt(0) + name.substring(1);
            Map typeMethods = (Map)methodMap.get(setterName);
            if (typeMethods == null) continue;
            result.put(name, typeMethods);
        }
        return result;
    }

    public void addRegistrationListener(RegistrationListener listener) {
        if (!this.registrationListeners.contains(listener)) {
            this.registrationListeners.add(listener);
        }
    }

    public void removeRegistrationListener(RegistrationListener listener) {
        this.registrationListeners.remove(listener);
    }

    protected void processRegisterd(Service service) {
        Iterator listeners = new ArrayList(this.registrationListeners).iterator();
        while (listeners.hasNext()) {
            RegistrationListener listener = (RegistrationListener)listeners.next();
            listener.registered(new RegistrationEvent(service));
        }
    }

    protected void processUnregisterd(Service service) {
        Iterator listeners = new ArrayList(this.registrationListeners).iterator();
        while (listeners.hasNext()) {
            RegistrationListener listener = (RegistrationListener)listeners.next();
            listener.unregistered(new RegistrationEvent(service));
        }
    }

    public void addServiceStateListener(final String name, final ServiceStateListener listener) {
        ServiceStateBroadcaster broadcaster;
        if (this.isRegisteredService(name) && (broadcaster = this.getServiceStateBroadcaster(name)) != null) {
            broadcaster.addServiceStateListener(listener);
        }
        this.addRegistrationListener(new RegistrationListener(){

            public void registered(RegistrationEvent e) {
                Service service = (Service)e.getRegistration();
                if (!service.getServiceName().equals(name)) {
                    return;
                }
                DefaultServiceManagerService.this.removeRegistrationListener(this);
                DefaultServiceManagerService.this.addServiceStateListener(name, listener);
            }

            public void unregistered(RegistrationEvent e) {
            }
        });
    }

    public void removeServiceStateListener(String name, ServiceStateListener listener) {
        ServiceStateBroadcaster broadcaster;
        if (this.isRegisteredService(name) && (broadcaster = this.getServiceStateBroadcaster(name)) != null) {
            broadcaster.removeServiceStateListener(listener);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DefaultRepository
    implements Repository,
    Serializable {
        private final Map serviceMap = new Hashtable();

        private DefaultRepository() {
        }

        public Object get(String name) {
            return this.serviceMap.get(name);
        }

        public boolean register(String name, Object service) {
            if (this.serviceMap.containsKey(name)) {
                return false;
            }
            this.serviceMap.put(name, service);
            return true;
        }

        public boolean unregister(String name) {
            this.serviceMap.remove(name);
            return true;
        }

        public boolean isRegistered(String name) {
            return this.serviceMap.containsKey(name);
        }

        public Set nameSet() {
            return new HashSet(this.serviceMap.keySet());
        }

        public Set registeredSet() {
            return new HashSet(this.serviceMap.entrySet());
        }
    }
}

