/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jp.ossc.nimbus.core.AspectTranslator;

public class NimbusClassLoader
extends ClassLoader {
    protected static final Map classLoader = new WeakHashMap();
    protected static final List translators = new ArrayList();
    private static final String CLASS_EXTEND = ".class";
    private boolean isLoadNotTransformClass = false;

    protected NimbusClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static synchronized NimbusClassLoader getInstance() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader instanceof NimbusClassLoader) {
            return (NimbusClassLoader)contextLoader;
        }
        NimbusClassLoader loader = (NimbusClassLoader)classLoader.get(contextLoader);
        if (loader == null) {
            loader = new NimbusClassLoader(contextLoader);
            classLoader.put(contextLoader, loader);
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAspectTranslator(AspectTranslator translator) {
        List list = translators;
        synchronized (list) {
            if (!translators.contains(translator)) {
                translators.add(translator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAspectTranslator(AspectTranslator translator) {
        List list = translators;
        synchronized (list) {
            translators.remove(translator);
        }
    }

    public void setLoadNotTransformClass(boolean isLoad) {
        this.isLoadNotTransformClass = isLoad;
    }

    public boolean isLoadNotTransformClass() {
        return this.isLoadNotTransformClass;
    }

    public synchronized Class loadClassLocally(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public synchronized Class loadClassLocally(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, true);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Class loadClass(String name, boolean resolve, boolean isLocally) throws ClassNotFoundException {
        if (translators.size() == 0) {
            return super.loadClass(name, resolve);
        }
        if (this.isNonTranslatableClassName(name)) {
            return super.loadClass(name, resolve);
        }
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        URL classUrl = this.getClassURL(name);
        if (classUrl == null) {
            return super.loadClass(name, resolve);
        }
        byte[] bytecode = this.loadByteCode(classUrl);
        if (bytecode == null) {
            return super.loadClass(name, resolve);
        }
        URL codeSourceUrl = this.getCodeSourceURL(name, classUrl);
        if (codeSourceUrl == null) {
            return super.loadClass(name, resolve);
        }
        ProtectionDomain domain = this.getProtectionDomain(codeSourceUrl);
        boolean isTransform = false;
        byte[] transformedBytes = bytecode;
        List list = translators;
        synchronized (list) {
            int max = translators.size();
            for (int i = 0; i < max; ++i) {
                AspectTranslator translator = (AspectTranslator)translators.get(i);
                byte[] tmpBytes = translator.transform(this, name, domain, transformedBytes);
                if (tmpBytes == null) continue;
                isTransform = true;
                transformedBytes = tmpBytes;
            }
        }
        if (isTransform || isLocally || this.isLoadNotTransformClass) {
            this.definePackage(name);
            Class<?> clazz = this.defineClass(name, transformedBytes, 0, transformedBytes.length, domain);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return super.loadClass(name, resolve);
    }

    protected boolean isNonTranslatableClassName(String classname) {
        return classname.startsWith("javassist.") || classname.startsWith("org.omg.") || classname.startsWith("org.w3c.") || classname.startsWith("org.xml.sax.") || classname.startsWith("sunw.") || classname.startsWith("sun.") || classname.startsWith("java.") || classname.startsWith("javax.") || classname.startsWith("com.sun.") || classname.startsWith("jp.ossc.nimbus.core.") || classname.startsWith("jp.ossc.nimbus.service.writer.") || classname.startsWith("jp.ossc.nimbus.service.message.") || classname.startsWith("jp.ossc.nimbus.service.log.");
    }

    protected void definePackage(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return;
        }
        try {
            this.definePackage(className.substring(0, index), null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected URL getClassURL(String classname) {
        String classRsrcName = classname.replace('.', '/') + CLASS_EXTEND;
        return this.getResource(classRsrcName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] loadByteCode(URL classURL) {
        byte[] bytecode = null;
        InputStream is = null;
        is = classURL.openStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] tmp = new byte[1024];
        int read = 0;
        while ((read = is.read(tmp)) > 0) {
            baos.write(tmp, 0, read);
        }
        bytecode = baos.toByteArray();
        Object var8_9 = null;
        if (is == null) return bytecode;
        try {
            is.close();
            return bytecode;
        }
        catch (IOException e2) {}
        return bytecode;
        {
            catch (IOException e) {
                byte[] byArray = null;
                Object var8_10 = null;
                if (is == null) return byArray;
                try {
                    is.close();
                    return byArray;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return byArray;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected URL getCodeSourceURL(String classname, URL classURL) {
        String classRsrcName = classname.replace('.', '/') + CLASS_EXTEND;
        String urlAsString = classURL.toString();
        int index = urlAsString.indexOf(classRsrcName);
        if (index == -1) {
            return classURL;
        }
        urlAsString = urlAsString.substring(0, index);
        try {
            return new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected ProtectionDomain getProtectionDomain(URL codesourceUrl) {
        CodeSource cs = new CodeSource(codesourceUrl, null);
        PermissionCollection permissions = Policy.getPolicy().getPermissions(cs);
        return new ProtectionDomain(cs, permissions);
    }
}

