/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.util.Iterator;
import java.util.Set;
import jp.ossc.nimbus.core.FactoryServiceBase;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceName;

public abstract class ServiceFactoryServiceBase
extends FactoryServiceBase {
    protected final Object createInstance() throws Exception {
        Service service = this.createServiceInstance();
        if (service == null) {
            return null;
        }
        if (this.isManagement() && this.getServiceManagerName() != null) {
            service.setServiceName(this.getServiceName() + '$' + this.getManagedInstanceSet().size());
            service.setServiceManagerName(this.getServiceManagerName());
        }
        if (service.getState() == 7) {
            service.create();
        }
        if (service.getState() == 1) {
            service.start();
        }
        if (service instanceof ServiceBase) {
            ServiceBase base = (ServiceBase)service;
            if (this.manager != null) {
                base.logger.setDefaultLogger(this.manager.getLogger());
                if (this.getSystemLoggerServiceName() == null) {
                    base.logger.setLogger(this.manager.getLogger());
                }
                base.message.setDefaultMessageRecordFactory(this.manager.getMessageRecordFactory());
                if (this.getSystemMessageRecordFactoryServiceName() == null) {
                    base.message.setMessageRecordFactory(this.manager.getMessageRecordFactory());
                }
            }
            if (this.getSystemLoggerServiceName() != null) {
                base.setSystemLoggerServiceName(this.getSystemLoggerServiceName());
            }
            if (this.getSystemMessageRecordFactoryServiceName() != null) {
                base.setSystemMessageRecordFactoryServiceName(this.getSystemMessageRecordFactoryServiceName());
            }
        }
        return service;
    }

    protected abstract Service createServiceInstance() throws Exception;

    protected void postStartService() throws Exception {
        super.postStartService();
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                service.start();
            }
        }
    }

    protected void postStopService() throws Exception {
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                service.stop();
            }
        }
        super.postStopService();
    }

    protected void postDestroyService() throws Exception {
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                service.destroy();
            }
        }
        super.postDestroyService();
    }

    public void setSystemLoggerServiceName(ServiceName name) {
        super.setSystemLoggerServiceName(name);
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                if (!(service instanceof ServiceBase)) continue;
                ((ServiceBase)service).setSystemLoggerServiceName(name);
            }
        }
    }

    public void setSystemMessageRecordFactoryServiceName(ServiceName name) {
        super.setSystemMessageRecordFactoryServiceName(name);
        Set managedInstances = this.getManagedInstanceSet();
        if (managedInstances != null) {
            Iterator services = managedInstances.iterator();
            while (services.hasNext()) {
                Service service = (Service)services.next();
                if (!(service instanceof ServiceBase)) continue;
                ((ServiceBase)service).setSystemMessageRecordFactoryServiceName(name);
            }
        }
    }
}

