/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class OperateFile
extends File {
    public OperateFile(String arg0) {
        super(arg0);
    }

    public OperateFile(String arg0, String arg1) {
        super(arg0, arg1);
    }

    public OperateFile(File arg0, String arg1) {
        super(arg0, arg1);
    }

    public void appendTo(String filePath) throws IOException {
        File toFile = new File(filePath);
        if (!super.exists()) {
            throw new FileNotFoundException(super.getAbsolutePath());
        }
        if (!toFile.exists()) {
            toFile.createNewFile();
        }
        this.dataMove(toFile);
    }

    public void copyTo(String filePath) throws IOException {
        File toFile = new File(filePath);
        if (!super.exists()) {
            throw new FileNotFoundException(super.getAbsolutePath());
        }
        if (toFile.exists()) {
            toFile.delete();
        }
        toFile.createNewFile();
        this.dataMove(toFile);
    }

    protected void dataMove(File toFile) throws IOException {
        InputStream is = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        try {
            is = super.toURL().openStream();
            bis = new BufferedInputStream(is);
            fos = new FileOutputStream(toFile);
            byte[] bytes = new byte[1024];
            boolean isEOF = false;
            while (!isEOF) {
                int length = bis.read(bytes, 0, 1024);
                isEOF = length == -1;
                if (isEOF) continue;
                fos.write(bytes, 0, length);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                bis.close();
                fos.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void splitFile(String filsePrefix, int splitSize, int startIndex) throws IOException {
        InputStream is = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        int readedSize = -1;
        int readSize = -1;
        File toFile = null;
        if (!super.exists()) {
            throw new FileNotFoundException(super.getAbsolutePath());
        }
        try {
            is = super.toURL().openStream();
            bis = new BufferedInputStream(is);
            boolean isEOF = false;
            while (!isEOF) {
                if (readedSize == -1) {
                    toFile = new File(filsePrefix + startIndex);
                    if (toFile.exists()) {
                        toFile.delete();
                    }
                    ++startIndex;
                    readedSize = 0;
                    fos = new FileOutputStream(toFile);
                }
                byte[] bytes = new byte[1024];
                readSize = splitSize - readedSize < 1024 ? splitSize - readedSize : 1024;
                int length = bis.read(bytes, 0, readSize);
                boolean bl = isEOF = length == -1;
                if (!isEOF) {
                    fos.write(bytes, 0, length);
                    if ((readedSize += length) < splitSize) continue;
                    fos.close();
                    readedSize = -1;
                    continue;
                }
                fos.close();
            }
        }
        finally {
            try {
                bis.close();
            }
            catch (Throwable e) {}
        }
    }
}

