/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class UnicodeHexBufferedReader
extends BufferedReader {
    public UnicodeHexBufferedReader(Reader in) {
        super(in);
    }

    public UnicodeHexBufferedReader(Reader in, int sz) {
        super(in, sz);
    }

    public String readLine() throws IOException {
        String str = super.readLine();
        if (str != null) {
            str = UnicodeHexBufferedReader.convertString(str);
        }
        return str;
    }

    public String readLineInverse() throws IOException {
        String str = super.readLine();
        if (str != null) {
            str = UnicodeHexBufferedReader.convertUnicode(str);
        }
        return str;
    }

    public static String convertUnicode(String unicodeStr) {
        String str = null;
        if (unicodeStr != null) {
            int len = unicodeStr.length();
            StringBuffer buf = new StringBuffer(len * 6);
            for (int i = 0; i < len; ++i) {
                char c = unicodeStr.charAt(i);
                buf.append('\\');
                buf.append('u');
                int mask = 61440;
                int ret = 0;
                block19: for (int j = 0; j < 4; ++j) {
                    mask = 61440 >> j * 4;
                    ret = c & mask;
                    switch (ret <<= j * 4) {
                        case 0: {
                            buf.append('0');
                            continue block19;
                        }
                        case 4096: {
                            buf.append('1');
                            continue block19;
                        }
                        case 8192: {
                            buf.append('2');
                            continue block19;
                        }
                        case 12288: {
                            buf.append('3');
                            continue block19;
                        }
                        case 16384: {
                            buf.append('4');
                            continue block19;
                        }
                        case 20480: {
                            buf.append('5');
                            continue block19;
                        }
                        case 24576: {
                            buf.append('6');
                            continue block19;
                        }
                        case 28672: {
                            buf.append('7');
                            continue block19;
                        }
                        case 32768: {
                            buf.append('8');
                            continue block19;
                        }
                        case 36864: {
                            buf.append('9');
                            continue block19;
                        }
                        case 40960: {
                            buf.append('a');
                            continue block19;
                        }
                        case 45056: {
                            buf.append('b');
                            continue block19;
                        }
                        case 49152: {
                            buf.append('c');
                            continue block19;
                        }
                        case 53248: {
                            buf.append('d');
                            continue block19;
                        }
                        case 57344: {
                            buf.append('e');
                            continue block19;
                        }
                        case 61440: {
                            buf.append('f');
                            continue block19;
                        }
                    }
                }
            }
            str = buf.toString();
        }
        return str;
    }

    public static String convertString(String unicodeAry) {
        String str = null;
        if (unicodeAry != null) {
            int len = unicodeAry.length();
            StringBuffer buf = new StringBuffer(len);
            int i = 0;
            while (i < len) {
                char c;
                if ((c = unicodeAry.charAt(i++)) == '\\' && len - 1 > i) {
                    if ((c = unicodeAry.charAt(i++)) == 'u') {
                        int value = 0;
                        block13: for (int j = 0; j < 4; ++j) {
                            c = unicodeAry.charAt(i++);
                            switch (c) {
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    value = (value << 4) + (c - 48);
                                    continue block13;
                                }
                                case 'a': 
                                case 'b': 
                                case 'c': 
                                case 'd': 
                                case 'e': 
                                case 'f': {
                                    value = (value << 4) + 10 + (c - 97);
                                    continue block13;
                                }
                                case 'A': 
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'E': 
                                case 'F': {
                                    value = (value << 4) + 10 + (c - 65);
                                    continue block13;
                                }
                                default: {
                                    throw new IllegalArgumentException("Failed to convert unicode char is " + c);
                                }
                            }
                        }
                        buf.append((char)value);
                        continue;
                    }
                    switch (c) {
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case '\\': {
                            c = '\\';
                            break;
                        }
                    }
                    buf.append(c);
                    continue;
                }
                buf.append(c);
            }
            str = buf.toString();
        }
        return str;
    }
}

