/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.ioc.ejb.command;

import java.rmi.RemoteException;
import java.util.Stack;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.ioc.Command;
import jp.ossc.nimbus.ioc.IOCException;
import jp.ossc.nimbus.ioc.ejb.UtilTool;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvoker;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorChainInvokerFactory;
import jp.ossc.nimbus.service.aspect.interfaces.InterceptorException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetCheckedException;
import jp.ossc.nimbus.service.aspect.interfaces.TargetUncheckedException;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.log.Logger;

public class SLSBCommandBean
implements SessionBean {
    private static final String C_INTERCEPTOR_SERVICE_NAME_JNDI_KEY = "java:comp/env/interceptorChainInvokerFactoryServiceNameJNDIKey";
    private static final String C_BEAN_FLOW_SERVICE_NAME_JNDI_KEY = "java:comp/env/beanFlowFactoryServiceNameJNDIKey";
    private static final String C_THREADCONTEXT_SERVICE_NAME_JNDI_KEY = "java:comp/env/threadContextServiceNameJNDIKey";
    private static final String C_LOGGER_JNDI_KEY = "java:comp/env/logger";
    private static final String C_SAVE_FLOW_KEY = "key";
    private Logger mLogger = null;
    private InterceptorChainInvokerFactory mIcFactory = null;
    private BeanFlowInvokerFactory mBfFactory = null;
    private Context mContext;

    public void ejbCreate() throws CreateException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            String value = (String)ctx.lookup(C_LOGGER_JNDI_KEY);
            ServiceName serviceName = null;
            if (value != null && value.length() > 0) {
                serviceName = UtilTool.convertServiceName(value);
                this.mLogger = (Logger)((Object)ServiceManagerFactory.getService(serviceName));
            } else {
                this.mLogger = (Logger)((Object)ServiceManagerFactory.getService(serviceName));
            }
            value = (String)ctx.lookup(C_INTERCEPTOR_SERVICE_NAME_JNDI_KEY);
            serviceName = UtilTool.convertServiceName(value);
            this.mIcFactory = (InterceptorChainInvokerFactory)((Object)ServiceManagerFactory.getService(serviceName));
            value = (String)ctx.lookup(C_BEAN_FLOW_SERVICE_NAME_JNDI_KEY);
            serviceName = UtilTool.convertServiceName(value);
            this.mBfFactory = (BeanFlowInvokerFactory)((Object)ServiceManagerFactory.getService(serviceName));
            value = (String)ctx.lookup(C_THREADCONTEXT_SERVICE_NAME_JNDI_KEY);
            serviceName = UtilTool.convertServiceName(value);
            this.mContext = (Context)((Object)ServiceManagerFactory.getService(serviceName));
        }
        catch (NamingException e) {
            CreateException ce = new CreateException("InitialContext Error");
            ce.initCause((Throwable)e);
            throw ce;
        }
    }

    public Command invokeCommand(Command cmd) {
        if (this.mLogger != null) {
            this.mLogger.write("IOC__00006");
        }
        String key = cmd.getFlowKey();
        Stack<String> cmdStack = (Stack<String>)this.mContext.get(C_SAVE_FLOW_KEY);
        if (cmdStack == null) {
            cmdStack = new Stack<String>();
            this.mContext.put(C_SAVE_FLOW_KEY, cmdStack);
        }
        cmdStack.push(key);
        this.mContext.put(C_SAVE_FLOW_KEY, key);
        InterceptorChainInvoker ici = null;
        if (this.mIcFactory != null) {
            ici = this.mIcFactory.createInterceptorInvoker(key);
        }
        Object ret = null;
        if (ici == null) {
            if (this.mLogger != null) {
                this.mLogger.write("IOC__00007");
            }
            try {
                ret = this.invokeBeanFlow(cmd.getInputObject());
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                cmd.setException(e);
            }
            catch (Throwable e) {
                throw new IOCException("SLSBCommandBean invokeCommand Unrecognize Exception", e);
            }
        } else {
            try {
                if (this.mLogger != null) {
                    this.mLogger.write("IOC__00008");
                }
                ret = ici.invokeChain(this, cmd.getInputObject());
                if (this.mLogger != null) {
                    this.mLogger.write("IOC__00012");
                }
            }
            catch (InterceptorException e) {
                if (this.mLogger != null) {
                    this.mLogger.write("IOC__00009", e);
                }
                throw new IOCException("SLSBCommandBean invokeCommand InterceptorException", e);
            }
            catch (TargetCheckedException e) {
                if (this.mLogger != null) {
                    this.mLogger.write("IOC__00010", e);
                }
                cmd.setException(e.getCause());
                return cmd;
            }
            catch (TargetUncheckedException e) {
                if (this.mLogger != null) {
                    this.mLogger.write("IOC__00011", e.getCause());
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new IOCException("SLSBCommandBean invokeCommand TargetUncheckedException", e.getCause());
            }
            catch (Throwable e) {
                throw new IOCException("SLSBCommandBean invokeCommand Unrecognize Exception", e);
            }
        }
        cmd.setOutObject(ret);
        return cmd;
    }

    public Object invokeBeanFlow(Object input) throws Exception {
        Stack stack = (Stack)this.mContext.get(C_SAVE_FLOW_KEY);
        String key = (String)stack.pop();
        if (stack.empty()) {
            this.mContext.remove(C_SAVE_FLOW_KEY);
        }
        if (this.mLogger != null) {
            this.mLogger.write("IOC__00013", (Object)key);
        }
        BeanFlowInvoker flow = this.mBfFactory.createFlow(key);
        if (this.mLogger != null && flow == null) {
            this.mLogger.write("IOC__00014");
        }
        return flow.invokeFlow(input);
    }

    public void setSessionContext(SessionContext arg0) throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }
}

