/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChain;
import jp.ossc.nimbus.service.aop.DefaultThreadLocalInterceptorChain;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.AsynchronousResponse;
import jp.ossc.nimbus.service.aop.interceptor.MethodAsynchronousInterceptorServiceMBean;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;

public class MethodAsynchronousInterceptorService
extends ServiceBase
implements Interceptor,
DaemonRunnable,
MethodAsynchronousInterceptorServiceMBean {
    private ServiceName requestQueueServiceName;
    private DefaultQueueService defaultQueue;
    private Queue requestQueue;
    private ServiceName responseQueueServiceName;
    private Queue responseQueue;
    private Daemon daemon;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Error;

    public void setRequestQueueServiceName(ServiceName name) {
        this.requestQueueServiceName = name;
    }

    public ServiceName getRequestQueueServiceName() {
        return this.requestQueueServiceName;
    }

    public void setResponseQueueServiceName(ServiceName name) {
        this.responseQueueServiceName = name;
    }

    public ServiceName getResponseQueueServiceName() {
        return this.responseQueueServiceName;
    }

    public void createService() throws Exception {
        this.daemon = new Daemon(this);
    }

    public void startService() throws Exception {
        if (this.getRequestQueueServiceName() == null) {
            if (this.getDefaultQueueService() == null) {
                DefaultQueueService defaultQueue = new DefaultQueueService();
                defaultQueue.create();
                defaultQueue.start();
                this.setDefaultQueueService(defaultQueue);
            } else {
                this.getDefaultQueueService().start();
            }
            this.setRequestQueueService(this.getDefaultQueueService());
        } else {
            this.setRequestQueueService((Queue)ServiceManagerFactory.getServiceObject(this.getRequestQueueServiceName()));
        }
        this.getResponseQueueService();
        this.daemon.start();
    }

    public void stopService() throws Exception {
        this.daemon.stop();
        if (this.getRequestQueueService() == this.getDefaultQueueService()) {
            this.getDefaultQueueService().stop();
        }
    }

    public void destroyService() {
        if (this.getRequestQueueService() == this.getDefaultQueueService() && this.getDefaultQueueService() != null) {
            this.getDefaultQueueService().destroy();
            this.setDefaultQueueService(null);
        }
        this.daemon = null;
    }

    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        if (this.getState() == 3) {
            InterceptorChain ch = chain;
            if (chain instanceof DefaultThreadLocalInterceptorChain) {
                DefaultInterceptorChain tmp = new DefaultInterceptorChain(chain.getInterceptorChainList(), chain.getInvoker());
                tmp.setCurrentInterceptorIndex(chain.getCurrentInterceptorIndex());
                ch = tmp;
            }
            this.requestQueue.push(new InvocationInfo((MethodInvocationContext)context, ch, this.getResponseQueueService()));
            return null;
        }
        return chain.invokeNext(context);
    }

    protected void setRequestQueueService(Queue queue) {
        this.requestQueue = queue;
    }

    protected Queue getRequestQueueService() {
        return this.requestQueue;
    }

    protected DefaultQueueService getDefaultQueueService() {
        return this.defaultQueue;
    }

    protected void setDefaultQueueService(DefaultQueueService queue) {
        this.defaultQueue = queue;
    }

    protected Queue getResponseQueueService() {
        if (this.getResponseQueueServiceName() == null) {
            return null;
        }
        return (Queue)ServiceManagerFactory.getServiceObject(this.getResponseQueueServiceName());
    }

    public boolean onStart() {
        return true;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) {
        return this.requestQueue.get();
    }

    public void consume(Object dequeued, DaemonControl ctrl) {
        if (dequeued == null) {
            return;
        }
        InvocationInfo info = (InvocationInfo)dequeued;
        boolean throwException = false;
        Object ret = null;
        try {
            ret = info.chain.invokeNext(info.context);
        }
        catch (Throwable e) {
            ret = e;
            throwException = true;
        }
        if (info.responseQueue != null) {
            AsynchronousResponse response = null;
            if (throwException) {
                Class<?>[] exceptionTypes = info.context.getTargetMethod().getExceptionTypes();
                boolean isThrowable = false;
                if ((class$java$lang$RuntimeException == null ? (class$java$lang$RuntimeException = MethodAsynchronousInterceptorService.class$("java.lang.RuntimeException")) : class$java$lang$RuntimeException).isInstance(ret) || (class$java$lang$Error == null ? (class$java$lang$Error = MethodAsynchronousInterceptorService.class$("java.lang.Error")) : class$java$lang$Error).isInstance(ret)) {
                    isThrowable = true;
                } else {
                    for (int i = 0; i < exceptionTypes.length; ++i) {
                        if (!exceptionTypes[i].isInstance(ret)) continue;
                        isThrowable = true;
                        break;
                    }
                }
                if (isThrowable) {
                    response = new AsynchronousResponse(ret, true);
                }
            } else if (!info.context.getTargetMethod().getReturnType().equals(Void.TYPE)) {
                response = new AsynchronousResponse(ret);
            }
            if (response != null) {
                info.responseQueue.push(response);
            }
        }
    }

    public void garbage() {
        if (this.requestQueue != null) {
            while (this.requestQueue.size() > 0) {
                this.consume(this.requestQueue.get(0), this.daemon);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class InvocationInfo
    implements Serializable {
        public MethodInvocationContext context;
        public InterceptorChain chain;
        public Queue responseQueue;

        public InvocationInfo(MethodInvocationContext context, InterceptorChain chain) {
            this(context, chain, null);
        }

        public InvocationInfo(MethodInvocationContext context, InterceptorChain chain, Queue queue) {
            this.context = context;
            this.chain = chain;
            this.responseQueue = queue;
        }
    }
}

