/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.lang.reflect.GenericDeclaration;
import java.util.HashMap;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.aop.Interceptor;
import jp.ossc.nimbus.service.aop.InterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.MethodInvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.MethodSynchronizeInterceptorServiceMBean;

public class MethodSynchronizeInterceptorService
extends ServiceBase
implements Interceptor,
MethodSynchronizeInterceptorServiceMBean {
    private static final int SCOPE_VALUE_VM = 1;
    private static final int SCOPE_VALUE_CLASS = 2;
    private static final int SCOPE_VALUE_METHOD = 3;
    private static final int SCOPE_VALUE_INSTANCE = 4;
    private String synchronizeScope;
    private int scopeValue = 4;
    private Map methods;

    public void createService() throws Exception {
        this.methods = new HashMap();
    }

    public void stopService() throws Exception {
        this.methods.clear();
    }

    public void destroyService() throws Exception {
        this.methods = null;
    }

    public void setScope(String scope) throws IllegalArgumentException {
        if ("VM".equals(scope)) {
            this.scopeValue = 1;
        } else if ("CLASS".equals(scope)) {
            this.scopeValue = 2;
        } else if ("METHOD".equals(scope)) {
            this.scopeValue = 3;
        } else if ("INSTANCE".equals(scope)) {
            this.scopeValue = 4;
        } else {
            throw new IllegalArgumentException("Illegal synchronize scope : " + scope);
        }
        this.synchronizeScope = scope;
    }

    public String getScope() {
        return this.synchronizeScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext context, InterceptorChain chain) throws Throwable {
        MethodInvocationContext ctx = (MethodInvocationContext)context;
        if (this.getState() == 3) {
            GenericDeclaration target = null;
            switch (this.scopeValue) {
                case 1: {
                    target = this.getClass();
                    break;
                }
                case 2: {
                    target = Class.forName(ctx.getTargetMethod().getDeclaringClass().getName(), true, Thread.currentThread().getContextClassLoader());
                    break;
                }
                case 3: {
                    if (!this.methods.containsKey(ctx.getTargetMethod())) {
                        target = ctx.getTargetMethod();
                        this.methods.put(target, target);
                        break;
                    }
                    target = this.methods.get(ctx.getTargetMethod());
                    break;
                }
                case 4: {
                    target = ctx.getTargetObject();
                    if (target != null) break;
                    if (!this.methods.containsKey(ctx.getTargetMethod())) {
                        target = ctx.getTargetMethod();
                        this.methods.put(target, target);
                        break;
                    }
                    target = this.methods.get(ctx.getTargetMethod());
                    break;
                }
            }
            Class<?> clazz = target;
            synchronized (clazz) {
                return chain.invokeNext(context);
            }
        }
        return chain.invokeNext(context);
    }
}

