/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aspect.metadata;

import java.io.Serializable;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.service.aspect.metadata.InterceptorNameMetaData;
import jp.ossc.nimbus.service.aspect.metadata.PatternsMetaData;
import org.w3c.dom.Element;

public class InterceptorMappingMetaData
extends MetaData
implements Serializable {
    public static final String INTERCEPTOR_MAPPING_TAG_NAME = "interceptor-mapping";
    private InterceptorNameMetaData interceptorName;
    private PatternsMetaData patterns;

    public InterceptorMappingMetaData(MetaData parent) {
        super(parent);
    }

    public PatternsMetaData getPatterns() {
        return this.patterns;
    }

    public InterceptorNameMetaData getInterceptorName() {
        return this.interceptorName;
    }

    public void importXML(Element element) throws DeploymentException {
        super.importXML(element);
        if (!element.getTagName().equals(INTERCEPTOR_MAPPING_TAG_NAME)) {
            throw new DeploymentException("Tag must be interceptor-mapping : " + element.getTagName());
        }
        Element interceptorNameElement = InterceptorMappingMetaData.getUniqueChild(element, "interceptor-name");
        this.interceptorName = new InterceptorNameMetaData(this);
        this.interceptorName.importXML(interceptorNameElement);
        Element patternsElement = InterceptorMappingMetaData.getUniqueChild(element, "patterns");
        this.patterns = new PatternsMetaData(this);
        this.patterns.importXML(patternsElement);
    }
}

