/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.service.cache.AbstractCacheMapService;
import jp.ossc.nimbus.service.cache.FileCacheMapServiceMBean;
import jp.ossc.nimbus.service.cache.FileKeyCachedReference;
import jp.ossc.nimbus.service.cache.KeyCachedReference;

public class FileCacheMapService
extends AbstractCacheMapService
implements Serializable,
FileCacheMapServiceMBean {
    private static final String FCM__ = "FCM__";
    private static final String FCM__0 = "FCM__0";
    private static final String FCM__00 = "FCM__00";
    private static final String FCM__000 = "FCM__000";
    private static final String FCM__0000 = "FCM__0000";
    private static final String FCM__00001 = "FCM__00001";
    private static final String FCM__00002 = "FCM__00002";
    private static final String JVM_TMP_DIR = "java.io.tmpdir";
    private String outputDirectory;
    private File directory;
    private String prefix;
    private String suffix = ".obj";
    private boolean isDeleteOnExitWithJVM = true;
    private boolean isLoadOnStart;
    private boolean isFileShared;
    private volatile boolean isLoading;

    public void setOutputDirectory(String path) throws IllegalArgumentException {
        if (path != null) {
            File dir = new File(path);
            if (dir.exists() ? !dir.isDirectory() : !dir.mkdirs()) {
                throw new IllegalArgumentException("Path is illegal : " + path);
            }
            this.directory = dir;
            this.outputDirectory = path;
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setFileShared(boolean isShared) {
        this.isFileShared = isShared;
    }

    public boolean isFileShared() {
        return this.isFileShared;
    }

    public void setOutputPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getOutputPrefix() {
        return this.prefix;
    }

    public void setOutputSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getOutputSuffix() {
        return this.suffix;
    }

    public void setLoadOnStart(boolean isLoad) {
        this.isLoadOnStart = isLoad;
    }

    public boolean isLoadOnStart() {
        return this.isLoadOnStart;
    }

    protected File createFile(Object key) throws IOException {
        StringBuffer buf = new StringBuffer();
        File file = null;
        file = this.directory != null ? File.createTempFile(this.createPrefix(this.prefix == null ? key.toString() : this.prefix), this.suffix, this.directory) : File.createTempFile(this.createPrefix(this.prefix == null ? key.toString() : this.prefix), this.suffix);
        if (this.isDeleteOnExitWithJVM()) {
            file.deleteOnExit();
        }
        return file;
    }

    protected String createPrefix(String prefix) {
        if (prefix.length() > 2) {
            return prefix;
        }
        StringBuffer buf = new StringBuffer(prefix);
        int max = 3 - prefix.length();
        for (int i = 0; i < max; ++i) {
            buf.append('_');
        }
        return buf.toString();
    }

    public void setDeleteOnExitWithJVM(boolean isDeleteOnExit) {
        this.isDeleteOnExitWithJVM = isDeleteOnExit;
    }

    public boolean isDeleteOnExitWithJVM() {
        return this.isDeleteOnExitWithJVM;
    }

    public void startService() throws Exception {
        if (this.isLoadOnStart()) {
            this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws Exception {
        if (this.isLoading || this.references == null) {
            return;
        }
        try {
            File tmpFile;
            String tmpFileStr;
            FileKeyCachedReference ref;
            int i;
            this.isLoading = true;
            Map map = this.references;
            synchronized (map) {
                Object[] refs = this.references.values().toArray();
                for (i = 0; i < refs.length; ++i) {
                    ref = (FileKeyCachedReference)refs[i];
                    if (ref.getFile(this).exists()) continue;
                    this.remove(ref.getKey());
                }
            }
            File dir = this.directory;
            if (dir == null && (tmpFileStr = System.getProperty(JVM_TMP_DIR)) != null && (tmpFile = new File(tmpFileStr)).exists() && tmpFile.isDirectory()) {
                dir = tmpFile;
            }
            if (dir != null) {
                File[] list = dir.listFiles(new FilenameFilter(){
                    private final String pre;
                    {
                        this.pre = FileCacheMapService.this.prefix != null ? FileCacheMapService.this.createPrefix(FileCacheMapService.this.prefix) : null;
                    }

                    public boolean accept(File dir, String name) {
                        if (this.pre == null) {
                            return name.endsWith(FileCacheMapService.this.suffix);
                        }
                        return name.startsWith(this.pre) && name.endsWith(FileCacheMapService.this.suffix);
                    }
                });
                for (i = 0; i < list.length; ++i) {
                    if (this.containsFile(list[i]) || list[i] == null || !list[i].exists()) continue;
                    try {
                        ref = new FileKeyCachedReference(list[i]);
                        this.put(ref.getKey(), ref);
                        continue;
                    }
                    catch (IOException e) {
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.isLoading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsFile(File file) {
        if (this.references == null || file == null) {
            return false;
        }
        boolean result = false;
        Map map = this.references;
        synchronized (map) {
            Iterator refs = this.references.values().iterator();
            while (refs.hasNext()) {
                FileKeyCachedReference ref = (FileKeyCachedReference)refs.next();
                if (!file.equals(ref.getFile(this))) continue;
                return true;
            }
        }
        return result;
    }

    protected KeyCachedReference createKeyCachedReference(Object key, Object obj) {
        if (key instanceof Serializable && obj instanceof Serializable) {
            File file = null;
            try {
                file = this.createFile(key);
                return new FileKeyCachedReference((Serializable)key, file, (Serializable)obj);
            }
            catch (IOException e) {
                if (file != null) {
                    file.delete();
                }
                return null;
            }
        }
        return null;
    }

    public int size() {
        if (this.references == null) {
            return 0;
        }
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        return super.size();
    }

    public boolean isEmpty() {
        if (this.references == null) {
            return true;
        }
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        return super.isEmpty();
    }

    public boolean containsKey(Object key) {
        if (this.references == null) {
            return false;
        }
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        return super.containsKey(key);
    }

    public boolean containsValue(Object value) {
        if (this.references == null) {
            return false;
        }
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        return super.containsValue(value);
    }

    public Object get(Object key) {
        if (this.references == null) {
            return null;
        }
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        return super.get(key);
    }

    protected void put(Object key, KeyCachedReference ref) {
        if (this.references == null) {
            return;
        }
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        super.put(key, ref);
    }

    public Object remove(Object key) {
        if (this.references == null) {
            return null;
        }
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        return super.remove(key);
    }

    public void putAll(Map map) {
        if (this.references == null || map == null || map.size() == 0) {
            return;
        }
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        super.putAll(map);
    }

    public void clear() {
        if (this.references == null || this.references.size() == 0) {
            return;
        }
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        super.clear();
    }

    public Set keySet() {
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        return super.keySet();
    }

    public Collection values() {
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        return super.values();
    }

    public Set entrySet() {
        if (this.isFileShared()) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.getLogger().write(FCM__00002, e);
            }
        }
        return super.entrySet();
    }
}

