/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jp.ossc.nimbus.service.cache.DefaultCachedReference;
import jp.ossc.nimbus.service.cache.IllegalCachedReferenceException;

public class FileCachedReference
extends DefaultCachedReference
implements Serializable {
    public FileCachedReference(File file) {
        super(file);
    }

    public FileCachedReference(File file, Serializable obj) throws IOException {
        super(file);
        this.serializeObject(file, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serializeObject(File file, Serializable obj) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(obj);
            Object var5_4 = null;
            if (oos == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            oos.close();
            return;
        }
        catch (IOException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object deserializeObject(File file) {
        Object entry = null;
        ObjectInputStream ois = null;
        ois = new ObjectInputStream(new FileInputStream(file));
        entry = ois.readObject();
        Object var6_4 = null;
        if (ois == null) return entry;
        try {
            ois.close();
            return entry;
        }
        catch (IOException ex) {}
        return entry;
        {
            catch (IOException e) {
                entry = null;
                Object var6_5 = null;
                if (ois == null) return entry;
                try {
                    ois.close();
                    return entry;
                }
                catch (IOException ex) {}
                return entry;
            }
            catch (ClassNotFoundException e) {
                entry = null;
                Object var6_6 = null;
                if (ois == null) return entry;
                try {
                    ois.close();
                    return entry;
                }
                catch (IOException ex) {}
                return entry;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public File getFile() {
        return (File)super.get(null, false);
    }

    public Object get(Object source, boolean notify) {
        Object obj = super.get(source, notify);
        if (obj instanceof File) {
            File file = (File)obj;
            if (file.exists() && file.canRead()) {
                return this.deserializeObject(file);
            }
            return null;
        }
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object source, Object obj) throws IllegalCachedReferenceException {
        this.notifyChange(source, obj);
        if (obj != null) {
            if (!(obj instanceof Serializable)) throw new IllegalCachedReferenceException("No serializable object : " + obj);
            try {
                this.serializeObject((File)this.cacheObj, (Serializable)obj);
                return;
            }
            catch (IOException e) {
                throw new IllegalCachedReferenceException(e);
            }
        } else {
            ((File)this.cacheObj).delete();
        }
    }

    public void remove(Object source) {
        if (this.cacheObj != null) {
            this.notifyRemoved(source);
            File file = (File)this.cacheObj;
            if (file.exists() && file.canRead()) {
                ((File)this.cacheObj).delete();
            }
            this.cacheObj = null;
            if (this.linkedReferences != null) {
                this.linkedReferences.clear();
            }
        }
    }
}

