/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.JournalRecord;
import jp.ossc.nimbus.service.journal.RequestJournal;
import jp.ossc.nimbus.service.journal.editor.CSVJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.SimpleRequestCSVJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class SimpleRequestCSVJournalEditorService
extends CSVJournalEditorServiceBase
implements SimpleRequestCSVJournalEditorServiceMBean,
Serializable {
    private static final String PERFORMANCE_UNIT = "[msec]";
    private String[] outputRecordKeys;
    private boolean isStepJournalInLine = true;
    private final Map outputElements = new HashMap();
    private String[] outputElementKeys = new String[]{"REQUEST_ID", "START_TIME", "RECORDS", "END_TIME", "PERFORMANCE"};

    public SimpleRequestCSVJournalEditorService() {
        this.defineElements();
    }

    protected void defineElements() {
        this.defineElementMaker("REQUEST_ID", new ElementMaker(){

            public Object make(EditorFinder finder, Object key, RequestJournal request) {
                return SimpleRequestCSVJournalEditorService.this.makeRequestIdFormat(finder, key, request, new StringBuffer()).toString();
            }
        });
        this.defineElementMaker("START_TIME", new ElementMaker(){

            public Object make(EditorFinder finder, Object key, RequestJournal request) {
                return SimpleRequestCSVJournalEditorService.this.makeStartTimeFormat(finder, key, request, new StringBuffer()).toString();
            }
        });
        this.defineElementMaker("RECORDS", new ElementMaker(){

            public Object make(EditorFinder finder, Object key, RequestJournal request) {
                return SimpleRequestCSVJournalEditorService.this.getRecords(finder, key, request);
            }
        });
        this.defineElementMaker("END_TIME", new ElementMaker(){

            public Object make(EditorFinder finder, Object key, RequestJournal request) {
                return SimpleRequestCSVJournalEditorService.this.makeEndTimeFormat(finder, key, request, new StringBuffer()).toString();
            }
        });
        this.defineElementMaker("PERFORMANCE", new ElementMaker(){

            public Object make(EditorFinder finder, Object key, RequestJournal request) {
                return SimpleRequestCSVJournalEditorService.this.makePerformanceFormat(finder, key, request, new StringBuffer()).toString();
            }
        });
    }

    protected void defineElementMaker(String key, ElementMaker maker) {
        this.outputElements.put(key, maker);
    }

    protected ElementMaker findElementMaker(String key) {
        return (ElementMaker)this.outputElements.get(key);
    }

    public void setOutputElementKeys(String[] keys) throws IllegalArgumentException {
        if (keys != null && keys.length != 0) {
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.outputElements.containsKey(key)) continue;
                throw new IllegalArgumentException(key + " is undefined.");
            }
            this.outputElementKeys = keys;
        }
    }

    public String[] getOutputElementKeys() {
        return this.outputElementKeys;
    }

    public void setOutputRecordKeys(String[] keys) {
        this.outputRecordKeys = keys;
    }

    public String[] getOutputRecordKeys() {
        return this.outputRecordKeys;
    }

    public void setStepJournalInLine(boolean isInLine) {
        this.isStepJournalInLine = isInLine;
    }

    public boolean isStepJournalInLine() {
        return this.isStepJournalInLine;
    }

    protected void processCSV(EditorFinder finder, Object key, Object value) {
        for (int i = 0; i < this.outputElementKeys.length; ++i) {
            ElementMaker maker = this.findElementMaker(this.outputElementKeys[i]);
            this.addElement(maker.make(finder, key, (RequestJournal)value));
        }
    }

    protected void makeCSVFormat(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        List elements = (List)this.csvElements.get();
        if (elements != null) {
            StringBuffer tmpBuf = new StringBuffer();
            ArrayList<JournalRecord> steps = null;
            if (!this.isStepJournalInLine()) {
                steps = new ArrayList<JournalRecord>();
            }
            Iterator values = elements.iterator();
            while (values.hasNext()) {
                Object val = values.next();
                if (val != null && val instanceof JournalRecord[]) {
                    JournalRecord[] records = (JournalRecord[])val;
                    int max = records.length;
                    for (int i = 0; i < max; ++i) {
                        tmpBuf.setLength(0);
                        if (!this.isStepJournalInLine() && records[i].isStep()) {
                            steps.add(records[i]);
                            continue;
                        }
                        JournalEditor editor = records[i].getJournalEditor();
                        tmpBuf.append(records[i].toObject());
                        this.escape(editor, tmpBuf);
                        this.enclose(editor, tmpBuf);
                        buf.append(tmpBuf);
                        if (i == max - 1) continue;
                        buf.append(this.getCSVSeparator());
                    }
                } else {
                    tmpBuf.setLength(0);
                    this.makeObjectFormat(finder, null, val, tmpBuf);
                    JournalEditor editor = finder.findEditor(val);
                    this.escape(editor, tmpBuf);
                    this.enclose(editor, tmpBuf);
                    buf.append(tmpBuf);
                }
                if (!values.hasNext()) continue;
                buf.append(this.getCSVSeparator());
            }
            elements.clear();
            if (!this.isStepJournalInLine() && steps.size() != 0) {
                buf.append(this.getLineSeparator());
                Iterator records = steps.iterator();
                while (records.hasNext()) {
                    JournalRecord record = (JournalRecord)records.next();
                    buf.append(record.toObject());
                    if (!records.hasNext()) continue;
                    buf.append(this.getLineSeparator());
                }
            }
        }
    }

    protected StringBuffer makeRequestIdFormat(EditorFinder finder, Object key, RequestJournal request, StringBuffer buf) {
        return buf.append(request.getRequestId());
    }

    protected StringBuffer makeStartTimeFormat(EditorFinder finder, Object key, RequestJournal request, StringBuffer buf) {
        return this.makeObjectFormat(finder, null, request.getStartTime(), buf);
    }

    protected JournalRecord[] getRecords(EditorFinder finder, Object key, RequestJournal request) {
        if (this.outputRecordKeys == null) {
            return request.getParamAry();
        }
        ArrayList<JournalRecord> list = new ArrayList<JournalRecord>();
        int max = this.outputRecordKeys.length;
        for (int i = 0; i < max; ++i) {
            JournalRecord[] records = request.findParamArys(this.outputRecordKeys[i]);
            if (records == null || records.length == 0) continue;
            for (int j = 0; j < records.length; ++j) {
                list.add(records[j]);
            }
        }
        return list.toArray(new JournalRecord[list.size()]);
    }

    protected StringBuffer makeEndTimeFormat(EditorFinder finder, Object key, RequestJournal request, StringBuffer buf) {
        return this.makeObjectFormat(finder, null, request.getEndTime(), buf);
    }

    protected StringBuffer makePerformanceFormat(EditorFinder finder, Object key, RequestJournal request, StringBuffer buf) {
        return buf.append(request.getPerformance()).append(PERFORMANCE_UNIT);
    }

    protected static interface ElementMaker {
        public Object make(EditorFinder var1, Object var2, RequestJournal var3);
    }
}

