/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jp.ossc.nimbus.service.journal.JournalRecord;
import jp.ossc.nimbus.service.journal.RequestJournal;
import jp.ossc.nimbus.service.journal.editor.MapJournalEditorServiceBase;
import jp.ossc.nimbus.service.journal.editor.SimpleRequestMapJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class SimpleRequestMapJournalEditorService
extends MapJournalEditorServiceBase
implements SimpleRequestMapJournalEditorServiceMBean,
Serializable {
    private boolean isOutputSeparator = true;
    private boolean isOutputRequestId = true;
    private boolean isOutputStartTime = true;
    private boolean isOutputRecords = true;
    private boolean isOutputEndTime = true;
    private boolean isOutputPerformance = true;
    private String[] outputRecordKeys;

    public void setOutputRequestId(boolean isOutput) {
        this.isOutputRequestId = isOutput;
    }

    public boolean isOutputRequestId() {
        return this.isOutputRequestId;
    }

    public void setOutputStartTime(boolean isOutput) {
        this.isOutputStartTime = isOutput;
    }

    public boolean isOutputStartTime() {
        return this.isOutputStartTime;
    }

    public void setOutputRecords(boolean isOutput) {
        this.isOutputRecords = isOutput;
    }

    public boolean isOutputRecords() {
        return this.isOutputRecords;
    }

    public void setOutputEndTime(boolean isOutput) {
        this.isOutputEndTime = isOutput;
    }

    public boolean isOutputEndTime() {
        return this.isOutputEndTime;
    }

    public void setOutputPerformance(boolean isOutput) {
        this.isOutputPerformance = isOutput;
    }

    public boolean isOutputPerformance() {
        return this.isOutputPerformance;
    }

    public void setOutputRecordKeys(String[] keys) {
        this.outputRecordKeys = keys;
    }

    public String[] getOutputRecordKeys() {
        return this.outputRecordKeys;
    }

    public Map toMap(EditorFinder finder, Object key, Object value) {
        RequestJournal request = (RequestJournal)value;
        HashMap result = new HashMap();
        if (this.isOutputRequestId()) {
            this.makeRequestIdFormat(finder, key, request, result);
        }
        if (this.isOutputStartTime()) {
            this.makeStartTimeFormat(finder, key, request, result);
        }
        if (this.isOutputRecords()) {
            this.makeRecordsFormat(finder, key, request, result);
        }
        if (this.isOutputEndTime()) {
            this.makeEndTimeFormat(finder, key, request, result);
        }
        if (this.isOutputPerformance()) {
            this.makePerformanceFormat(finder, key, request, result);
        }
        return result;
    }

    protected Map makeRequestIdFormat(EditorFinder finder, Object key, RequestJournal request, Map map) {
        map.put("RequestID", request.getRequestId());
        return map;
    }

    protected Map makeStartTimeFormat(EditorFinder finder, Object key, RequestJournal request, Map map) {
        map.put("StartTime", this.makeObjectFormat(finder, key, request.getStartTime()));
        return map;
    }

    protected Map makeRecordsFormat(EditorFinder finder, Object key, RequestJournal request, Map map) {
        JournalRecord[] records = request.getParamAry();
        if (records.length == 0) {
            return map;
        }
        TreeMap subMap = new TreeMap();
        if (this.outputRecordKeys == null) {
            records = request.getParamAry();
            this.makeRecordsFormat(finder, records, subMap);
        } else {
            int max = this.outputRecordKeys.length;
            for (int i = 0; i < max; ++i) {
                records = request.findParamArys(this.outputRecordKeys[i]);
                if (records == null || records.length == 0) continue;
                this.makeRecordsFormat(finder, records, subMap);
            }
        }
        map.put("JournalRecords", subMap);
        return map;
    }

    private Map makeRecordsFormat(EditorFinder finder, JournalRecord[] records, SortedMap map) {
        int max = records.length;
        for (int i = 0; i < max; ++i) {
            if (!map.containsKey(records[i].getKey())) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(records[i].toObject());
                map.put(records[i].getKey(), list);
                continue;
            }
            ((List)map.get(records[i].getKey())).add(records[i].toObject());
        }
        return map;
    }

    protected Map makeEndTimeFormat(EditorFinder finder, Object key, RequestJournal request, Map map) {
        map.put("EndTime", this.makeObjectFormat(finder, key, request.getEndTime()));
        return map;
    }

    protected Map makePerformanceFormat(EditorFinder finder, Object key, RequestJournal request, Map map) {
        map.put("Performance", new Long(request.getPerformance()));
        return map;
    }
}

