/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.msgresource;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.QueueSession;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.byteconvert.ByteConverter;
import jp.ossc.nimbus.service.msgresource.CommonMessageFormat;
import jp.ossc.nimbus.service.msgresource.MessageFormat;
import jp.ossc.nimbus.service.msgresource.MessageResourceDefine;
import jp.ossc.nimbus.service.msgresource.PropItem;
import jp.ossc.nimbus.util.CsvArrayList;
import org.w3c.dom.Element;

public class MapMessageFormat
extends CommonMessageFormat
implements MessageFormat,
MessageResourceDefine {
    private ArrayList mPayloadItems = new ArrayList();

    public MapMessageFormat(ByteConverter converter) {
        super(converter);
    }

    public String marshal(Message msg) {
        if (!(msg instanceof MapMessage)) {
            return null;
        }
        StringBuffer ret = new StringBuffer("[property]");
        ret.append(this.dumpProperties(msg));
        ret.append("[payload]");
        try {
            MapMessage mapMsg = (MapMessage)msg;
            Enumeration names = mapMsg.getMapNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                ret.append(name);
                ret.append("=");
                Object value = mapMsg.getObject(name);
                ret.append(value);
                ret.append(" ");
            }
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY201", "Fail to marshal PayLoad.");
        }
        return ret.toString();
    }

    public Message unMarshal(QueueSession session) {
        MapMessage mapMsg = null;
        try {
            mapMsg = session.createMapMessage();
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY202", "PayLoad Setting failed.", e);
        }
        String recordStr = null;
        Properties prop = null;
        if (this.mMessageInput != null) {
            recordStr = this.mMessageInput.getInputString();
            prop = this.mMessageInput.getMessageHeadProp();
            this.mMessageInput.nextLine();
        }
        this.setMessageHeadProperties((Message)mapMsg, prop);
        this.setPayload(mapMsg, recordStr);
        return mapMsg;
    }

    protected void recvPayloadParse(Element elem) {
    }

    protected void sendPayloadParse(Element elem, boolean inputFileExists) {
        this.propKindParse(elem, inputFileExists, this.mPayloadItems, "payload");
    }

    protected void setPayload(MapMessage msg, String payloadStr) {
        Properties payloadProp = new Properties();
        CsvArrayList payloadArrayList = new CsvArrayList();
        payloadArrayList.split(payloadStr);
        for (int rCnt = 0; rCnt < payloadArrayList.size(); ++rCnt) {
            String keyAndVal = payloadArrayList.getStr(rCnt);
            int pos = keyAndVal.indexOf("=");
            if (pos <= 0 || pos >= keyAndVal.length() - 1) {
                throw new ServiceException("MESSAGERESOURCEFACTORY203", "Invalid description on data file. [" + keyAndVal + "]");
            }
            String key = keyAndVal.substring(0, pos);
            String val = keyAndVal.substring(pos + 1);
            payloadProp.put(key, val);
        }
        Iterator Items = this.mPayloadItems.iterator();
        try {
            while (Items.hasNext()) {
                PropItem item = (PropItem)Items.next();
                int type = item.getType();
                String valueStr = null;
                String name = item.getName();
                valueStr = item.useFile() ? (String)payloadProp.get(name) : item.getVal();
                switch (type) {
                    case 0: {
                        byte[] tmp = this.mByteConverter.hex2byte(valueStr);
                        msg.setByte(name, tmp[0]);
                        break;
                    }
                    case 2: {
                        byte[] tmp = this.mByteConverter.hex2byte(valueStr);
                        msg.setBytes(name, tmp);
                        break;
                    }
                    case 4: {
                        msg.setChar(name, valueStr.charAt(0));
                        break;
                    }
                    case 3: {
                        Boolean bool = Boolean.valueOf(valueStr);
                        msg.setBoolean(name, bool.booleanValue());
                        break;
                    }
                    case 5: {
                        msg.setShort(name, Short.parseShort(valueStr));
                        break;
                    }
                    case 7: {
                        msg.setInt(name, Integer.parseInt(valueStr));
                        break;
                    }
                    case 8: {
                        msg.setLong(name, Long.parseLong(valueStr));
                        break;
                    }
                    case 9: {
                        msg.setFloat(name, Float.parseFloat(valueStr));
                        break;
                    }
                    case 10: {
                        msg.setDouble(name, Double.parseDouble(valueStr));
                        break;
                    }
                    case 12: {
                        msg.setString(name, valueStr);
                        break;
                    }
                    case 13: {
                        Object obj = this.createObject(item.getWrappedType(), valueStr);
                        msg.setObject(name, obj);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("MESSAGERESOURCEFACTORY204", "Property Setting failed.", e);
        }
    }
}

