/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.performance;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.ListIterator;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.performance.FileReportPerformanceStatisticsServiceMBean;
import jp.ossc.nimbus.service.performance.PerformanceRecord;
import jp.ossc.nimbus.service.performance.PerformanceRecordOperator;
import jp.ossc.nimbus.service.performance.PerformanceStatistics;
import jp.ossc.nimbus.service.performance.WriterDaemonRunnable;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.writer.MessageWriter;
import jp.ossc.nimbus.service.writer.WritableRecordFactoryService;
import jp.ossc.nimbus.util.CsvArrayList;

public class FileReportPerformanceStatisticsService
extends ServiceBase
implements PerformanceStatistics,
FileReportPerformanceStatisticsServiceMBean,
DaemonRunnable {
    private static final String C_DEFAULT_INTERVAL = "600";
    private static final String C_SEP = "---";
    private static final String C_FORMAT = "yyyy-MM-dd HH-mm-ss";
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
    protected String mSortKey;
    protected String mIntervalSec = "600";
    protected ServiceName mWritableRecordFactoryName;
    protected WritableRecordFactoryService mWritableRecFac;
    protected ServiceName mWriterName;
    protected MessageWriter mWriter;
    protected ServiceName mQueueName;
    protected Queue mQueue;
    private DefaultQueueService defaultQueue;
    protected Daemon mPerformDaemon;
    protected Daemon mWriterDaemon;
    protected Hashtable mHash = null;
    protected String mClassName = null;
    protected Class mClsRec = null;

    public void createService() throws Exception {
        this.mHash = new Hashtable(1024, 256.0f);
    }

    public void startService() throws Exception {
        if (this.mClsRec == null) {
            throw new ServiceException("PEFORMANCE010", "RecordClass is null");
        }
        this.mWriter = (MessageWriter)ServiceManagerFactory.getServiceObject(this.mWriterName);
        this.mWritableRecFac = (WritableRecordFactoryService)ServiceManagerFactory.getServiceObject(this.mWritableRecordFactoryName);
        if (this.getQueueServiceName() == null) {
            if (this.getDefaultQueueService() == null) {
                DefaultQueueService defaultQueue = new DefaultQueueService();
                defaultQueue.create();
                defaultQueue.start();
                this.setDefaultQueueService(defaultQueue);
            } else {
                this.getDefaultQueueService().start();
            }
            this.mQueue = this.getDefaultQueueService();
        } else {
            this.mQueue = (Queue)ServiceManagerFactory.getServiceObject(this.getQueueServiceName());
        }
        if (this.mIntervalSec == null || "".equals(this.mIntervalSec)) {
            this.mIntervalSec = C_DEFAULT_INTERVAL;
        } else {
            try {
                long interval = Long.parseLong(this.mIntervalSec);
            }
            catch (Exception ex) {
                throw new ServiceException("PEFORMANCE013", "interval setting invalid", ex);
            }
        }
        this.mPerformDaemon = new Daemon(this);
        this.mWriterDaemon = new Daemon(new WriterDaemonRunnable(this));
        this.mPerformDaemon.start();
        this.mWriterDaemon.start();
    }

    public void stopService() throws Exception {
        this.clear();
        this.mPerformDaemon.stop();
        this.mWriterDaemon.stop();
        if (this.mQueue == this.getDefaultQueueService()) {
            this.getDefaultQueueService().stop();
        }
    }

    public void destroyService() throws Exception {
        this.mHash = null;
        this.mClassName = null;
        this.mClsRec = null;
        if (this.mQueue == this.getDefaultQueueService()) {
            this.getDefaultQueueService().destroy();
            this.setDefaultQueueService(null);
        }
    }

    public void entry(String key, long msec) {
        if (key == null || key.length() == 0) {
            return;
        }
        ArrayList<Object> enqueueList = new ArrayList<Object>(2);
        enqueueList.add(key);
        enqueueList.add(new Long(msec));
        this.mQueue.push(enqueueList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Hashtable hashtable = this.mHash;
        synchronized (hashtable) {
            this.mHash.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] toStringAry(int sortKey, boolean isUpset) {
        ArrayList sortList = new ArrayList();
        CsvArrayList retAry = new CsvArrayList();
        Hashtable tb = null;
        Hashtable hashtable = this.mHash;
        synchronized (hashtable) {
            tb = (Hashtable)this.mHash.clone();
        }
        Object object = tb.elements();
        while (object.hasMoreElements()) {
            PerformanceRecord item = (PerformanceRecord)object.nextElement();
            if (item == null) continue;
            this._sortList(sortList, item, sortKey, isUpset);
        }
        retAry.add(C_SEP);
        retAry.add(FileReportPerformanceStatisticsService.getNowDate());
        object = sortList.listIterator();
        while (object.hasNext()) {
            String sortItem = (String)object.next();
            CsvArrayList keyAry = new CsvArrayList();
            keyAry.split(sortItem, ";");
            if (!this.mHash.containsKey(keyAry.getStr(0))) continue;
            PerformanceRecord item = (PerformanceRecord)this.mHash.get(keyAry.getStr(0));
            retAry.add(((Object)item).toString());
        }
        String[] retStrAry = retAry.toStringAry();
        return retStrAry;
    }

    private void _sortList(ArrayList sortList, PerformanceRecord item, int sortKey, boolean isUpset) {
        Long tmpLong;
        if (sortList == null || item == null) {
            return;
        }
        String cmpKey = "";
        if (sortKey == 0) {
            cmpKey = item.getResourceId();
        } else if (sortKey == 1) {
            tmpLong = new Long(item.getBestPerformance());
            cmpKey = tmpLong.toString();
        } else if (sortKey == 2) {
            tmpLong = new Long(item.getWorstPerformance());
            cmpKey = tmpLong.toString();
        } else if (sortKey == 3) {
            tmpLong = new Long(item.getAveragePerformance());
            cmpKey = tmpLong.toString();
        } else if (sortKey == 4) {
            tmpLong = new Long(item.getCallTime());
            cmpKey = tmpLong.toString();
        }
        String rscId = item.getResourceId() + ";" + cmpKey;
        int entryCnt = 0;
        ListIterator listIterator = sortList.listIterator();
        while (listIterator.hasNext()) {
            String destCmp = (String)listIterator.next();
            CsvArrayList parse = new CsvArrayList();
            parse.split(destCmp, ";");
            int ret = cmpKey.compareTo(parse.getStr(1));
            if (isUpset ? ret <= 0 : ret >= 0) break;
            ++entryCnt;
        }
        sortList.add(entryCnt, rscId);
    }

    public void setRecordClassName(String className) throws ServiceException {
        this.mClassName = className;
        if (className == null || className.length() == 0) {
            this.mClsRec = null;
        } else {
            try {
                this.mClsRec = Class.forName(className, true, NimbusClassLoader.getInstance());
            }
            catch (ClassNotFoundException e) {
                throw new ServiceException("PEFORMANCE010", "ClassNotFoundException classnamse = " + className, e);
            }
        }
    }

    public String getRecordClassName() {
        return this.mClassName;
    }

    public void setQueueServiceName(ServiceName name) {
        this.mQueueName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.mQueueName;
    }

    protected DefaultQueueService getDefaultQueueService() {
        return this.defaultQueue;
    }

    protected void setDefaultQueueService(DefaultQueueService queue) {
        this.defaultQueue = queue;
    }

    public void setWriterServiceName(ServiceName name) {
        this.mWriterName = name;
    }

    public ServiceName getWriterServiceName() {
        return this.mWriterName;
    }

    public void setWriteableRecordFactoryServiceName(ServiceName name) {
        this.mWritableRecordFactoryName = name;
    }

    public ServiceName getWriteableRecordFactoryServiceName() {
        return this.mWritableRecordFactoryName;
    }

    public void setWritableInterval(String intervalSec) {
        this.mIntervalSec = intervalSec;
    }

    public String getWritableInterval() {
        return this.mIntervalSec;
    }

    public void setSortKey(String inSortKey) {
        this.mSortKey = inSortKey;
    }

    public String getSortKey() {
        return this.mSortKey;
    }

    public boolean onStop() {
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) {
        return this.mQueue.get();
    }

    public void consume(Object paramObj, DaemonControl ctrl) throws ServiceException {
        if (paramObj == null) {
            return;
        }
        ArrayList entryList = (ArrayList)paramObj;
        String key = (String)entryList.get(0);
        long msec = (Long)entryList.get(1);
        PerformanceRecordOperator performanceObj = null;
        performanceObj = (PerformanceRecordOperator)this.mHash.get(key);
        if (performanceObj != null) {
            performanceObj.entry(msec);
        } else {
            try {
                performanceObj = (PerformanceRecordOperator)this.mClsRec.newInstance();
            }
            catch (InstantiationException e) {
                throw new ServiceException("PEFORMANCE001", "InstantiationException", e);
            }
            catch (IllegalAccessException e) {
                throw new ServiceException("PEFORMANCE001", "IllegalAccessException", e);
            }
            performanceObj.setResourceId(key);
            performanceObj.entry(msec);
            this.mHash.put(key, performanceObj);
        }
    }

    public void garbage() {
        if (this.mQueue == null) {
            return;
        }
        while (this.mQueue.size() > 0) {
            Object obj = this.mQueue.get();
            try {
                this.consume(obj, this.mPerformDaemon);
            }
            catch (Exception exception) {}
        }
    }

    public boolean onStart() {
        return true;
    }

    private static final String getNowDate() {
        return formatter.format(new Date());
    }
}

