/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import java.util.ArrayList;
import java.util.ListIterator;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import jp.ossc.nimbus.daemon.Daemon;
import jp.ossc.nimbus.daemon.DaemonControl;
import jp.ossc.nimbus.daemon.DaemonRunnable;
import jp.ossc.nimbus.service.publish.IfServant;
import jp.ossc.nimbus.service.publish.ServantGarbager;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.resource.jmstopic.TopicTransanctionResource;

public class PublishContainer
implements DaemonRunnable,
MessageListener {
    private ArrayList mClientArray = new ArrayList(1024);
    private int mMaxClientNum = 0;
    private Queue mTranQueue = null;
    private Daemon mGarbageDaemon = null;
    private int mGavageIntervalMinutes = 0;
    private TopicTransanctionResource[] mTransanctionResource = null;
    private Topic[] mTopic = null;

    public void setMaxClientNum(int maxClient) {
        this.mMaxClientNum = maxClient;
    }

    public int getMaxClientNum() {
        return this.mMaxClientNum;
    }

    public void setGarbageIntervalMinutes(int garbageInterval) {
        this.mGavageIntervalMinutes = garbageInterval;
    }

    public void setQueue(Queue q) {
        this.mTranQueue = q;
    }

    public void setTopicTransanctionResource(TopicTransanctionResource[] rsc) {
        this.mTransanctionResource = rsc;
    }

    public void setTopic(Topic[] tpc) {
        this.mTopic = tpc;
    }

    public int size() {
        return this.mClientArray.size();
    }

    protected void insTranMessage(Object msg) {
        this.mTranQueue.push(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addClient(IfServant client) {
        if (this.mClientArray.size() >= this.mMaxClientNum) {
            return false;
        }
        ArrayList arrayList = this.mClientArray;
        synchronized (arrayList) {
            System.out.println("Client is Added!!");
            this.mClientArray.add(client);
        }
        return true;
    }

    public boolean onStop() {
        for (int cnt = 0; cnt < this.mTransanctionResource.length; ++cnt) {
            try {
                this.mTransanctionResource[cnt].close();
                continue;
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        try {
            this.mGarbageDaemon.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public boolean onSuspend() {
        return true;
    }

    public boolean onResume() {
        return true;
    }

    public Object provide(DaemonControl ctrl) throws Throwable {
        return this.mTranQueue.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Object paramObj, DaemonControl ctrl) throws Throwable {
        if (paramObj != null) {
            ArrayList arrayList = this.mClientArray;
            synchronized (arrayList) {
                ListIterator ite = this.mClientArray.listIterator();
                while (ite.hasNext()) {
                    IfServant sv = (IfServant)ite.next();
                    if (sv.sendMessage(paramObj)) continue;
                    ite.remove();
                }
            }
        }
    }

    public void garbage() {
        this.mClientArray.clear();
        this.mTranQueue.clear();
    }

    public boolean onStart() {
        ServantGarbager gb = new ServantGarbager(this.mClientArray, this.mGavageIntervalMinutes);
        this.mGarbageDaemon = new Daemon(gb);
        this.mGarbageDaemon.start();
        try {
            this.entryTopicListener();
        }
        catch (JMSException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void entryTopicListener() throws JMSException {
        if (this.mTransanctionResource != null) {
            for (int cnt = 0; cnt < this.mTransanctionResource.length; ++cnt) {
                TopicSubscriber subscriber = ((TopicSession)this.mTransanctionResource[cnt].getObject()).createSubscriber(this.mTopic[cnt]);
                subscriber.setMessageListener((MessageListener)this);
                this.mTransanctionResource[cnt].getConnection().start();
            }
        }
    }

    public void onMessage(Message arg0) {
        Object obj = null;
        if (arg0 instanceof ObjectMessage) {
            ObjectMessage msg = (ObjectMessage)arg0;
            try {
                obj = msg.getObject();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        } else if (arg0 instanceof TextMessage) {
            TextMessage msg = (TextMessage)arg0;
            try {
                obj = msg.getText();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
        if (obj != null) {
            this.insTranMessage(obj);
        }
    }
}

