/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.publish;

import javax.jms.Topic;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.publish.PublishContainer;
import jp.ossc.nimbus.service.publish.PublishContainerFactoryServiceMBean;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.resource.ResourceFactory;
import jp.ossc.nimbus.service.resource.jmstopic.TopicTransanctionResource;

public class PublishContainerFactoryService
extends ServiceBase
implements PublishContainerFactoryServiceMBean {
    private ServiceName mQueueFactoryServiceName = null;
    private String[] mTopicNames = null;
    private Topic[] mTopics = null;
    private ServiceName[] mTopicJndiServiceNames = null;
    private JndiFinder[] mJndiFinder = null;
    private ServiceName[] mTopicResourceServieNames = null;
    private ResourceFactory[] mResourceFactory = null;
    private TopicTransanctionResource[] mTopicResources = null;
    private int mMaxClientSize = 50;
    private int mGavageIntervalMinutes = 3;
    private ServiceName mLogServiceName = null;
    private Logger mLogger = null;

    public void startService() throws Exception {
        int cnt;
        this.mJndiFinder = new JndiFinder[this.mTopicJndiServiceNames.length];
        for (cnt = 0; cnt < this.mTopicJndiServiceNames.length; ++cnt) {
            this.mJndiFinder[cnt] = (JndiFinder)ServiceManagerFactory.getServiceObject(this.mTopicJndiServiceNames[cnt]);
        }
        this.mResourceFactory = new ResourceFactory[this.mTopicResourceServieNames.length];
        for (cnt = 0; cnt < this.mTopicResourceServieNames.length; ++cnt) {
            this.mResourceFactory[cnt] = (ResourceFactory)ServiceManagerFactory.getServiceObject(this.mTopicResourceServieNames[cnt]);
        }
        this.mLogger = (Logger)ServiceManagerFactory.getServiceObject(this.mLogServiceName);
        if (this.mGavageIntervalMinutes <= 0) {
            throw new ServiceException("PUB000001", "Interval must be set more than 1");
        }
        if (this.mMaxClientSize <= 0) {
            throw new ServiceException("PUB000002", "MaxClientSize must be set more than 1");
        }
        Topic[] tpcs = new Topic[this.mTopicNames.length];
        for (int cnt2 = 0; cnt2 < tpcs.length; ++cnt2) {
            tpcs[cnt2] = (Topic)this.mJndiFinder[cnt2].lookup(this.mTopicNames[cnt2]);
        }
        this.mTopics = tpcs;
        TopicTransanctionResource[] ttrs = new TopicTransanctionResource[tpcs.length];
        for (int cnt3 = 0; cnt3 < this.mResourceFactory.length; ++cnt3) {
            ttrs[cnt3] = (TopicTransanctionResource)this.mResourceFactory[cnt3].makeResource("");
        }
        this.mTopicResources = ttrs;
    }

    public void setLogServiceName(ServiceName name) {
        this.mLogServiceName = name;
    }

    public ServiceName getLogServiceName() {
        return this.mLogServiceName;
    }

    public Object createInstance() {
        PublishContainer ret = new PublishContainer();
        ret.setGarbageIntervalMinutes(this.mGavageIntervalMinutes);
        ret.setMaxClientNum(this.mMaxClientSize);
        Queue q = (Queue)ServiceManagerFactory.getServiceObject(this.mQueueFactoryServiceName);
        ret.setQueue(q);
        ret.setTopic(this.mTopics);
        ret.setTopicTransanctionResource(this.mTopicResources);
        this.mLogger.debug("PublishContainer instance is " + ret);
        return ret;
    }

    public void setTopics(String[] topicNames) {
        this.mTopicNames = topicNames;
    }

    public String[] getTopics() {
        return this.mTopicNames;
    }

    public void setTopicJndiNames(ServiceName[] jndiServiceNames) {
        this.mTopicJndiServiceNames = jndiServiceNames;
    }

    public ServiceName[] getTopicJndiNames() {
        return this.mTopicJndiServiceNames;
    }

    public void setTopicResourceServiceNames(ServiceName[] resourceServiceNames) {
        this.mTopicResourceServieNames = resourceServiceNames;
    }

    public ServiceName[] getTopicResourceServiceNames() {
        return this.mTopicResourceServieNames;
    }

    public void setMaxClientSize(int size) {
        this.mMaxClientSize = size;
    }

    public int getMaxClientSize() {
        return this.mMaxClientSize;
    }

    public void setQueueFactoryServiceName(ServiceName name) {
        this.mQueueFactoryServiceName = name;
    }

    public ServiceName getQueueFactoryServiceName() {
        return this.mQueueFactoryServiceName;
    }

    public void setGavageIntervalMinutes(int min) {
        this.mGavageIntervalMinutes = min;
    }

    public int getGavageIntervalMinutes() {
        return this.mGavageIntervalMinutes;
    }
}

