/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.resource.jmstopic;

import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.NamingException;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.jndi.JndiFinder;
import jp.ossc.nimbus.service.resource.TransactionResource;
import jp.ossc.nimbus.service.resource.jmstopic.JmsTopicSession;
import jp.ossc.nimbus.service.resource.jmstopic.JmsTopicSessionServiceMBean;
import jp.ossc.nimbus.service.resource.jmstopic.TopicTransanctionResource;

public class JmsTopicSessionService
extends ServiceBase
implements JmsTopicSession,
JmsTopicSessionServiceMBean {
    private ServiceName mJndiFinderServiceName = null;
    private JndiFinder mJndiFinderService = null;
    private int mAckMode = 1;
    private boolean mTransanctionMode = false;

    public void setJndiFinderServiceName(ServiceName name) {
        this.mJndiFinderServiceName = name;
    }

    public ServiceName getJndiFinderServiceName() {
        return this.mJndiFinderServiceName;
    }

    public void createService() {
    }

    public void startService() {
        this.mJndiFinderService = (JndiFinder)((Object)ServiceManagerFactory.getService(this.mJndiFinderServiceName));
    }

    public void stopService() {
    }

    public void destory() {
        this.mJndiFinderService = null;
    }

    public TransactionResource makeResource(String key) throws JMSException {
        TopicConnectionFactory tFactory = null;
        TopicConnection tConn = null;
        try {
            tFactory = (TopicConnectionFactory)this.mJndiFinderService.lookup(key);
        }
        catch (NamingException e) {
            throw new ServiceException("00013", "Fail to lookup key = " + key, e);
        }
        tConn = tFactory.createTopicConnection();
        TopicSession tSession = tConn.createTopicSession(this.mTransanctionMode, this.mAckMode);
        TopicTransanctionResource tranObj = new TopicTransanctionResource(tConn, tSession);
        return tranObj;
    }

    public void setAcknowledgeMode(int mode) {
        if (mode == 1 || mode == 2 || mode == 3) {
            this.mAckMode = mode;
        }
    }

    public int getAcknowledgeMode() {
        return this.mAckMode;
    }

    public void setTransanctionMode(boolean mode) {
        this.mTransanctionMode = mode;
    }

    public boolean getTransanctionMode() {
        return this.mTransanctionMode;
    }
}

