/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.sequence;

import java.util.ArrayList;
import java.util.ListIterator;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.lang.ServiceException;
import jp.ossc.nimbus.service.sequence.NumericSequenceServiceMBean;
import jp.ossc.nimbus.service.sequence.Sequence;
import jp.ossc.nimbus.service.sequence.SequenceVariable;
import jp.ossc.nimbus.util.CsvArrayList;
import jp.ossc.nimbus.util.StringOperator;

public class NumericSequenceService
extends ServiceBase
implements Sequence,
NumericSequenceServiceMBean {
    protected ArrayList mSequenceNo = null;
    protected String mFormat = null;
    protected String mMin = null;
    protected String mMax = null;
    protected String mInitialNumber = "";
    protected boolean mInitialFlag = true;
    private static final String C_ZERO = "0";
    private static final String C_ZERO_WITH_COMMMA = "0,";
    private static final String C_SEMICORON = ";";
    private static final String C_NINE = "9";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormat(String format) {
        NumericSequenceService numericSequenceService = this;
        synchronized (numericSequenceService) {
            CsvArrayList parser = new CsvArrayList();
            parser.split(format, C_SEMICORON);
            if (parser.size() != 2) {
                throw new ServiceException("NUMERICSEQ001", "fromat is invalid format = " + format);
            }
            this.mMin = parser.getStr(0);
            this.mMax = parser.getStr(1);
            if (!StringOperator.isNumeric(this.mMin)) {
                throw new ServiceException("NUMERICSEQ002", "MIN is not numeric min = " + this.mMin);
            }
            if (!StringOperator.isNumeric(this.mMax)) {
                throw new ServiceException("NUMERICSEQ003", "MAX is not numeric max = " + this.mMax);
            }
            StringBuffer tmpFormat = new StringBuffer();
            for (int cnt = 0; cnt < this.mMax.length(); ++cnt) {
                tmpFormat.append(C_ZERO_WITH_COMMMA);
                tmpFormat.append(C_NINE);
                if (cnt == this.mMax.length() - 1) continue;
                tmpFormat.append(C_SEMICORON);
            }
            this.mFormat = tmpFormat.toString();
        }
    }

    public String getMinValue() {
        return this.mMin;
    }

    public String getMaxValue() {
        return this.mMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() {
        NumericSequenceService numericSequenceService = this;
        synchronized (numericSequenceService) {
            if (this.mSequenceNo == null) {
                CsvArrayList parser = new CsvArrayList();
                parser.split(this.mFormat, C_SEMICORON);
                this.mSequenceNo = new ArrayList();
                ListIterator listIterator = parser.listIterator();
                while (listIterator.hasNext()) {
                    String formatItem = (String)listIterator.next();
                    SequenceVariable item = new SequenceVariable(formatItem);
                    this.mSequenceNo.add(item);
                }
            }
            this.mInitialFlag = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        NumericSequenceService numericSequenceService = this;
        synchronized (numericSequenceService) {
            this.mSequenceNo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String increment() {
        StringBuffer retStr = new StringBuffer();
        NumericSequenceService numericSequenceService = this;
        synchronized (numericSequenceService) {
            SequenceVariable item;
            boolean isOverFlow;
            int maxCnt = this.mSequenceNo.size();
            for (int rCnt = --maxCnt; rCnt >= 0 && (isOverFlow = (item = (SequenceVariable)this.mSequenceNo.get(rCnt)).increment()); --rCnt) {
            }
            boolean isFirst = false;
            ListIterator listIterator = this.mSequenceNo.listIterator();
            while (listIterator.hasNext()) {
                String tmp;
                SequenceVariable item2 = (SequenceVariable)listIterator.next();
                if (!isFirst && !(tmp = item2.getCurrent()).equals(C_ZERO)) {
                    isFirst = true;
                }
                if (!isFirst) continue;
                retStr.append(item2.getCurrent());
            }
            if (retStr.toString().compareTo(this.mMin) < 0) {
                retStr = new StringBuffer(this.increment());
            }
            if (retStr.toString().length() >= this.mMax.length() && retStr.toString().compareTo(this.mMax) > 0) {
                this.reset();
                retStr = new StringBuffer(this.increment());
            }
            if (this.mInitialFlag) {
                this.mInitialNumber = retStr.toString();
                this.mInitialFlag = false;
            }
        }
        return retStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        NumericSequenceService numericSequenceService = this;
        synchronized (numericSequenceService) {
            ListIterator listIterator = this.mSequenceNo.listIterator();
            while (listIterator.hasNext()) {
                SequenceVariable item = (SequenceVariable)listIterator.next();
                item.clear();
            }
            this.mInitialFlag = true;
            this.mInitialNumber = "";
        }
    }

    public String getInitial() {
        return this.mInitialNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrent() {
        StringBuffer retStr = new StringBuffer();
        NumericSequenceService numericSequenceService = this;
        synchronized (numericSequenceService) {
            boolean isFirst = false;
            ListIterator listIterator = this.mSequenceNo.listIterator();
            while (listIterator.hasNext()) {
                String tmp;
                SequenceVariable item = (SequenceVariable)listIterator.next();
                if (!isFirst && !(tmp = item.getCurrent()).equals(C_ZERO)) {
                    isFirst = true;
                }
                if (!isFirst) continue;
                retStr.append(item.getCurrent());
            }
        }
        return retStr.toString();
    }
}

