/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.beans.NoSuchIndexPropertyException;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.NullIndexPropertyException;
import jp.ossc.nimbus.beans.SimpleProperty;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;

public class IndexedProperty
extends SimpleProperty
implements Serializable {
    private static final long serialVersionUID = -3949215311238233792L;
    private static final String MSG_00001 = "Illegal IndexedProperty : ";
    private static final String MSG_00002 = "Length of property literal must be not null.";
    private static final String RECORD_PROP_NAME = "Property";
    protected static final String GET_METHOD_NAME = "get";
    protected static final Class[] GET_METHOD_ARGS = new Class[]{Integer.TYPE};
    protected static final String SET_METHOD_NAME = "set";
    protected int index;
    protected transient Map indexedReadMethodCache = new HashMap();
    protected transient Map indexedWriteMethodCache = new HashMap();
    static /* synthetic */ Class class$java$lang$Integer;

    public IndexedProperty() {
    }

    public IndexedProperty(String name) throws IllegalArgumentException {
        super(name);
    }

    public IndexedProperty(String name, int index) throws IllegalArgumentException {
        super(name);
        this.index = index;
    }

    public String getPropertyName() {
        return super.getPropertyName() + '[' + this.index + ']';
    }

    protected void setPropertyName(String prop) throws IllegalArgumentException {
        if (prop == null) {
            throw new IllegalArgumentException(MSG_00002);
        }
        this.property = prop;
    }

    public void parse(String prop) throws IllegalArgumentException {
        int startIndexedDelim = prop.indexOf(91);
        int endIndexedDelim = prop.indexOf(93);
        if (startIndexedDelim == -1 || endIndexedDelim == -1 || endIndexedDelim - startIndexedDelim <= 1 || endIndexedDelim != prop.length() - 1) {
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        String indexStr = prop.substring(startIndexedDelim + 1, endIndexedDelim);
        try {
            this.index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        this.setPropertyName(prop.substring(0, startIndexedDelim));
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Class getPropertyType(Object obj) throws NoSuchPropertyException {
        Class type;
        Record record;
        RecordSchema recSchema;
        PropertySchema propSchema;
        if (obj == null) {
            return Object.class;
        }
        if (obj instanceof Record && RECORD_PROP_NAME.equalsIgnoreCase(super.getPropertyName()) && (propSchema = (recSchema = (record = (Record)obj).getRecordSchema()).getPropertySchema(this.getIndex())) != null && (type = propSchema.getType()) != null) {
            return type;
        }
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.property.length() == 0) {
            return this.getIndexedObjectPropertyType(clazz);
        }
        if (this.indexedReadMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.indexedReadMethodCache.get(clazz);
        } else {
            readMethod = this.getReadIndexedMethod(clazz);
            this.indexedReadMethodCache.put(clazz, readMethod);
        }
        if (readMethod == null) {
            Method setMethod = this.getWriteIndexedMethod(clazz, null);
            if (setMethod != null) {
                Map overloadMap;
                Object methodObj;
                if (this.indexedWriteMethodCache.containsKey(clazz) && !((methodObj = this.indexedWriteMethodCache.get(clazz)) instanceof Method) && ((overloadMap = (Map)methodObj).size() > 2 || overloadMap.size() == 2 && !overloadMap.containsKey(null))) {
                    return null;
                }
                return setMethod.getParameterTypes()[1];
            }
            Class retClass = null;
            try {
                retClass = super.getPropertyType(obj);
            }
            catch (NoSuchPropertyException e) {
                throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']');
            }
            return this.getIndexedObjectPropertyType(retClass);
        }
        return readMethod.getReturnType();
    }

    public boolean isReadable(Object obj) {
        try {
            this.getProperty(obj);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        return true;
    }

    public boolean isWritable(Object obj, Class clazz) {
        Class<?> objClazz = obj.getClass();
        Method writeMethod = null;
        Method readMethod = null;
        if (this.getMethodCache.containsKey(objClazz)) {
            readMethod = (Method)this.getMethodCache.get(objClazz);
            return this.isWritableNoIndexedProperty(obj, readMethod, clazz);
        }
        if (this.property.length() == 0) {
            return this.isWritableIndexedObjectProperty(obj, clazz);
        }
        writeMethod = this.getWriteIndexedMethod(objClazz, clazz);
        if (writeMethod != null) {
            return true;
        }
        Object prop = null;
        try {
            prop = super.getProperty(obj);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        if (prop == null) {
            return false;
        }
        return this.isWritableIndexedObjectProperty(prop, clazz);
    }

    public Object getProperty(Object obj) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            return this.getNoIndexedProperty(obj, readMethod);
        }
        if (this.indexedReadMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.indexedReadMethodCache.get(clazz);
            return this.getIndexedProperty(obj, readMethod);
        }
        if (this.property.length() == 0) {
            return this.getIndexedObjectProperty(clazz, obj);
        }
        readMethod = this.getReadIndexedMethod(clazz);
        if (readMethod != null) {
            this.indexedReadMethodCache.put(clazz, readMethod);
            return this.getIndexedProperty(obj, readMethod);
        }
        Object prop = super.getProperty(obj);
        if (prop == null) {
            throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']');
        }
        return this.getIndexedObjectProperty(prop.getClass(), prop);
    }

    protected Method getReadIndexedMethod(Class clazz) {
        if (!IndexedProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = this.getReadIndexedMethod(interfaces[i]);
                if (method == null) continue;
                return method;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getReadIndexedMethod(superClass);
            }
            return null;
        }
        StringBuffer methodName = new StringBuffer(GET_METHOD_NAME);
        if (this.property.length() != 0) {
            char capital = this.property.charAt(0);
            if (Character.isUpperCase(capital)) {
                methodName.append(this.property);
            } else {
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if (this.property.length() > 1) {
                    methodName.append(this.property.substring(1));
                }
            }
        }
        try {
            return clazz.getMethod(methodName.toString(), GET_METHOD_ARGS);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(this.property, GET_METHOD_ARGS);
            }
            catch (NoSuchMethodException e2) {
                return null;
            }
        }
    }

    public void setProperty(Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        this.setProperty(obj, value == null ? null : value.getClass(), value);
    }

    public void setProperty(Object obj, Class type, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Method writeMethod = null;
        Method readMethod = null;
        if (this.getMethodCache.containsKey(clazz)) {
            readMethod = (Method)this.getMethodCache.get(clazz);
            this.setNoIndexedProperty(obj, readMethod, value);
        } else if (this.property.length() == 0) {
            this.setIndexedObjectProperty(clazz, obj, value);
        } else {
            if (type == null && value != null) {
                type = value.getClass();
            }
            if ((writeMethod = this.getWriteIndexedMethod(clazz, type)) != null) {
                this.setIndexedProperty(obj, writeMethod, value);
                return;
            }
            Object prop = super.getProperty(obj);
            if (prop == null) {
                throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']');
            }
            this.setIndexedObjectProperty(prop.getClass(), prop, value);
        }
    }

    protected Method getWriteIndexedMethod(Class clazz, Class param) {
        if (this.indexedWriteMethodCache.containsKey(clazz)) {
            Object methodObj = this.indexedWriteMethodCache.get(clazz);
            if (methodObj instanceof Method) {
                return (Method)methodObj;
            }
            Map overloadMap = (Map)methodObj;
            if (param == null) {
                if (overloadMap.size() == 1) {
                    return (Method)overloadMap.values().iterator().next();
                }
                Method setMethod = (Method)overloadMap.get(null);
                if (setMethod != null) {
                    return setMethod;
                }
                Object[] classes = overloadMap.keySet().toArray();
                for (int i = 0; i < classes.length; ++i) {
                    Method method = (Method)overloadMap.get(classes[i]);
                    Class<?>[] params = method.getParameterTypes();
                    if (setMethod == null) {
                        if (params[1].isPrimitive()) continue;
                        setMethod = method;
                        continue;
                    }
                    if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                    setMethod = method;
                }
                HashMap<Object, Method> tmpOverloadMap = new HashMap<Object, Method>(overloadMap);
                tmpOverloadMap.put(null, setMethod);
                this.indexedWriteMethodCache.put(clazz, tmpOverloadMap);
                return setMethod;
            }
            if (overloadMap.containsKey(param)) {
                return (Method)overloadMap.get(param);
            }
            Method setMethod = (Method)overloadMap.get(null);
            if (setMethod != null) {
                return setMethod;
            }
            Object[] classes = overloadMap.keySet().toArray();
            Class primitiveClazz = this.toPrimitive(param);
            for (int i = 0; i < classes.length; ++i) {
                Method method = (Method)overloadMap.get(classes[i]);
                Class<?>[] params = method.getParameterTypes();
                if (setMethod == null) {
                    if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                    setMethod = method;
                    if (!param.equals(params[0]) && !params[0].equals(primitiveClazz)) continue;
                    break;
                }
                if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                if (params[1].equals(param) || params[1].equals(primitiveClazz)) {
                    setMethod = method;
                    break;
                }
                if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            HashMap<Class, Method> tmpOverloadMap = new HashMap<Class, Method>(overloadMap);
            tmpOverloadMap.put(param, setMethod);
            this.indexedWriteMethodCache.put(clazz, tmpOverloadMap);
            return setMethod;
        }
        if (!IndexedProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = this.getWriteIndexedMethod(interfaces[i], param);
                if (method == null) continue;
                return method;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getWriteIndexedMethod(superClass, param);
            }
            return null;
        }
        StringBuffer methodName = new StringBuffer(SET_METHOD_NAME);
        if (this.property.length() != 0) {
            char capital = this.property.charAt(0);
            if (Character.isUpperCase(capital)) {
                methodName.append(this.property);
            } else {
                capital = Character.toUpperCase(capital);
                methodName.append(capital);
                if (this.property.length() > 1) {
                    methodName.append(this.property.substring(1));
                }
            }
        }
        Method setMethod = null;
        Method[] methods = clazz.getMethods();
        if (methods == null || methods.length == 0) {
            return null;
        }
        Class primitiveClazz = this.toPrimitive(param);
        HashMap overloadMap = new HashMap();
        boolean isMatch = false;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            Method method = methods[i];
            if (!methodName.toString().equals(method.getName()) || (params = method.getParameterTypes()) == null || params.length != 2 || !params[0].equals(Integer.TYPE)) continue;
            overloadMap.put(params[1], method);
            if (isMatch) continue;
            if (setMethod == null) {
                if (param == null) {
                    if (params[1].isPrimitive()) continue;
                    setMethod = method;
                    continue;
                }
                if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
                setMethod = method;
                if (!param.equals(params[0]) && !params[0].equals(primitiveClazz)) continue;
                isMatch = true;
                continue;
            }
            if (param == null) {
                if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
                continue;
            }
            if (!this.isAssignableFrom(params[1], param) && !params[1].equals(primitiveClazz)) continue;
            if (params[1].equals(param) || params[1].equals(primitiveClazz)) {
                isMatch = true;
                setMethod = method;
                continue;
            }
            if (!this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
            setMethod = method;
        }
        if (param == null) {
            overloadMap.put(null, setMethod);
        }
        if (setMethod != null) {
            if (overloadMap.size() > 1) {
                this.indexedWriteMethodCache.put(clazz, overloadMap);
            } else {
                this.indexedWriteMethodCache.put(clazz, setMethod);
            }
        }
        return setMethod;
    }

    protected Object getIndexedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            return readMethod.invoke(obj, new Integer(this.index));
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']', e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']', e);
        }
    }

    protected void setIndexedProperty(Object obj, Method writeMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            Class<?> paramType = writeMethod.getParameterTypes()[1];
            if (value instanceof Number && !paramType.isPrimitive() && !paramType.equals(value.getClass())) {
                value = this.castPrimitiveWrapper(paramType, (Number)value);
            }
            writeMethod.invoke(obj, new Integer(this.index), value);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']', e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']', e);
        }
    }

    protected Object getIndexedObject(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        try {
            if (readMethod.getParameterTypes().length == 0) {
                return readMethod.invoke(obj, NULL_ARGS);
            }
            return readMethod.invoke(obj, super.getPropertyName());
        }
        catch (IllegalAccessException e) {
            throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']', e);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']', e);
        }
    }

    protected Object getNoIndexedProperty(Object obj, Method readMethod) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object indexedObj = this.getIndexedObject(obj, readMethod);
        if (indexedObj == null) {
            if (this.isIgnoreNullProperty) {
                return null;
            }
            throw new NullIndexPropertyException(clazz, this.property + '[' + this.index + ']');
        }
        return this.getIndexedObjectProperty(indexedObj.getClass(), indexedObj);
    }

    protected void setNoIndexedProperty(Object obj, Method readMethod, Object value) throws NoSuchPropertyException, InvocationTargetException {
        Class<?> clazz = obj.getClass();
        Object indexedObj = this.getIndexedObject(obj, readMethod);
        if (indexedObj == null) {
            throw new NullIndexPropertyException(clazz, this.property + '[' + this.index + ']');
        }
        this.setIndexedObjectProperty(indexedObj.getClass(), indexedObj, value);
    }

    protected boolean isWritableNoIndexedProperty(Object obj, Method readMethod, Class clazz) {
        Object indexedObj = null;
        try {
            indexedObj = this.getIndexedObject(obj, readMethod);
        }
        catch (NoSuchPropertyException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        if (indexedObj == null) {
            return false;
        }
        return this.isWritableIndexedObjectProperty(indexedObj, clazz);
    }

    protected boolean isWritableIndexedObjectProperty(Object obj, Class clazz) {
        Class<?> indexdClazz = obj.getClass();
        if (indexdClazz.isArray()) {
            return Array.getLength(obj) > this.index;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return list.size() > this.index;
        }
        Method setMethod = null;
        Method[] methods = indexdClazz.getMethods();
        if (methods == null || methods.length == 0) {
            return false;
        }
        Class valueClass = clazz == null ? null : clazz;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!SET_METHOD_NAME.equals(method.getName())) continue;
            Class<?>[] params = method.getParameterTypes();
            if (!Modifier.isPublic(method.getModifiers()) || params == null || params.length != 2 || !params[0].equals(class$java$lang$Integer == null ? IndexedProperty.class$("java.lang.Integer") : class$java$lang$Integer) && !params[0].equals(Integer.TYPE) || valueClass != null && !this.isAssignableFrom(params[1], valueClass) || setMethod != null && !this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
            setMethod = method;
        }
        if (setMethod == null) {
            return false;
        }
        return Modifier.isPublic(setMethod.getModifiers());
    }

    protected Object getIndexedObjectProperty(Class clazz, Object obj) throws NoSuchPropertyException, InvocationTargetException {
        if (clazz.isArray()) {
            if (Array.getLength(obj) <= this.index) {
                throw new NoSuchIndexPropertyException(clazz, this.property + '[' + this.index + ']', this.index);
            }
            return Array.get(obj, this.index);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            try {
                return list.get(this.index);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchIndexPropertyException(clazz, this.property + '[' + this.index + ']', this.index, e);
            }
        }
        if (!IndexedProperty.isAccessableClass(clazz)) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!IndexedProperty.isAccessableClass(interfaces[i])) continue;
                try {
                    return this.getIndexedObjectProperty(interfaces[i], obj);
                }
                catch (NoSuchPropertyException e) {
                    // empty catch block
                }
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.getIndexedObjectProperty(superClass, obj);
            }
            throw new NoSuchIndexPropertyException(clazz, this.property + '[' + this.index + ']', this.index);
        }
        Method getMethod = null;
        try {
            getMethod = clazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
            this.indexedReadMethodCache.put(clazz, getMethod);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']');
        }
        if (Modifier.isPublic(getMethod.getModifiers())) {
            try {
                return getMethod.invoke(obj, new Integer(this.index));
            }
            catch (IllegalAccessException e) {
                throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']', e);
            }
            catch (IllegalArgumentException e) {
                throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']', e);
            }
        }
        throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']');
    }

    protected Class getIndexedObjectPropertyType(Class indexdClazz) throws NoSuchPropertyException {
        if (indexdClazz.isArray()) {
            return indexdClazz.getComponentType();
        }
        if (List.class.isAssignableFrom(indexdClazz)) {
            return Object.class;
        }
        Method getMethod = null;
        try {
            getMethod = indexdClazz.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
        }
        catch (NoSuchMethodException e) {
            Method setMethod = null;
            Method[] methods = indexdClazz.getMethods();
            if (methods == null || methods.length == 0) {
                throw new NoSuchPropertyException(indexdClazz, this.property + '[' + this.index + ']');
            }
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName())) continue;
                Class<?>[] params = method.getParameterTypes();
                if (!Modifier.isPublic(method.getModifiers()) || params == null || params.length != 2 || !params[0].equals(class$java$lang$Integer == null ? IndexedProperty.class$("java.lang.Integer") : class$java$lang$Integer) && !params[0].equals(Integer.TYPE)) continue;
                if (setMethod == null) {
                    setMethod = method;
                    continue;
                }
                throw new NoSuchPropertyException(indexdClazz, this.property + '[' + this.index + ']');
            }
            if (setMethod == null) {
                throw new NoSuchPropertyException(indexdClazz, this.property + '[' + this.index + ']');
            }
            return setMethod.getParameterTypes()[1];
        }
        if (!Modifier.isPublic(getMethod.getModifiers())) {
            throw new NoSuchPropertyException(indexdClazz, this.property + '[' + this.index + ']');
        }
        return getMethod.getReturnType();
    }

    protected void setIndexedObjectProperty(Class clazz, Object obj, Object value) throws NoSuchPropertyException, InvocationTargetException {
        if (clazz.isArray()) {
            if (Array.getLength(obj) <= this.index) {
                throw new NoSuchIndexPropertyException(clazz, this.property + '[' + this.index + ']', this.index);
            }
            Array.set(obj, this.index, value);
        } else if (obj instanceof List) {
            List list = (List)obj;
            if (list.size() <= this.index) {
                for (int i = list.size(); i <= this.index; ++i) {
                    list.add(null);
                }
            }
            try {
                list.set(this.index, value);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchIndexPropertyException(clazz, this.property + '[' + this.index + ']', this.index, e);
            }
        } else {
            if (!IndexedProperty.isAccessableClass(clazz)) {
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    if (!IndexedProperty.isAccessableClass(interfaces[i])) continue;
                    try {
                        this.setIndexedObjectProperty(interfaces[i], obj, value);
                        return;
                    }
                    catch (NoSuchPropertyException e) {
                        // empty catch block
                    }
                }
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    this.setIndexedObjectProperty(superClass, obj, value);
                    return;
                }
                throw new NoSuchIndexPropertyException(clazz, this.property + '[' + this.index + ']', this.index);
            }
            Method setMethod = null;
            Class<?> valueClass = value == null ? null : value.getClass();
            Method[] methods = clazz.getMethods();
            if (methods == null || methods.length == 0) {
                throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']');
            }
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!SET_METHOD_NAME.equals(method.getName())) continue;
                Class<?>[] params = method.getParameterTypes();
                if (!Modifier.isPublic(method.getModifiers()) || params == null || params.length != 2 || !params[0].equals(class$java$lang$Integer == null ? IndexedProperty.class$("java.lang.Integer") : class$java$lang$Integer) && !params[0].equals(Integer.TYPE) || valueClass != null && !this.isAssignableFrom(params[1], valueClass) || setMethod != null && !this.isAssignableFrom(setMethod.getParameterTypes()[1], params[1])) continue;
                setMethod = method;
            }
            if (setMethod == null) {
                throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']');
            }
            if (Modifier.isPublic(setMethod.getModifiers())) {
                try {
                    setMethod.invoke(obj, new Integer(this.index), value);
                }
                catch (IllegalAccessException e) {
                    throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']', e);
                }
                catch (IllegalArgumentException e) {
                    throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']', e);
                }
            } else {
                throw new NoSuchPropertyException(clazz, this.property + '[' + this.index + ']');
            }
        }
    }

    public static IndexedProperty[] getIndexedProperties(Object bean) {
        return IndexedProperty.getIndexedProperties(bean.getClass());
    }

    public static IndexedProperty[] getIndexedProperties(Class clazz) {
        Set props = new HashSet();
        if (IndexedProperty.isAccessableClass(clazz)) {
            props = IndexedProperty.getIndexedProperties(clazz, props);
        } else {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!IndexedProperty.isAccessableClass(interfaces[i])) continue;
                props = IndexedProperty.getIndexedProperties(interfaces[i], props);
                break;
            }
        }
        return props.toArray(new IndexedProperty[props.size()]);
    }

    private static Set getIndexedProperties(Class clazz, Set props) {
        Method[] methods = clazz.getMethods();
        if (methods == null || methods.length == 0) {
            return props;
        }
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (method.getName().startsWith(GET_METHOD_NAME)) {
                Class<?> retType = method.getReturnType();
                if (Void.TYPE.equals(retType)) continue;
                if (params == null) {
                    if (retType.isArray() || (class$java$util$List == null ? IndexedProperty.class$("java.util.List") : class$java$util$List).isAssignableFrom(retType)) {
                        props.add(new IndexedProperty(method.getName().substring(3)));
                        continue;
                    }
                    try {
                        retType.getMethod(GET_METHOD_NAME, GET_METHOD_ARGS);
                        props.add(new IndexedProperty(method.getName().substring(3)));
                    }
                    catch (NoSuchMethodException e) {
                        Method[] nestedMethods = retType.getMethods();
                        boolean isFound = false;
                        for (int j = 0; j < nestedMethods.length; ++j) {
                            Class<?>[] nestedParams = nestedMethods[j].getParameterTypes();
                            if (!SET_METHOD_NAME.equals(nestedMethods[j].getName()) || nestedParams.length != 2 || !Integer.TYPE.equals(nestedParams[0])) continue;
                            isFound = true;
                            break;
                        }
                        if (!isFound) continue;
                        props.add(new IndexedProperty(method.getName().substring(3)));
                    }
                    continue;
                }
                if (params.length != 1 || !Integer.TYPE.equals(params[0])) continue;
                props.add(new IndexedProperty(method.getName().substring(3)));
                continue;
            }
            if (!method.getName().startsWith(SET_METHOD_NAME) || params == null || params.length != 2 || !Integer.TYPE.equals(params[0])) continue;
            props.add(new IndexedProperty(method.getName().substring(3)));
        }
        return props;
    }

    public String toString() {
        return "IndexedProperty{" + this.property + '[' + this.index + "]}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexedProperty)) {
            return false;
        }
        IndexedProperty comp = (IndexedProperty)obj;
        if (this.property == null && comp.property != null || this.property != null && comp.property == null) {
            return false;
        }
        if (this.property != null && comp.property != null && !this.property.equals(comp.property)) {
            return false;
        }
        return this.index == comp.index;
    }

    public int hashCode() {
        return (this.property == null ? 0 : this.property.hashCode()) + this.index + 2;
    }

    public int compareTo(Object obj) {
        int val;
        if (obj == null) {
            return 1;
        }
        if (!(obj instanceof IndexedProperty)) {
            return 1;
        }
        IndexedProperty comp = (IndexedProperty)obj;
        if (this.property == null && comp.property != null) {
            return -1;
        }
        if (this.property != null && comp.property == null) {
            return 1;
        }
        if (this.property != null && comp.property != null && (val = this.property.compareTo(comp.property)) != 0) {
            return val;
        }
        return this.index - comp.index;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.getMethodCache = new HashMap();
        this.setMethodCache = new HashMap();
        this.indexedReadMethodCache = new HashMap();
        this.indexedWriteMethodCache = new HashMap();
    }
}

