/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.beans.dataset.DefaultPropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.PropertyValidateException;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.util.validator.ValidateException;
import jp.ossc.nimbus.util.validator.Validator;

public class ValidatorPropertySchema
extends DefaultPropertySchema {
    protected ServiceName validatorServiceName;

    public ValidatorPropertySchema() {
    }

    public ValidatorPropertySchema(String schema) throws PropertySchemaDefineException {
        super(schema);
    }

    public String getConstrain() {
        return this.validatorServiceName == null ? null : this.validatorServiceName.toString();
    }

    protected void parseConstrain(String schema, String val) throws PropertySchemaDefineException {
        if (val != null && val.length() != 0) {
            ServiceNameEditor serviceNameEditor = new ServiceNameEditor();
            try {
                serviceNameEditor.setAsText(val);
            }
            catch (IllegalArgumentException e) {
                throw new PropertySchemaDefineException(schema, "Constrain is illegal.", e);
            }
            this.validatorServiceName = (ServiceName)serviceNameEditor.getValue();
        }
    }

    public boolean validate(Object val) throws PropertyValidateException {
        if (this.validatorServiceName == null) {
            return true;
        }
        try {
            Validator validator = (Validator)ServiceManagerFactory.getServiceObject(this.validatorServiceName);
            return validator.validate(val);
        }
        catch (ServiceNotFoundException e) {
            throw new PropertyValidateException(this, "Validator is not found : " + this.validatorServiceName, e);
        }
        catch (ValidateException e) {
            throw new PropertyValidateException(this, "Validate error.", e);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('{');
        buf.append("name=").append(this.name);
        buf.append(",type=").append(this.type == null ? null : this.type.getName());
        if (this.parseConverter == null && this.parseConverterName == null) {
            buf.append(",parseConverter=null");
        } else if (this.parseConverter != null) {
            buf.append(",parseConverter=").append(this.parseConverter);
        } else {
            buf.append(",parseConverter=").append(this.parseConverterName);
        }
        if (this.formatConverter == null && this.formatConverterName == null) {
            buf.append(",formatConverter=null");
        } else if (this.formatConverter != null) {
            buf.append(",formatConverter=").append(this.formatConverter);
        } else {
            buf.append(",formatConverter=").append(this.formatConverterName);
        }
        buf.append(",constrain=").append(this.validatorServiceName == null ? null : this.validatorServiceName);
        buf.append('}');
        return buf.toString();
    }
}

