/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.ossc.nimbus.beans.NimbusPropertyEditorManager;
import jp.ossc.nimbus.core.DefaultLogMetaData;
import jp.ossc.nimbus.core.DefaultServiceLoaderServiceMBean;
import jp.ossc.nimbus.core.DefaultServiceManagerService;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.ManagerMetaData;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.core.NimbusEntityResolver;
import jp.ossc.nimbus.core.ServerMetaData;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceLoader;
import jp.ossc.nimbus.core.ServiceLoaderConfig;
import jp.ossc.nimbus.core.ServiceManager;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceMetaData;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNameMetaData;
import jp.ossc.nimbus.core.Utility;
import jp.ossc.nimbus.service.log.Logger;
import jp.ossc.nimbus.service.message.MessageRecordFactory;
import jp.ossc.nimbus.service.repository.Repository;
import jp.ossc.nimbus.util.ClassMappingTree;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultServiceLoaderService
extends ServiceBase
implements ServiceLoader,
DefaultServiceLoaderServiceMBean {
    private static final long serialVersionUID = 7335188900913701079L;
    private static final String SVCL_ = "SVCL_";
    private static final String SVCL_0 = "SVCL_0";
    private static final String SVCL_00 = "SVCL_00";
    private static final String SVCL_000 = "SVCL_000";
    private static final String SVCL_0000 = "SVCL_0000";
    private static final String SVCL_00001 = "SVCL_00001";
    private static final String SVCL_00002 = "SVCL_00002";
    private static final String SVCL_00003 = "SVCL_00003";
    private static final String SVCL_00004 = "SVCL_00004";
    private static final String SVCL_00005 = "SVCL_00005";
    private static final String SVCL_00006 = "SVCL_00006";
    private static final String SVCL_00007 = "SVCL_00007";
    private static final String SVCL_00008 = "SVCL_00008";
    private static final String SVCL_00009 = "SVCL_00009";
    private static final String SVCL_00010 = "SVCL_00010";
    private static final String SVCL_00011 = "SVCL_00011";
    private static final String SVCL_00012 = "SVCL_00012";
    private static final String SVCL_00013 = "SVCL_00013";
    private static final String SVCL_00014 = "SVCL_00014";
    private static final String SVCL_00015 = "SVCL_00015";
    private static final String SVCL_00016 = "SVCL_00016";
    private static final String SVCL_00017 = "SVCL_00017";
    private static final String SVCL_00018 = "SVCL_00018";
    private static final String SVCL_00019 = "SVCL_00019";
    private static final String SVCL_00020 = "SVCL_00020";
    private static final String SVCL_00021 = "SVCL_00021";
    private static final String SVCL_00022 = "SVCL_00022";
    private static final String SVCL_00023 = "SVCL_00023";
    private static final String SVCL_00024 = "SVCL_00024";
    private static final String SVCL_00025 = "SVCL_00025";
    private static final String SVCL_00026 = "SVCL_00026";
    private static final String SVCL_00028 = "SVCL_00028";
    private static final String SVCL_00029 = "SVCL_00029";
    private static final String SVCL_00030 = "SVCL_00030";
    private static final String SVCL_00031 = "SVCL_00031";
    private static final String SVCL_00032 = "SVCL_00032";
    private static final String SVCL_00033 = "SVCL_00033";
    private static final String SVCL_00034 = "SVCL_00034";
    private static final String SVCL_00035 = "SVCL_00035";
    private static final String SVCL_00036 = "SVCL_00036";
    private static final String SVCL_00037 = "SVCL_00037";
    private static final String SVCL_00038 = "SVCL_00038";
    protected static final String DEFAULT_NAME = DefaultServiceLoaderService.class.getName();
    private static final String DEFAULT_SERVICE_MANAGER_CLASS_NAME = DefaultServiceManagerService.class.getName();
    private static final Map shutdownHooks = new HashMap();
    private URL serviceURL;
    private String serviceManagerClassName = DEFAULT_SERVICE_MANAGER_CLASS_NAME;
    private ServerMetaData serverData;
    private Map managerMap;
    private Map managersServiceMetaMap;
    private ClassMappingTree propertyEditors;
    private boolean isValidate;
    private boolean isCheckLoadManagerCompleted;
    private Set checkLoadManagerNames;
    private ServiceLoaderConfig loaderConfig;
    private DefaultLogMetaData preDefaultLogData;

    public DefaultServiceLoaderService() {
        this.setServiceName(DEFAULT_NAME);
    }

    public void setConfig(ServiceLoaderConfig config) {
        this.loaderConfig = config;
    }

    public ServiceLoaderConfig getConfig() {
        return this.loaderConfig;
    }

    public ServerMetaData getServerMetaData() {
        return this.serverData;
    }

    public void setServerMetaData(ServerMetaData data) {
        this.serverData = data;
    }

    public void setServiceManagerClassName(String className) throws ClassNotFoundException, IllegalArgumentException {
        Logger logger = this.getLogger();
        if (className != null && className.length() != 0) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className, true, NimbusClassLoader.getInstance());
            }
            catch (ClassNotFoundException e) {
                logger.write(SVCL_00001, new Object[]{ServiceManager.class, className}, (Throwable)e);
                throw e;
            }
            if (ServiceManager.class.isAssignableFrom(clazz)) {
                this.serviceManagerClassName = className;
                logger.write(SVCL_00002, (Object)className);
            } else {
                MessageRecordFactory message = this.getMessageRecordFactory();
                throw new IllegalArgumentException(message.findEmbedMessage(SVCL_00003, className));
            }
        }
    }

    public String getServiceManagerClassName() {
        return this.serviceManagerClassName;
    }

    public void setServiceURL(URL url) throws IllegalArgumentException {
        Logger logger = this.getLogger();
        try {
            url.openConnection();
        }
        catch (IOException e) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new IllegalArgumentException(message.findEmbedMessage(SVCL_00004, url));
        }
        this.serviceURL = url;
        logger.write(SVCL_00005, this.serviceURL);
    }

    public URL getServiceURL() {
        return this.serviceURL;
    }

    public void setServicePath(String path) throws IllegalArgumentException {
        Logger logger = this.getLogger();
        URL url = Utility.convertServicePathToURL(path);
        try {
            this.setServiceURL(url);
            logger.write(SVCL_00006, url);
        }
        catch (IllegalArgumentException e) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new IllegalArgumentException(message.findEmbedMessage(SVCL_00007, path));
        }
    }

    public void loadServerMetaData() throws IOException, ParserConfigurationException, SAXException, DeploymentException {
        Logger logger = this.getLogger();
        logger.write(SVCL_00008);
        if (this.serverData != null && this.serviceURL == null) {
            return;
        }
        if (this.serviceURL == null) {
            this.serviceURL = Utility.getDefaultServiceURL();
            logger.write(SVCL_00009, this.serviceURL);
        }
        this.serverData = this.loadServerMetaData(this.serviceURL.openStream());
    }

    protected ServerMetaData loadServerMetaData(URL url) throws IOException, ParserConfigurationException, SAXException, DeploymentException {
        if (url == null) {
            return null;
        }
        return this.loadServerMetaData(url.openStream());
    }

    public ServerMetaData loadServerMetaData(InputStream is) throws IOException, ParserConfigurationException, SAXException, DeploymentException {
        InputSource inputSource = new InputSource(is);
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setValidating(this.isValidate());
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        NimbusEntityResolver resolver = new NimbusEntityResolver();
        builder.setEntityResolver(resolver);
        MyErrorHandler handler = new MyErrorHandler();
        builder.setErrorHandler(handler);
        Document doc = builder.parse(inputSource);
        if (handler.isError()) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new DeploymentException(message.findEmbedMessage(SVCL_00033, this.serviceURL));
        }
        ServerMetaData serverData = new ServerMetaData(this, this.serviceURL);
        DocumentType docType = doc.getDoctype();
        if (docType != null) {
            serverData.setDocType("<!DOCTYPE " + docType.getName() + " PUBLIC \"" + docType.getPublicId() + "\" \"" + docType.getSystemId() + "\">");
        }
        if (inputSource.getEncoding() != null) {
            serverData.setEncoding(inputSource.getEncoding());
        }
        serverData.importXML(doc.getDocumentElement());
        Properties props = serverData.getProperties();
        Object[] propKeys = props.keySet().toArray();
        for (int i = 0; i < propKeys.length; ++i) {
            String propKey = (String)propKeys[i];
            String prop = props.getProperty(propKey);
            prop = Utility.replaceSystemProperty(prop);
            prop = Utility.replaceServiceLoderConfig(prop, this.getConfig());
            prop = Utility.replaceServerProperty(prop);
            ServiceManagerFactory.setProperty(propKey, prop);
        }
        return serverData;
    }

    protected void deployServerMetaData(ServerMetaData serverData) throws IOException, ParserConfigurationException, SAXException, DeploymentException {
        ServiceNameMetaData repositoryData;
        ServiceNameMetaData messageData;
        Logger logger = this.getLogger();
        logger.write(SVCL_00011, serverData);
        this.checkRefURL(serverData);
        DefaultLogMetaData defaultLogData = serverData.getDefaultLog();
        this.deployDefaultLogMetaData(defaultLogData);
        this.deployPropertyEditors();
        ServiceNameMetaData logData = serverData.getLog();
        if (logData != null) {
            String managerName = logData.getManagerName();
            String logName = logData.getServiceName();
            if (managerName != null && logName != null) {
                ServiceManagerFactory.setLogger(managerName, logName);
            }
        }
        if ((messageData = serverData.getMessage()) != null) {
            String managerName = messageData.getManagerName();
            String messageName = messageData.getServiceName();
            if (managerName != null && messageName != null) {
                ServiceManagerFactory.setMessageRecordFactory(managerName, messageName);
            }
        }
        if ((repositoryData = serverData.getRepository()) != null) {
            String managerName = repositoryData.getManagerName();
            String repositoryName = repositoryData.getServiceName();
            if (managerName != null && repositoryName != null) {
                ServiceManagerFactory.setManagerRepository(managerName, repositoryName);
            }
        }
        Iterator managers = serverData.getManagers().iterator();
        while (managers.hasNext()) {
            ManagerMetaData managerData = (ManagerMetaData)managers.next();
            this.deployManagerMetaData(managerData);
        }
    }

    protected void checkRefURL(ServerMetaData serverData) throws IOException, ParserConfigurationException, SAXException, DeploymentException {
        ManagerMetaData managerData;
        Set refURLSet = serverData.getReferenceURL();
        if (refURLSet == null || refURLSet.size() == 0) {
            return;
        }
        HashMap refServices = new HashMap();
        Iterator refURLs = refURLSet.iterator();
        while (refURLs.hasNext()) {
            String refURLStr = (String)refURLs.next();
            URL refURL = null;
            try {
                refURL = new URL(refURLStr);
                refURL.openConnection();
            }
            catch (MalformedURLException e) {
                refURL = null;
            }
            catch (IOException e) {
                refURL = null;
            }
            if (refURL == null) {
                String urlString = this.serviceURL.toString();
                urlString = urlString.substring(0, urlString.lastIndexOf(47) + 1);
                try {
                    refURL = new URL(urlString + refURLStr);
                    refURL.openConnection();
                }
                catch (MalformedURLException e) {
                    refURL = null;
                }
                catch (IOException e) {
                    refURL = null;
                }
                if (refURL == null) {
                    try {
                        refURL = Utility.convertServicePathToURL(refURLStr);
                    }
                    catch (IllegalArgumentException e) {
                        throw new DeploymentException("ref-url tag is illegal value : " + refURLStr);
                    }
                }
            }
            ServerMetaData refServerData = this.loadServerMetaData(refURL);
            Iterator managers = refServerData.getManagers().iterator();
            while (managers.hasNext()) {
                ManagerMetaData managerData2 = (ManagerMetaData)managers.next();
                String managerName = managerData2.getName();
                if (refServices.containsKey(managerName)) {
                    ((Map)refServices.get(managerName)).putAll(managerData2.getServices());
                    continue;
                }
                refServices.put(managerName, new HashMap(managerData2.getServices()));
            }
        }
        Iterator managers = serverData.getManagers().iterator();
        while (managers.hasNext()) {
            managerData = (ManagerMetaData)managers.next();
            String managerName = managerData.getName();
            if (refServices.containsKey(managerName)) {
                ((Map)refServices.get(managerName)).putAll(managerData.getServices());
                continue;
            }
            refServices.put(managerName, new HashMap(managerData.getServices()));
        }
        this.checkDepends(refServices, serverData.getRepository());
        this.checkDepends(refServices, serverData.getLog());
        this.checkDepends(refServices, serverData.getMessage());
        managers = serverData.getManagers().iterator();
        while (managers.hasNext()) {
            managerData = (ManagerMetaData)managers.next();
            this.checkDepends(refServices, managerData.getRepository());
            this.checkDepends(refServices, managerData.getLog());
            this.checkDepends(refServices, managerData.getMessage());
            Map services = managerData.getServices();
            Iterator serviceDatas = services.values().iterator();
            while (serviceDatas.hasNext()) {
                ServiceMetaData serviceData = (ServiceMetaData)serviceDatas.next();
                Iterator depends = serviceData.getDepends().iterator();
                while (depends.hasNext()) {
                    ServiceMetaData.DependsMetaData dependsData = (ServiceMetaData.DependsMetaData)depends.next();
                    this.checkDepends(refServices, serviceData, dependsData);
                }
            }
        }
    }

    private void checkDepends(Map refServices, ServiceNameMetaData dependsData) throws DeploymentException {
        Map services;
        if (dependsData == null) {
            return;
        }
        String depManagerName = dependsData.getManagerName();
        String depServiceName = dependsData.getServiceName();
        if (refServices.containsKey(depManagerName) && (services = (Map)refServices.get(depManagerName)).containsKey(depServiceName)) {
            return;
        }
        MessageRecordFactory message = this.getMessageRecordFactory();
        throw new DeploymentException(message.findEmbedMessage(SVCL_00036, new Object[]{depManagerName, depServiceName}));
    }

    private void checkDepends(Map refServices, ServiceMetaData serviceData, ServiceMetaData.DependsMetaData dependsData) throws DeploymentException {
        ManagerMetaData managerData = serviceData.getManager();
        String managerName = managerData.getName();
        String serviceName = serviceData.getName();
        String depManagerName = dependsData.getManagerName();
        String depServiceName = dependsData.getServiceName();
        Map ref = (Map)refServices.get(depManagerName);
        if (ref == null || !ref.containsKey(depServiceName)) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new DeploymentException(message.findEmbedMessage(SVCL_00036, new Object[]{depManagerName, depServiceName}));
        }
        ServiceMetaData depServiceData = (ServiceMetaData)ref.get(depServiceName);
        Iterator deps = depServiceData.getDepends().iterator();
        while (deps.hasNext()) {
            ServiceMetaData.DependsMetaData depdepServiceData = (ServiceMetaData.DependsMetaData)deps.next();
            String depdepManagerName = depdepServiceData.getManagerName();
            String depdepServiceName = depdepServiceData.getServiceName();
            if (depdepManagerName.equals(managerName) && depdepServiceName.equals(serviceName)) {
                MessageRecordFactory message = this.getMessageRecordFactory();
                throw new DeploymentException(message.findEmbedMessage(SVCL_00037, new Object[]{managerName, serviceName, depdepManagerName, depdepServiceName}));
            }
            this.checkDepends(refServices, serviceData, depdepServiceData);
        }
    }

    protected void undeployServerMetaData(ServerMetaData serverData) throws DeploymentException {
        Iterator managers = this.managerMap.values().iterator();
        while (managers.hasNext()) {
            ServiceManager manager = (ServiceManager)managers.next();
            this.shutdownServiceManager(manager);
        }
        ServiceNameMetaData repositoryData = serverData.getRepository();
        if (repositoryData != null) {
            String managerName = repositoryData.getManagerName();
            String repositoryName = repositoryData.getServiceName();
            if (managerName != null && repositoryName != null && ServiceManagerFactory.isRegisteredService(managerName, repositoryName)) {
                ServiceManagerFactory.setManagerRepository((Repository)null);
            }
        }
        DefaultLogMetaData defaultLogData = serverData.getDefaultLog();
        this.undeployDefaultLogMetaData(defaultLogData);
    }

    protected void deployDefaultLogMetaData(DefaultLogMetaData defaultLogData) {
        if (defaultLogData == null) {
            return;
        }
        this.preDefaultLogData = new DefaultLogMetaData(defaultLogData.getParent());
        Logger logger = this.getLogger();
        DefaultLogMetaData.LogCategoryMetaData categoryData = defaultLogData.getDebug();
        if (categoryData != null) {
            DefaultLogMetaData.LogCategoryMetaData preDebugData = new DefaultLogMetaData.LogCategoryMetaData(this.preDefaultLogData);
            preDebugData.setOutput(ServiceManagerFactory.DEFAULT_LOGGER.isSystemDebugEnabled());
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemDebugEnabled(categoryData.isOutput());
            ServiceManagerFactory.DEFAULT_LOGGER.setDebugEnabled(categoryData.isOutput());
            this.preDefaultLogData.setDebug(preDebugData);
            if (ServiceManagerFactory.DEFAULT_LOGGER.isSystemDebugEnabled()) {
                logger.write(SVCL_00012, (Object)"SYSTEM_DEBUG");
            } else {
                logger.write(SVCL_00013, (Object)"SYSTEM_DEBUG");
            }
        } else {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemDebugEnabled(false);
            ServiceManagerFactory.DEFAULT_LOGGER.setDebugEnabled(false);
        }
        categoryData = defaultLogData.getInformation();
        if (categoryData != null) {
            DefaultLogMetaData.LogCategoryMetaData preInfoData = new DefaultLogMetaData.LogCategoryMetaData(this.preDefaultLogData);
            preInfoData.setOutput(ServiceManagerFactory.DEFAULT_LOGGER.isSystemInfoEnabled());
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemInfoEnabled(categoryData.isOutput());
            this.preDefaultLogData.setInformation(preInfoData);
            if (ServiceManagerFactory.DEFAULT_LOGGER.isSystemInfoEnabled()) {
                logger.write(SVCL_00012, (Object)"SYSTEM_INFO");
            } else {
                logger.write(SVCL_00013, (Object)"SYSTEM_INFO");
            }
        } else {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemInfoEnabled(true);
        }
        categoryData = defaultLogData.getWarning();
        if (categoryData != null) {
            DefaultLogMetaData.LogCategoryMetaData preWarnData = new DefaultLogMetaData.LogCategoryMetaData(this.preDefaultLogData);
            preWarnData.setOutput(ServiceManagerFactory.DEFAULT_LOGGER.isSystemWarnEnabled());
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemWarnEnabled(categoryData.isOutput());
            this.preDefaultLogData.setWarning(preWarnData);
            if (ServiceManagerFactory.DEFAULT_LOGGER.isSystemWarnEnabled()) {
                logger.write(SVCL_00012, (Object)"SYSTEM_WARN");
            } else {
                logger.write(SVCL_00013, (Object)"SYSTEM_WARN");
            }
        } else {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemWarnEnabled(true);
        }
        categoryData = defaultLogData.getError();
        if (categoryData != null) {
            DefaultLogMetaData.LogCategoryMetaData preErrorData = new DefaultLogMetaData.LogCategoryMetaData(this.preDefaultLogData);
            preErrorData.setOutput(ServiceManagerFactory.DEFAULT_LOGGER.isSystemErrorEnabled());
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemErrorEnabled(categoryData.isOutput());
            this.preDefaultLogData.setError(preErrorData);
            if (ServiceManagerFactory.DEFAULT_LOGGER.isSystemErrorEnabled()) {
                logger.write(SVCL_00012, (Object)"SYSTEM_ERROR");
            } else {
                logger.write(SVCL_00013, (Object)"SYSTEM_ERROR");
            }
        } else {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemErrorEnabled(true);
        }
        categoryData = defaultLogData.getFatal();
        if (categoryData != null) {
            DefaultLogMetaData.LogCategoryMetaData preFatalData = new DefaultLogMetaData.LogCategoryMetaData(this.preDefaultLogData);
            preFatalData.setOutput(ServiceManagerFactory.DEFAULT_LOGGER.isSystemFatalEnabled());
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemFatalEnabled(categoryData.isOutput());
            this.preDefaultLogData.setFatal(preFatalData);
            if (ServiceManagerFactory.DEFAULT_LOGGER.isSystemFatalEnabled()) {
                logger.write(SVCL_00012, (Object)"SYSTEM_FATAL");
            } else {
                logger.write(SVCL_00013, (Object)"SYSTEM_FATAL");
            }
        } else {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemFatalEnabled(true);
        }
    }

    protected void undeployDefaultLogMetaData(DefaultLogMetaData defaultLogData) {
        if (defaultLogData == null && this.preDefaultLogData == null) {
            return;
        }
        if (this.preDefaultLogData.getDebug() != null) {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemDebugEnabled(this.preDefaultLogData.getDebug().isOutput());
            ServiceManagerFactory.DEFAULT_LOGGER.setDebugEnabled(this.preDefaultLogData.getDebug().isOutput());
        }
        if (this.preDefaultLogData.getInformation() != null) {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemInfoEnabled(this.preDefaultLogData.getInformation().isOutput());
        }
        if (this.preDefaultLogData.getWarning() != null) {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemWarnEnabled(this.preDefaultLogData.getWarning().isOutput());
        }
        if (this.preDefaultLogData.getError() != null) {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemErrorEnabled(this.preDefaultLogData.getError().isOutput());
        }
        if (this.preDefaultLogData.getFatal() != null) {
            ServiceManagerFactory.DEFAULT_LOGGER.setSystemFatalEnabled(this.preDefaultLogData.getFatal().isOutput());
        }
    }

    protected void deployPropertyEditors() {
        Logger logger = this.getLogger();
        logger.write(SVCL_00014);
        Map propertyEditors = this.serverData.getPropertyEditors();
        Iterator editTypes = propertyEditors.keySet().iterator();
        NimbusClassLoader loader = NimbusClassLoader.getInstance();
        while (editTypes.hasNext()) {
            String typeName = (String)editTypes.next();
            String editorClassName = (String)propertyEditors.get(typeName);
            Class<?> type = null;
            Class<?> editorClass = null;
            try {
                type = Class.forName(typeName, true, loader);
            }
            catch (ClassNotFoundException e) {
                logger.write(SVCL_00015, (Object)typeName, (Throwable)e);
                continue;
            }
            try {
                editorClass = Class.forName(editorClassName, true, loader);
            }
            catch (ClassNotFoundException e) {
                logger.write(SVCL_00016, (Object)editorClassName, (Throwable)e);
                continue;
            }
            this.propertyEditors.add(type, editorClass);
            logger.write(SVCL_00017, new Object[]{type, editorClass});
        }
    }

    protected void deployManagerMetaData(ManagerMetaData managerData) throws DeploymentException {
        ServiceNameMetaData repositoryData;
        ServiceNameMetaData messageData;
        Logger logger = this.getLogger();
        logger.write(SVCL_00018, managerData);
        String name = managerData.getName();
        ServiceManager manager = ServiceManagerFactory.findManager(name);
        if (manager == null) {
            manager = (ServiceManager)this.managerMap.get(name);
        }
        if (manager == null) {
            try {
                Class<?> clazz = Class.forName(this.serviceManagerClassName, true, NimbusClassLoader.getInstance());
                manager = (ServiceManager)clazz.newInstance();
            }
            catch (Exception e) {
                MessageRecordFactory message = this.getMessageRecordFactory();
                throw new DeploymentException(message.findEmbedMessage(SVCL_00019, name), e);
            }
            manager.setServiceName(name);
            manager.setServiceManagerName(name);
            logger.write(SVCL_00020, (Object)name);
        }
        manager.addServiceLoader(this);
        this.managerMap.put(name, manager);
        ServiceNameMetaData logData = managerData.getLog();
        if (logData != null) {
            String managerName = logData.getManagerName();
            String logName = logData.getServiceName();
            if (managerName != null && logName != null) {
                manager.setSystemLoggerServiceName(new ServiceName(managerName, logName));
            }
        }
        if ((messageData = managerData.getMessage()) != null) {
            String managerName = messageData.getManagerName();
            String messageName = messageData.getServiceName();
            if (managerName != null && messageName != null) {
                manager.setSystemMessageRecordFactoryServiceName(new ServiceName(managerName, messageName));
            }
        }
        if ((repositoryData = managerData.getRepository()) != null) {
            String managerName = repositoryData.getManagerName();
            String repositoryName = repositoryData.getServiceName();
            if (managerName != null && repositoryName != null) {
                manager.setServiceRepository(managerName, repositoryName);
            }
        }
        if (!this.managersServiceMetaMap.containsKey(name)) {
            HashMap serviceMetaMap = new HashMap();
            this.managersServiceMetaMap.put(name, serviceMetaMap);
        }
        Map serviceDataMap = managerData.getServices();
        Iterator serviceNames = serviceDataMap.keySet().iterator();
        while (serviceNames.hasNext()) {
            String serviceName = (String)serviceNames.next();
            ServiceMetaData serviceData = (ServiceMetaData)serviceDataMap.get(serviceName);
            try {
                this.deployServiceMetaData(serviceData);
            }
            catch (DeploymentException e) {
                logger.write(SVCL_00038, new Object[]{this.managerName, serviceName}, (Throwable)e);
            }
        }
    }

    protected void deployServiceMetaData(ServiceMetaData serviceData) throws DeploymentException {
        Logger logger = this.getLogger();
        logger.write(SVCL_00021, serviceData);
        String managerName = serviceData.getManager().getName();
        String serviceName = serviceData.getName();
        ServiceManager manager = ServiceManagerFactory.findManager(managerName);
        if (manager == null) {
            manager = (ServiceManager)this.managerMap.get(managerName);
        }
        if (manager == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new DeploymentException(message.findEmbedMessage(SVCL_00029, managerName));
        }
        if (manager.isRegisteredService(serviceName)) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new DeploymentException(message.findEmbedMessage(SVCL_00034, new Object[]{managerName, serviceName}));
        }
        logger.write(SVCL_00023, new Object[]{managerName, serviceName});
        Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(managerName);
        serviceMetaMap.put(serviceName, serviceData);
        try {
            manager.registerService(serviceData);
        }
        catch (Exception e) {
            logger.write(SVCL_00022, new Object[]{managerName, serviceName}, (Throwable)e);
            throw new DeploymentException(e);
        }
    }

    public void loadService(String managerName, String serviceName) throws DeploymentException {
        ServiceMetaData serviceData = this.getServiceMetaData(managerName, serviceName);
        if (serviceData == null) {
            MessageRecordFactory message = this.getMessageRecordFactory();
            throw new DeploymentException(message.findEmbedMessage(SVCL_00035, new Object[]{managerName, serviceName}));
        }
        this.deployServiceMetaData(serviceData);
    }

    public void deployService(ServiceMetaData serviceData) throws DeploymentException {
        this.deployServiceMetaData(serviceData);
    }

    public void createService() {
        Logger logger = this.getLogger();
        if (this.serverData == null && this.serviceURL == null) {
            this.serviceURL = Utility.getDefaultServiceURL();
            logger.write(SVCL_00009, this.serviceURL);
        }
        if (this.serviceURL != null) {
            String myName = this.getServiceName();
            this.setServiceName(myName == null ? DEFAULT_NAME + '{' + this.serviceURL + '}' : myName);
        }
        if (this.serviceURL != null) {
            ServiceManagerFactory.registerLoader(this);
        }
        this.managerMap = new HashMap();
        this.managersServiceMetaMap = new HashMap();
        this.propertyEditors = new ClassMappingTree();
    }

    public void startService() throws Exception {
        Logger logger = this.getLogger();
        try {
            this.loadServerMetaData();
        }
        catch (Exception e) {
            logger.write(SVCL_00010, this.serviceURL, (Throwable)e);
            throw e;
        }
        this.managerMap.clear();
        this.managersServiceMetaMap.clear();
        this.propertyEditors.clear();
        try {
            this.deployServerMetaData(this.serverData);
        }
        catch (Exception e) {
            logger.write(SVCL_00024, this.serviceURL, (Throwable)e);
            throw e;
        }
        Iterator managers = this.managerMap.values().iterator();
        while (managers.hasNext()) {
            ServiceManager manager = (ServiceManager)managers.next();
            try {
                this.startupServiceManager(manager);
            }
            catch (Exception e) {
                logger.write(SVCL_00025, (Object)manager.getServiceName(), (Throwable)e);
                manager.destroy();
            }
        }
        if (this.isCheckLoadManagerCompleted) {
            if (this.checkLoadManagerNames == null) {
                ServiceManagerFactory.checkLoadManagerCompleted();
            } else {
                ServiceManagerFactory.checkLoadManagerCompletedBy(this.checkLoadManagerNames);
            }
        }
    }

    public void stopService() throws Exception {
        this.undeployServerMetaData(this.serverData);
        this.managerMap.clear();
        this.managersServiceMetaMap.clear();
        this.propertyEditors.clear();
    }

    public void destroyService() throws Exception {
        this.managerMap = null;
        this.managersServiceMetaMap = null;
        this.propertyEditors = null;
        ServiceManagerFactory.unregisterLoader(this);
    }

    public Set getServiceManagers() {
        return new HashSet(this.managerMap.values());
    }

    public List getDepends(String managerName, String serviceName) {
        if (!this.managersServiceMetaMap.containsKey(managerName)) {
            return null;
        }
        Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(managerName);
        if (!serviceMetaMap.containsKey(serviceName)) {
            return null;
        }
        ArrayList result = new ArrayList();
        ServiceMetaData serviceData = (ServiceMetaData)serviceMetaMap.get(serviceName);
        result.addAll(serviceData.getDepends());
        return result;
    }

    public List getDependedServices(String managerName, String serviceName) {
        ArrayList<ServiceMetaData> result = new ArrayList<ServiceMetaData>();
        Iterator managerNames = this.managersServiceMetaMap.keySet().iterator();
        while (managerNames.hasNext()) {
            String mngName = (String)managerNames.next();
            Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(mngName);
            Iterator serviceNames = serviceMetaMap.keySet().iterator();
            block1: while (serviceNames.hasNext()) {
                String name = (String)serviceNames.next();
                if (name.equals(serviceName) && mngName.equals(managerName)) continue;
                Iterator dependsDatas = this.getDepends(mngName, name).iterator();
                while (dependsDatas.hasNext()) {
                    ServiceMetaData.DependsMetaData dependsData = (ServiceMetaData.DependsMetaData)dependsDatas.next();
                    if (!dependsData.getServiceName().equals(serviceName) || !dependsData.getManagerName().equals(managerName)) continue;
                    ServiceMetaData serviceData = (ServiceMetaData)serviceMetaMap.get(name);
                    result.add(serviceData);
                    continue block1;
                }
            }
        }
        return result;
    }

    public ServiceMetaData getServiceMetaData(String managerName, String serviceName) {
        if (!this.managersServiceMetaMap.containsKey(managerName)) {
            return null;
        }
        Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(managerName);
        return (ServiceMetaData)serviceMetaMap.get(serviceName);
    }

    public void setServiceMetaData(String managerName, ServiceMetaData serviceData) {
        ManagerMetaData manager = this.serverData.getManager(managerName);
        serviceData.setParent(manager);
        serviceData.setManager(manager);
        serviceData.setServiceLoader(this);
        Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(managerName);
        serviceMetaMap.put(serviceData.getName(), serviceData);
    }

    public PropertyEditor findEditor(Class type) {
        Logger logger = this.getLogger();
        if (type == null) {
            return null;
        }
        PropertyEditor editor = null;
        Class clazz = (Class)this.propertyEditors.getValue(type);
        if (clazz == null) {
            editor = NimbusPropertyEditorManager.findEditor(type);
        } else {
            try {
                editor = (PropertyEditor)clazz.newInstance();
            }
            catch (InstantiationException e) {
                logger.write(SVCL_00028, new Object[]{type, clazz}, (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                logger.write(SVCL_00028, new Object[]{type, clazz}, (Throwable)e);
                return null;
            }
        }
        return editor;
    }

    private void startupServiceManager(final ServiceManager manager) throws Exception {
        Logger logger = this.getLogger();
        int state = manager.getState();
        if (state != 3) {
            if (state == 7) {
                manager.create();
            }
            manager.start();
            ManagerMetaData managerData = this.serverData.getManager(manager.getServiceName());
            if (managerData.isExistShutdownHook()) {
                String managerName = manager.getServiceName();
                if (shutdownHooks.containsKey(managerName)) {
                    Runtime.getRuntime().removeShutdownHook((Thread)shutdownHooks.get(managerName));
                }
                Thread shutdownHook = new Thread(new Runnable(){

                    public void run() {
                        manager.stop();
                        manager.destroy();
                    }
                });
                Runtime.getRuntime().addShutdownHook(shutdownHook);
                shutdownHooks.put(manager.getServiceName(), shutdownHook);
                logger.write(SVCL_00026, (Object)manager.getServiceName());
            }
        } else {
            Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(manager.getServiceName());
            HashSet serviceNames = new HashSet(serviceMetaMap.keySet());
            manager.createService(serviceNames);
            manager.startService(serviceNames);
        }
    }

    private void shutdownServiceManager(ServiceManager manager) {
        Map serviceMetaMap = (Map)this.managersServiceMetaMap.get(manager.getServiceName());
        HashSet serviceNames = new HashSet(serviceMetaMap.keySet());
        manager.destroyService(serviceNames);
        if (manager.getServiceLoaders().size() == 1) {
            manager.stop();
            Thread hook = (Thread)shutdownHooks.remove(manager.getServiceName());
            if (hook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(hook);
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
            manager.destroy();
        }
        manager.removeServiceLoader(this);
    }

    public int hashCode() {
        return this.serviceURL == null ? super.hashCode() : this.serviceURL.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DefaultServiceLoaderService) {
            DefaultServiceLoaderService loader = (DefaultServiceLoaderService)obj;
            if (this.serviceURL == null && loader.serviceURL != null || this.serviceURL != null && loader.serviceURL == null) {
                return false;
            }
            return this.serviceURL == null || loader.serviceURL == null || this.serviceURL.equals(loader.serviceURL);
        }
        return false;
    }

    public void setValidate(boolean validate) {
        this.isValidate = validate;
    }

    public boolean isValidate() {
        return this.isValidate;
    }

    public void setCheckLoadManagerCompleted(boolean isCheck) {
        this.isCheckLoadManagerCompleted = isCheck;
    }

    public boolean isCheckLoadManagerCompleted() {
        return this.isCheckLoadManagerCompleted;
    }

    public void setCheckLoadManagerCompletedBy(String[] managerNames) {
        if (managerNames != null && managerNames.length != 0) {
            this.checkLoadManagerNames = new HashSet();
            for (int i = 0; i < managerNames.length; ++i) {
                this.checkLoadManagerNames.add(managerNames[i]);
            }
        } else {
            this.checkLoadManagerNames = null;
        }
    }

    public String[] getCheckLoadManagerCompletedBy() {
        return this.checkLoadManagerNames == null ? new String[]{} : this.checkLoadManagerNames.toArray(new String[this.checkLoadManagerNames.size()]);
    }

    private class MyErrorHandler
    implements ErrorHandler {
        private boolean isError;

        private MyErrorHandler() {
        }

        public void warning(SAXParseException e) throws SAXException {
            DefaultServiceLoaderService.this.getLogger().write(DefaultServiceLoaderService.SVCL_00030, (Object)e.getMessage());
        }

        public void error(SAXParseException e) throws SAXException {
            this.isError = true;
            DefaultServiceLoaderService.this.getLogger().write(DefaultServiceLoaderService.SVCL_00031, (Object)e.getMessage());
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.isError = true;
            DefaultServiceLoaderService.this.getLogger().write(DefaultServiceLoaderService.SVCL_00032, (Object)e.getMessage());
        }

        public boolean isError() {
            return this.isError;
        }
    }
}

