/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.interceptor.DefaultExceptionHandlerServiceMBean;
import jp.ossc.nimbus.service.aop.interceptor.ExceptionHandler;
import jp.ossc.nimbus.service.journal.Journal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;
import jp.ossc.nimbus.service.log.Logger;

public class DefaultExceptionHandlerService
extends ServiceBase
implements DefaultExceptionHandlerServiceMBean,
ExceptionHandler {
    private static final long serialVersionUID = 4504118845207660393L;
    public static final String REQUEST_ATTIBUTE_EXCEPTION_KEY = DefaultExceptionHandlerService.class.getName().replace('.', '_') + "_EXCEPTION";
    protected ServiceName journalServiceName;
    protected Journal journal;
    protected String logMessageCode;
    protected boolean isOutputStackTraceLog = true;
    protected String exceptionJournalKey = "Exception";
    protected ServiceName exceptionEditorFinderServiceName;
    protected EditorFinder exceptionEditorFinder;
    protected boolean isThrowException;

    public void setJournalServiceName(ServiceName name) {
        this.journalServiceName = name;
    }

    public ServiceName getJournalServiceName() {
        return this.journalServiceName;
    }

    public void setLogMessageCode(String code) {
        this.logMessageCode = code;
    }

    public String getLogMessageCode() {
        return this.logMessageCode;
    }

    public void setOutputStackTraceLog(boolean isOutput) {
        this.isOutputStackTraceLog = isOutput;
    }

    public boolean isOutputStackTraceLog() {
        return this.isOutputStackTraceLog;
    }

    public void setExceptionJournalKey(String key) {
        this.exceptionJournalKey = key;
    }

    public String getExceptionJournalKey() {
        return this.exceptionJournalKey;
    }

    public void setExceptionEditorFinderServiceName(ServiceName name) {
        this.exceptionEditorFinderServiceName = name;
    }

    public ServiceName getExceptionEditorFinderServiceName() {
        return this.exceptionEditorFinderServiceName;
    }

    public void setThrowException(boolean isThrow) {
        this.isThrowException = isThrow;
    }

    public boolean isThrowException() {
        return this.isThrowException;
    }

    public void startService() throws Exception {
        if (this.journalServiceName != null) {
            this.journal = (Journal)ServiceManagerFactory.getServiceObject(this.journalServiceName);
        }
        if (this.exceptionEditorFinderServiceName != null) {
            this.exceptionEditorFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.exceptionEditorFinderServiceName);
        }
    }

    public void handleException(Throwable th, InvocationContext context) throws Throwable {
        if (this.logMessageCode != null) {
            Logger log = super.getLogger();
            if (this.isOutputStackTraceLog) {
                log.write(this.logMessageCode, th);
            } else {
                log.write(this.logMessageCode);
            }
        }
        if (this.journal != null) {
            this.journal.addInfo(this.exceptionJournalKey, (Object)th, this.exceptionEditorFinder);
        }
        if (this.isThrowException) {
            throw th;
        }
    }
}

