/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.cache.CacheAccessListener;
import jp.ossc.nimbus.service.cache.CacheRemoveListener;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.KeyCachedReference;
import jp.ossc.nimbus.service.cache.LFUOverflowAlgorithmServiceMBean;
import jp.ossc.nimbus.service.cache.OverflowAlgorithm;

public class LFUOverflowAlgorithmService
extends ServiceBase
implements OverflowAlgorithm,
CacheRemoveListener,
CacheAccessListener,
Serializable,
LFUOverflowAlgorithmServiceMBean {
    private static final long serialVersionUID = -8742917099381213489L;
    private Map referenceMap;
    private List referenceList;
    private boolean cachedRatioCompare = false;
    private long ratioUnitTime = 1000L;

    public int size() {
        return this.referenceList == null ? 0 : this.referenceList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumReferenceCount() {
        if (this.referenceMap == null) {
            return 0;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() == 0) {
                return 0;
            }
            Collections.sort(this.referenceList);
            CounterCachedReference couterRef = (CounterCachedReference)this.referenceList.get(this.referenceList.size() - 1);
            return couterRef.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimumReferenceCount() {
        if (this.referenceMap == null) {
            return 0;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() == 0) {
                return 0;
            }
            Collections.sort(this.referenceList);
            CounterCachedReference couterRef = (CounterCachedReference)this.referenceList.get(0);
            return couterRef.getCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displayReferenceCounts() {
        if (this.referenceMap == null) {
            return "";
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() == 0) {
                return "";
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Collections.sort(this.referenceList);
            CounterCachedReference couterRef = (CounterCachedReference)this.referenceList.get(this.referenceList.size() - 1);
            double unitCount = (double)couterRef.getCount() / 100.0;
            Iterator itr = this.referenceList.iterator();
            while (itr.hasNext()) {
                couterRef = (CounterCachedReference)itr.next();
                CachedReference ref = couterRef.getCachedReference();
                int count = couterRef.getCount();
                int point = (int)((double)count / unitCount);
                for (int i = 0; i < point; ++i) {
                    pw.print('*');
                }
                pw.print('\u3000');
                pw.print(Integer.toString(count));
                if (ref instanceof KeyCachedReference) {
                    pw.print('\u3000');
                    pw.print(((KeyCachedReference)ref).getKey());
                }
                pw.println("<br>");
            }
            return sw.toString();
        }
    }

    public boolean isCachedRatioCompare() {
        return this.cachedRatioCompare;
    }

    public void setCachedRatioCompare(boolean cachedRatioCompare) {
        this.cachedRatioCompare = cachedRatioCompare;
    }

    public void setRatioUnitTime(long ratioUnitTime) {
        this.ratioUnitTime = ratioUnitTime;
    }

    public void createService() throws Exception {
        this.referenceMap = Collections.synchronizedMap(new HashMap());
        this.referenceList = Collections.synchronizedList(new ArrayList());
    }

    public void destroyService() throws Exception {
        this.reset();
        this.referenceMap = null;
        this.referenceList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CachedReference ref) {
        if (this.referenceMap == null || ref == null) {
            return;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (!this.referenceMap.containsKey(ref)) {
                CounterCachedReference counterRef = new CounterCachedReference(ref, this.cachedRatioCompare, this.ratioUnitTime);
                this.referenceMap.put(ref, counterRef);
                this.referenceList.add(counterRef);
                ref.addCacheAccessListener(this);
                ref.addCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CachedReference ref) {
        if (this.referenceMap == null || ref == null) {
            return;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.containsKey(ref)) {
                CounterCachedReference counterRef = (CounterCachedReference)this.referenceMap.remove(ref);
                this.referenceList.remove(counterRef);
                ref.removeCacheAccessListener(this);
                ref.removeCacheRemoveListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedReference overflow() {
        if (this.referenceMap == null) {
            return null;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap.size() != 0) {
                Collections.sort(this.referenceList);
                CounterCachedReference couterRef = (CounterCachedReference)this.referenceList.get(0);
                this.referenceList.remove(couterRef);
                this.referenceMap.remove(couterRef.getCachedReference());
                return couterRef.getCachedReference();
            }
            return null;
        }
    }

    public void reset() {
        if (this.referenceMap != null) {
            this.referenceMap.clear();
            this.referenceList.clear();
        }
    }

    public void removed(CachedReference ref) {
        this.remove(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessed(CachedReference ref) {
        if (this.referenceMap == null) {
            return;
        }
        Map map = this.referenceMap;
        synchronized (map) {
            if (this.referenceMap != null && this.referenceMap.containsKey(ref)) {
                CounterCachedReference counterRef = (CounterCachedReference)this.referenceMap.get(ref);
                this.referenceList.remove(counterRef);
                if (!counterRef.increment()) {
                    Iterator counterRefs = this.referenceMap.values().iterator();
                    while (counterRefs.hasNext()) {
                        ((CounterCachedReference)counterRefs.next()).offset();
                    }
                    counterRef.increment();
                }
                this.referenceList.add(counterRef);
            }
        }
    }

    private static class CounterCachedReference
    implements Serializable,
    Comparable {
        private static final long serialVersionUID = -5670267780842863519L;
        private CachedReference reference;
        private int count;
        private long cachedTime;
        private boolean cachedRatioCompare = false;
        private long ratioUnitTime;

        public CounterCachedReference(CachedReference ref, boolean cachedRatioCompare, long ratioUnitTime) {
            this.reference = ref;
            this.cachedTime = System.currentTimeMillis();
            this.cachedRatioCompare = cachedRatioCompare;
            this.ratioUnitTime = ratioUnitTime;
        }

        public CachedReference getCachedReference() {
            return this.reference;
        }

        public void offset() {
            this.count /= 1000;
        }

        public boolean increment() {
            if (this.count == Integer.MAX_VALUE) {
                return false;
            }
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }

        public long getCachedTime() {
            return this.cachedTime;
        }

        public int compareTo(Object arg0) {
            if (arg0 == null || !(arg0 instanceof CounterCachedReference)) {
                return 1;
            }
            if (arg0 == this) {
                return 0;
            }
            CounterCachedReference comp = (CounterCachedReference)arg0;
            if (this.cachedRatioCompare) {
                double compRatio;
                long currentTime = System.currentTimeMillis();
                long currentDiffTime = currentTime - this.getCachedTime();
                long compDifftime = currentTime - comp.getCachedTime();
                if (currentDiffTime <= 0L) {
                    if (compDifftime <= 0L) {
                        if (this.getCount() == comp.getCount()) {
                            if (this.reference.equals(comp.getCachedReference())) {
                                return 0;
                            }
                            return this.hashCode() > comp.hashCode() ? -1 : 1;
                        }
                        if (this.getCount() > comp.getCount()) {
                            return 1;
                        }
                        return -1;
                    }
                    if (this.getCount() > 0) {
                        return 1;
                    }
                    return 1;
                }
                double ratio = this.getRatio(this, currentTime);
                if (ratio == (compRatio = this.getRatio(comp, currentTime))) {
                    if (this.reference.equals(comp.getCachedReference())) {
                        return 0;
                    }
                    return this.hashCode() > comp.hashCode() ? -1 : 1;
                }
                if (ratio > compRatio) {
                    return 1;
                }
                return -1;
            }
            if (comp.getCount() == this.getCount()) {
                if (this.reference.equals(comp.getCachedReference())) {
                    return 0;
                }
                return this.hashCode() > comp.hashCode() ? -1 : 1;
            }
            if (comp.getCount() > this.getCount()) {
                return -1;
            }
            return 1;
        }

        private double getRatio(CounterCachedReference target, long currentTime) {
            return (double)target.getCount() / ((double)(currentTime - target.getCachedTime()) / (double)this.ratioUnitTime);
        }
    }
}

