/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.cache;

import java.io.Serializable;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.cache.AbstractCacheService;
import jp.ossc.nimbus.service.cache.Cache;
import jp.ossc.nimbus.service.cache.CachedReference;
import jp.ossc.nimbus.service.cache.DefaultCachedReference;
import jp.ossc.nimbus.service.cache.MemoryCacheServiceMBean;

public class MemoryCacheService
extends AbstractCacheService
implements Serializable,
MemoryCacheServiceMBean {
    private static final long serialVersionUID = -1701042314659441524L;
    private ServiceName persistCacheServiceName;

    public void setPersistCacheServiceName(ServiceName name) {
        this.persistCacheServiceName = name;
    }

    public ServiceName getPersistCacheServiceName() {
        return this.persistCacheServiceName;
    }

    public void startService() throws Exception {
        if (this.persistCacheServiceName != null) {
            Cache persistCache = (Cache)ServiceManagerFactory.getServiceObject(this.persistCacheServiceName);
            CachedReference[] refs = persistCache.toArray();
            for (int i = 0; i < refs.length; ++i) {
                this.add(refs[i].get());
            }
        }
    }

    public void stopService() throws Exception {
        if (this.persistCacheServiceName != null) {
            Cache persistCache = (Cache)ServiceManagerFactory.getServiceObject(this.persistCacheServiceName);
            persistCache.clear();
            CachedReference[] refs = this.toArray();
            for (int i = 0; i < refs.length; ++i) {
                persistCache.add(refs[i].get());
            }
        }
    }

    protected CachedReference createCachedReference(Object obj) {
        return new DefaultCachedReference(obj);
    }
}

