/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.context.Context;
import jp.ossc.nimbus.service.context.ThreadContextServiceMBean;

public class ThreadContextService
extends ServiceBase
implements Context,
ThreadContextServiceMBean {
    private static final long serialVersionUID = -7304455455493489289L;
    protected ThreadLocal threadLocal;
    protected Map defaultMap;

    public void createService() throws Exception {
        this.defaultMap = new HashMap();
    }

    public void startService() throws Exception {
        if (this.threadLocal == null) {
            this.clearAllThreadContext();
        }
    }

    public void stopService() throws Exception {
        this.clearAllThreadContext();
    }

    public void destroyService() throws Exception {
        this.defaultMap = null;
    }

    public void clear() {
        Map map = (Map)this.threadLocal.get();
        this.init(map);
    }

    private void init(Map map) {
        if (map != null) {
            map.clear();
            map.putAll(this.defaultMap);
            Iterator entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object val = entry.getValue();
                if (val == null) continue;
                if (val instanceof ServiceName) {
                    ServiceName name = (ServiceName)val;
                    Object service = null;
                    try {
                        service = ServiceManagerFactory.getServiceObject(name);
                    }
                    catch (ServiceNotFoundException e) {
                        // empty catch block
                    }
                    entry.setValue(service);
                    continue;
                }
                if (!(val instanceof ServiceName[])) continue;
                ServiceName[] names = (ServiceName[])val;
                Object[] services = new Object[names.length];
                for (int i = 0; i < names.length; ++i) {
                    try {
                        services[i] = ServiceManagerFactory.getServiceObject(names[i]);
                        continue;
                    }
                    catch (ServiceNotFoundException e) {
                        // empty catch block
                    }
                }
                entry.setValue(services);
            }
        }
    }

    public int size() {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    public boolean isEmpty() {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.isEmpty();
        }
        return false;
    }

    public boolean containsKey(Object key) {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.containsKey(key);
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.containsValue(value);
        }
        return false;
    }

    public Set entrySet() {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.entrySet();
        }
        return new HashSet();
    }

    public Object get(Object key) {
        Map map = (Map)this.threadLocal.get();
        return map.get(key);
    }

    public Object put(Object key, Object value) {
        if (this.threadLocal == null) {
            return this.defaultMap.put(key, value);
        }
        Map map = (Map)this.threadLocal.get();
        return map.put(key, value);
    }

    public Object remove(Object key) {
        Map map = (Map)this.threadLocal.get();
        if (map != null) {
            return map.remove(key);
        }
        return null;
    }

    public void putAll(Map t) {
        Map map = (Map)this.threadLocal.get();
        map.putAll(t);
    }

    public Set keySet() {
        Map map = (Map)this.threadLocal.get();
        return map.keySet();
    }

    public Collection values() {
        Map map = (Map)this.threadLocal.get();
        return map.values();
    }

    public Map getDefaultMap() {
        return this.defaultMap;
    }

    public void clearAllThreadContext() {
        this.threadLocal = new InheritableThreadLocal(){

            protected synchronized Object initialValue() {
                Map map = Collections.synchronizedMap(new HashMap());
                ThreadContextService.this.init(map);
                return map;
            }

            protected synchronized Object childValue(Object parentValue) {
                Map parentMap = (Map)parentValue;
                Map map = null;
                if (parentMap == null) {
                    map = Collections.synchronizedMap(new HashMap());
                    ThreadContextService.this.init(map);
                } else {
                    map = Collections.synchronizedMap(new HashMap());
                    map.putAll(parentMap);
                }
                return map;
            }
        };
    }
}

