/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.converter;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jp.ossc.nimbus.recset.FieldSchema;
import jp.ossc.nimbus.recset.RecordSet;
import jp.ossc.nimbus.recset.RowData;
import jp.ossc.nimbus.service.converter.CodeMasterConverter;
import jp.ossc.nimbus.util.converter.ConvertException;

public class RecordSetCodeMasterConverter
implements CodeMasterConverter {
    protected String valueFieldName;
    protected Object notFoundObject;
    protected boolean isThrowOnNotFound;
    protected Object nullKeyObject;
    protected boolean isThrowOnNullKey;

    public void setValueFieldName(String name) {
        this.valueFieldName = name;
    }

    public String getValueFieldName() {
        return this.valueFieldName;
    }

    public void setNotFoundObject(Object obj) {
        this.notFoundObject = obj;
    }

    public Object getNotFoundObject() {
        return this.notFoundObject;
    }

    public boolean isThrowOnNotFound() {
        return this.isThrowOnNotFound;
    }

    public void setThrowOnNotFound(boolean isThrow) {
        this.isThrowOnNotFound = isThrow;
    }

    public void setNullKeyObject(Object obj) {
        this.nullKeyObject = obj;
    }

    public Object getNullKeyObject() {
        return this.nullKeyObject;
    }

    public boolean isThrowOnNullKey() {
        return this.isThrowOnNullKey;
    }

    public void setThrowOnNullKey(boolean isThrow) {
        this.isThrowOnNullKey = isThrow;
    }

    public Object convert(Object master, Object obj) throws ConvertException {
        if (!(master instanceof RecordSet)) {
            throw new ConvertException("CodeMaster is not RecordSet!");
        }
        RecordSet recset = (RecordSet)master;
        RowData row = null;
        try {
            if (obj instanceof DynamicCondition) {
                DynamicCondition cnd = (DynamicCondition)obj;
                Collection col = recset.searchDynamicCondition(cnd.conditionName);
                Iterator itr = col.iterator();
                if (itr.hasNext()) {
                    row = (RowData)itr.next();
                }
            } else if (obj instanceof DynamicConditionReal) {
                DynamicConditionReal cnd = (DynamicConditionReal)obj;
                if (cnd.condition == null) {
                    throw new ConvertException("DynamicConditionReal.condition is null.");
                }
                Collection col = recset.searchDynamicConditionReal(cnd.condition, cnd.orderBy, cnd.isAsc, cnd.valueMap);
                Iterator itr = col.iterator();
                if (itr.hasNext()) {
                    row = (RowData)itr.next();
                }
            } else if (obj instanceof DynamicKey) {
                Collection col;
                Iterator itr;
                DynamicKey cnd = (DynamicKey)obj;
                RowData key = null;
                if (cnd.keyMap != null) {
                    if (cnd.keyMap.size() == 0) {
                        if (this.isThrowOnNullKey) {
                            throw new ConvertException("DynamicKey.keyMap is empty.");
                        }
                        return this.nullKeyObject;
                    }
                    key = recset.createNewRecord();
                    Iterator entries = cnd.keyMap.entrySet().iterator();
                    while (entries.hasNext()) {
                        Map.Entry entry = entries.next();
                        String fieldName = (String)entry.getKey();
                        Object fieldValue = entry.getValue();
                        FieldSchema field = recset.getRowSchema().get(fieldName);
                        if (field == null) {
                            throw new ConvertException("Field '" + fieldName + "' is not found.");
                        }
                        key.setValueNative(field.getIndex(), fieldValue);
                    }
                } else {
                    if (cnd.keyRecord == null) {
                        if (this.isThrowOnNullKey) {
                            throw new ConvertException("DynamicKey.keyRecord is null.");
                        }
                        return this.nullKeyObject;
                    }
                    key = cnd.keyRecord;
                }
                if ((itr = (col = recset.searchDynamicKey(cnd.conditionName, key, cnd.orderBy, cnd.isAsc)).iterator()).hasNext()) {
                    row = (RowData)itr.next();
                }
            } else if (obj instanceof Key) {
                Key cnd = (Key)obj;
                if (cnd.key != null) {
                    row = recset.get(cnd.key);
                } else {
                    RowData key = null;
                    if (cnd.keyMap != null) {
                        if (cnd.keyMap.size() == 0) {
                            if (this.isThrowOnNullKey) {
                                throw new ConvertException("Key.keyMap is empty.");
                            }
                            return this.nullKeyObject;
                        }
                        key = recset.createNewRecord();
                        Iterator entries = cnd.keyMap.entrySet().iterator();
                        while (entries.hasNext()) {
                            Map.Entry entry = entries.next();
                            String fieldName = (String)entry.getKey();
                            Object fieldValue = entry.getValue();
                            FieldSchema field = recset.getRowSchema().get(fieldName);
                            if (field == null) {
                                throw new ConvertException("Field '" + fieldName + "' is not found.");
                            }
                            key.setValueNative(field.getIndex(), fieldValue);
                        }
                    } else {
                        if (cnd.keyRecord == null) {
                            if (this.isThrowOnNullKey) {
                                throw new ConvertException("Key.keyRecord is null.");
                            }
                            return this.nullKeyObject;
                        }
                        key = cnd.keyRecord;
                    }
                    row = recset.get(key);
                }
            } else {
                if (obj == null) {
                    if (this.isThrowOnNullKey) {
                        throw new ConvertException("Key is null.");
                    }
                    return this.nullKeyObject;
                }
                row = obj instanceof RowData ? recset.get((RowData)obj) : recset.get(obj.toString());
            }
        }
        catch (ConvertException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConvertException(e);
        }
        if (row == null) {
            if (this.isThrowOnNotFound) {
                throw new ConvertException("Record is not found. key=" + obj);
            }
            return this.notFoundObject;
        }
        return row.get(this.valueFieldName);
    }

    public static class Key {
        public String key;
        public Map keyMap;
        public RowData keyRecord;

        public String toString() {
            StringBuffer buf = new StringBuffer("Key{");
            buf.append("key=").append(this.key);
            buf.append(", keyMap=").append(this.keyMap);
            buf.append(", keyRecord=");
            if (this.keyRecord == null) {
                buf.append(this.keyRecord);
            } else {
                buf.append('{');
                for (int i = 0; i < this.keyRecord.size(); ++i) {
                    FieldSchema fieldSchema = this.keyRecord.getRowSchema().get(i);
                    buf.append(fieldSchema.getFieldName()).append('=').append(this.keyRecord.get(i));
                    if (i == this.keyRecord.size() - 1) continue;
                    buf.append(", ");
                }
                buf.append('}');
            }
            buf.append('}');
            return buf.toString();
        }
    }

    public static class DynamicKey {
        public String conditionName;
        public Map keyMap;
        public RowData keyRecord;
        public String[] orderBy;
        public boolean[] isAsc;

        public String toString() {
            int i;
            StringBuffer buf = new StringBuffer("DynamicKey{");
            buf.append("conditionName=").append(this.conditionName);
            buf.append(", keyMap=").append(this.keyMap);
            buf.append(", keyRecord=");
            if (this.keyRecord == null) {
                buf.append(this.keyRecord);
            } else {
                buf.append('{');
                for (i = 0; i < this.keyRecord.size(); ++i) {
                    FieldSchema fieldSchema = this.keyRecord.getRowSchema().get(i);
                    buf.append(fieldSchema.getFieldName()).append('=').append(this.keyRecord.get(i));
                    if (i == this.orderBy.length - 1) continue;
                    buf.append(", ");
                }
                buf.append('}');
            }
            buf.append(", orderBy=");
            if (this.orderBy == null) {
                buf.append(this.orderBy);
            } else {
                buf.append('[');
                for (i = 0; i < this.orderBy.length; ++i) {
                    buf.append(this.orderBy[i]);
                    if (i == this.orderBy.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(']');
            }
            buf.append(", isAsc=");
            if (this.isAsc == null) {
                buf.append(this.isAsc);
            } else {
                buf.append('[');
                for (i = 0; i < this.isAsc.length; ++i) {
                    buf.append(this.isAsc[i]);
                    if (i == this.isAsc.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(']');
            }
            buf.append('}');
            return buf.toString();
        }
    }

    public static class DynamicConditionReal {
        public String condition;
        public Map valueMap;
        public String[] orderBy;
        public boolean[] isAsc;

        public String toString() {
            int i;
            StringBuffer buf = new StringBuffer("DynamicConditionReal{");
            buf.append("condition=").append(this.condition);
            buf.append(", valueMap=").append(this.valueMap);
            buf.append(", orderBy=");
            if (this.orderBy == null) {
                buf.append(this.orderBy);
            } else {
                buf.append('[');
                for (i = 0; i < this.orderBy.length; ++i) {
                    buf.append(this.orderBy[i]);
                    if (i == this.orderBy.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(']');
            }
            buf.append(", isAsc=");
            if (this.isAsc == null) {
                buf.append(this.isAsc);
            } else {
                buf.append('[');
                for (i = 0; i < this.isAsc.length; ++i) {
                    buf.append(this.isAsc[i]);
                    if (i == this.isAsc.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(']');
            }
            buf.append('}');
            return buf.toString();
        }
    }

    public static class DynamicCondition {
        public String conditionName;

        public String toString() {
            return "DynamicCondition{conditionName=" + this.conditionName + '}';
        }
    }
}

