/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.http.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class HttpRequest {
    private static final String HEADER_NAME_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_NAME_CONTENT_ENCODING = "Content-Encoding";
    private static final String HEADER_NAME_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_NAME_TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String CONTENT_ENCODING_DEFLATE = "deflate";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_ENCODING_X_GZIP = "x-gzip";
    private static final String CHARSET = "charset";
    private static final String DEFAULT_CHARACTER_ENCODING = "ISO8859_1";
    private static final String CHUNKED = "chunked";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String HTTP_METHOD_POST = "POST";
    protected RequestHeader header;
    protected RequestBody body;

    public HttpRequest() {
    }

    public HttpRequest(InputStream is) throws Exception {
        this.header = new RequestHeader();
        this.header.read(is);
        if (HTTP_METHOD_POST.equals(this.header.method)) {
            this.body = new RequestBody(this.header, is);
        }
    }

    public RequestHeader getHeader() {
        return this.header;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public class RequestBody {
        protected InputStream inputStream;
        protected RequestHeader header;
        protected String body;
        protected boolean isDecompress = true;

        public RequestBody(RequestHeader header, InputStream is) throws Exception {
            this.header = header;
            this.inputStream = is;
            int contentLength = header.getContentLength();
            String[] contentEncoding = header.getContentEncoding();
            if (this.isDecompress && contentLength > 0 && contentEncoding != null) {
                this.inputStream = this.decompress(this.inputStream, contentEncoding, contentLength);
            }
        }

        public void setDecompress(boolean isDecompress) {
            this.isDecompress = isDecompress;
        }

        public boolean isDecompress() {
            return this.isDecompress;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void read() throws Exception {
            int offset;
            int contentLength = this.header.getContentLength();
            if (contentLength <= 0) {
                return;
            }
            if (this.header.isChunked()) {
                throw new Exception("Chunk is not supported.");
            }
            byte[] readBytes = new byte[contentLength + 1];
            int readLength = 0;
            for (offset = 0; offset < contentLength && (readLength = this.inputStream.read(readBytes, offset, contentLength - offset)) != -1; offset += readLength) {
            }
            readLength = readLength == -1 ? offset : contentLength;
            String characterEncoding = this.header.getCharacterEncoding();
            this.body = new String(readBytes, 0, readLength, characterEncoding);
        }

        protected InputStream decompress(InputStream is, String[] contentEncoding, int contentLength) throws IOException {
            ByteArrayInputStream bais;
            if (contentEncoding == null || contentEncoding.length == 0) {
                return is;
            }
            byte[] buf = new byte[contentLength];
            int length = 0;
            for (int offset = 0; (length = is.read(buf, offset, contentLength - offset)) != -1 && offset < contentLength; offset += length) {
            }
            InputStream in = bais = new ByteArrayInputStream(buf);
            for (int i = contentEncoding.length - 1; i >= 0; --i) {
                String encode = contentEncoding[i];
                if (encode == null) continue;
                if (encode.indexOf(HttpRequest.CONTENT_ENCODING_DEFLATE) != -1) {
                    in = new InflaterInputStream(in);
                    continue;
                }
                if (encode.indexOf(HttpRequest.CONTENT_ENCODING_GZIP) != -1 || encode.indexOf(HttpRequest.CONTENT_ENCODING_X_GZIP) != -1) {
                    in = new GZIPInputStream(in);
                    continue;
                }
                throw new IOException("Can not decompress. [" + encode + "]");
            }
            int data = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((data = ((InputStream)in).read()) != -1) {
                baos.write(data);
            }
            buf = baos.toByteArray();
            this.header.setContentLength(buf.length);
            bais = new ByteArrayInputStream(buf);
            return bais;
        }

        public String toString() {
            return this.body;
        }

        public Matcher getMatcher(String body) {
            return Pattern.compile(body).matcher(this.body == null ? "" : this.body);
        }
    }

    public class RequestHeader {
        protected String header;
        protected String method;
        protected String url;
        protected String query;
        protected String version;
        protected Map headerMap = new HashMap();

        public String getMethod() {
            return this.method;
        }

        public String getURL() {
            return this.url;
        }

        public Matcher getURLMatcher(String url) {
            return Pattern.compile(url).matcher(this.url);
        }

        public String getQuery() {
            return this.query;
        }

        public Matcher getQueryMatcher(String query) {
            return Pattern.compile(query).matcher(this.query == null ? "" : this.query);
        }

        public String getVersion() {
            return this.version;
        }

        public String getHeader(String name) {
            String[] vals = (String[])this.headerMap.get(name);
            return vals == null ? null : vals[0];
        }

        public String[] getHeaders(String name) {
            return (String[])this.headerMap.get(name);
        }

        public int getContentLength() {
            String contentLengthStr = this.getHeader(HttpRequest.HEADER_NAME_CONTENT_LENGTH);
            if (contentLengthStr == null) {
                return -1;
            }
            int contentLength = -1;
            try {
                contentLength = Integer.parseInt(contentLengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return contentLength;
        }

        public void setContentLength(int length) {
            this.headerMap.put(HttpRequest.HEADER_NAME_CONTENT_LENGTH, new String[]{String.valueOf(length)});
        }

        public String getCharacterEncoding() {
            String characterEncoding = HttpRequest.DEFAULT_CHARACTER_ENCODING;
            String contentType = this.getHeader(HttpRequest.HEADER_NAME_CONTENT_TYPE);
            if (contentType == null) {
                return characterEncoding;
            }
            StringTokenizer tokens = new StringTokenizer(contentType, ";");
            while (tokens.hasMoreTokens()) {
                String charset;
                int index;
                String token = tokens.nextToken();
                if (token.indexOf(HttpRequest.CHARSET) == -1 || (index = token.indexOf(61)) <= 0 || index == token.length() - 1 || (charset = token.substring(index + 1).trim()).length() == 0) continue;
                characterEncoding = charset;
                break;
            }
            return characterEncoding;
        }

        public String[] getContentEncoding() {
            String[] contentEncoding = this.getHeaders(HttpRequest.HEADER_NAME_CONTENT_ENCODING);
            return contentEncoding;
        }

        public String getAcceptEncoding() {
            String acceptEncoding = this.getHeader(HttpRequest.HEADER_ACCEPT_ENCODING);
            return acceptEncoding;
        }

        public boolean isChunked() {
            String transferEncoding = this.getHeader(HttpRequest.HEADER_NAME_TRANSFER_ENCODING);
            if (transferEncoding == null) {
                return false;
            }
            return HttpRequest.CHUNKED.equals(transferEncoding.trim());
        }

        public void read(InputStream is) throws Exception {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String requestLine = this.readLine(is, baos);
            requestLine = requestLine.trim();
            pw.println(requestLine);
            String[] requests = requestLine.split(" ");
            if (requests.length != 3) {
                throw new Exception("illegal request : " + requestLine);
            }
            this.method = requests[0];
            if (!this.method.equals(HttpRequest.HTTP_METHOD_POST) && !this.method.equals(HttpRequest.HTTP_METHOD_GET)) {
                throw new Exception("unsupported http method : " + this.method);
            }
            int index = requests[1].indexOf(59);
            if (index == -1) {
                index = requests[1].indexOf(63);
                if (index == -1) {
                    this.url = requests[1];
                } else {
                    this.url = requests[1].substring(0, index);
                    this.query = requests[1].substring(index + 1);
                }
            } else {
                this.url = requests[1].substring(0, index);
                index = requests[1].indexOf(63);
                if (index != -1) {
                    this.query = requests[1].substring(index + 1);
                }
            }
            this.version = requests[2];
            String headerLine = null;
            while ((headerLine = this.readLine(is, baos)) != null) {
                pw.println(headerLine);
                headerLine = headerLine.trim();
                if (headerLine.length() == 0) break;
                index = headerLine.indexOf(58);
                if (index == -1 || index == 0 || index == headerLine.length() - 1) continue;
                String name = headerLine.substring(0, index).trim();
                String val = headerLine.substring(index + 1).trim();
                String[] vals = (String[])this.headerMap.get(name);
                if (vals == null) {
                    vals = new String[]{val};
                    this.headerMap.put(name, vals);
                    continue;
                }
                String[] newVals = new String[vals.length + 1];
                System.arraycopy(vals, 0, newVals, 0, vals.length);
                newVals[newVals.length - 1] = val;
                this.headerMap.put(name, newVals);
            }
            pw.close();
            this.header = sw.toString();
        }

        protected String readLine(InputStream is, ByteArrayOutputStream tmp) throws IOException {
            tmp.reset();
            int val = 0;
            while ((val = is.read()) != -1) {
                if (val == 13) {
                    val = is.read();
                    boolean isBreak = false;
                    switch (val) {
                        case -1: {
                            isBreak = true;
                            break;
                        }
                        case 10: {
                            isBreak = true;
                            break;
                        }
                        default: {
                            tmp.write(13);
                            tmp.write(val);
                        }
                    }
                    if (!isBreak) continue;
                    break;
                }
                tmp.write(val);
            }
            return new String(tmp.toByteArray());
        }

        public String toString() {
            return this.header;
        }
    }
}

