/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.interpreter;

import bsh.EvalError;
import bsh.ParseException;
import bsh.TargetError;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.interpreter.BeanShellInterpreterServiceMBean;
import jp.ossc.nimbus.service.interpreter.EvaluateException;
import jp.ossc.nimbus.service.interpreter.Interpreter;

public class BeanShellInterpreterService
extends ServiceBase
implements Interpreter,
BeanShellInterpreterServiceMBean {
    private static final long serialVersionUID = -3344112113293549493L;
    private Map variables;
    private ClassLoader classLoader;
    private String[] sourceFileNames;
    private boolean isNewInterpreterByEvaluate = true;
    private bsh.Interpreter interpreter;

    public void setVariableServiceName(String name, ServiceName serviceName) {
        this.variables.put(name, new Variable(serviceName));
    }

    public ServiceName getVariableServiceName(String name) {
        return this.variables.containsKey(name) ? (ServiceName)((Variable)this.variables.get((Object)name)).value : null;
    }

    public void setVariableObject(String name, Object val) {
        this.variables.put(name, new Variable(val));
    }

    public Object getVariableObject(String name) {
        return this.variables.containsKey(name) ? ((Variable)this.variables.get((Object)name)).value : null;
    }

    public void setVariableInt(String name, int val) {
        this.variables.put(name, new Variable(val));
    }

    public int getVariableInt(String name) {
        return ((Number)((Variable)this.variables.get((Object)name)).value).intValue();
    }

    public void setVariableLong(String name, long val) {
        this.variables.put(name, new Variable(val));
    }

    public long getVariableLong(String name) {
        return ((Number)((Variable)this.variables.get((Object)name)).value).longValue();
    }

    public void setVariableFloat(String name, float val) {
        this.variables.put(name, new Variable(val));
    }

    public float getVariableFloat(String name) {
        return ((Number)((Variable)this.variables.get((Object)name)).value).floatValue();
    }

    public void setVariableDouble(String name, double val) {
        this.variables.put(name, new Variable(val));
    }

    public double getVariableDouble(String name) {
        return ((Number)((Variable)this.variables.get((Object)name)).value).doubleValue();
    }

    public void setVariableBoolean(String name, boolean val) {
        this.variables.put(name, new Variable(val));
    }

    public boolean getVariableBoolean(String name) {
        return (Boolean)((Variable)this.variables.get((Object)name)).value;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Map getVariables() {
        return this.variables;
    }

    public void setSourceFileNames(String[] names) {
        this.sourceFileNames = names;
    }

    public String[] getSourceFileNames() {
        return this.sourceFileNames;
    }

    public void setNewInterpreterByEvaluate(boolean isNew) {
        this.isNewInterpreterByEvaluate = isNew;
    }

    public boolean isNewInterpreterByEvaluate() {
        return this.isNewInterpreterByEvaluate;
    }

    public void createService() throws Exception {
        this.variables = new HashMap();
    }

    public void startService() throws Exception {
        if (!this.isNewInterpreterByEvaluate) {
            this.interpreter = new bsh.Interpreter();
            this.setUpInterpreter(this.interpreter, null);
        }
    }

    public void destroyService() throws Exception {
        this.variables = null;
    }

    public Object evaluate(String code) throws EvaluateException {
        return this.evaluate(code, null);
    }

    private void setUpInterpreter(bsh.Interpreter interpreter, Map variables) throws EvalError, IOException {
        if (this.classLoader != null) {
            interpreter.setClassLoader(this.classLoader);
        }
        HashMap variableMap = new HashMap();
        if (this.variables != null) {
            variableMap.putAll(this.variables);
        }
        if (variables != null) {
            variableMap.putAll(variables);
        }
        if (variableMap.size() != 0) {
            Iterator entries = variableMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String name = (String)entry.getKey();
                Object val = entry.getValue();
                if (val instanceof Variable) {
                    Variable var = (Variable)val;
                    if (var.isPrimitive) {
                        if (var.value instanceof Integer) {
                            interpreter.set(name, ((Number)var.value).intValue());
                            continue;
                        }
                        if (var.value instanceof Long) {
                            interpreter.set(name, ((Number)var.value).longValue());
                            continue;
                        }
                        if (var.value instanceof Float) {
                            interpreter.set(name, ((Number)var.value).floatValue());
                            continue;
                        }
                        if (var.value instanceof Double) {
                            interpreter.set(name, ((Number)var.value).doubleValue());
                            continue;
                        }
                        interpreter.set(name, ((Boolean)var.value).booleanValue());
                        continue;
                    }
                    if (var.isServiceName) {
                        Object service = null;
                        try {
                            service = ServiceManagerFactory.getServiceObject((ServiceName)var.value);
                        }
                        catch (ServiceNotFoundException e) {
                            // empty catch block
                        }
                        interpreter.set(name, service);
                        continue;
                    }
                    interpreter.set(name, var.value);
                    continue;
                }
                interpreter.set(name, val);
            }
        }
        if (this.sourceFileNames != null && this.sourceFileNames.length != 0) {
            for (int i = 0; i < this.sourceFileNames.length; ++i) {
                interpreter.source(this.sourceFileNames[i]);
            }
        }
    }

    public Object evaluate(String code, Map variables) throws EvaluateException {
        if (this.getState() != 3) {
            throw new EvaluateException("Service is not available.");
        }
        bsh.Interpreter interpreter = this.isNewInterpreterByEvaluate ? new bsh.Interpreter() : this.interpreter;
        try {
            this.setUpInterpreter(interpreter, variables);
            return interpreter.eval(code);
        }
        catch (ParseException e) {
            throw new EvaluateException("Compile error.", e);
        }
        catch (TargetError e) {
            throw new EvaluateException("Runtime error.", e);
        }
        catch (Throwable th) {
            throw new EvaluateException(th);
        }
    }

    private static void usage() {
        System.out.println("\u30b3\u30de\u30f3\u30c9\u4f7f\u7528\u65b9\u6cd5\uff1a");
        System.out.println(" java jp.ossc.nimbus.service.interpreter.BeanShellInterpreterService [options] [source code]");
        System.out.println();
        System.out.println("[options]");
        System.out.println();
        System.out.println(" [-servicepath paths]");
        System.out.println("  \u30a4\u30f3\u30bf\u30fc\u30d7\u30ea\u30bf\u30b5\u30fc\u30d3\u30b9\u306e\u8d77\u52d5\u306b\u5fc5\u8981\u306a\u30b5\u30fc\u30d3\u30b9\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u306e\u30d1\u30b9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("  \u30d1\u30b9\u30bb\u30d1\u30ec\u30fc\u30bf\u533a\u5207\u308a\u3067\u8907\u6570\u6307\u5b9a\u53ef\u80fd\u3067\u3059\u3002");
        System.out.println();
        System.out.println(" [-servicename name]");
        System.out.println("  \u30a4\u30f3\u30bf\u30fc\u30d7\u30ea\u30bf\u30b5\u30fc\u30d3\u30b9\u306e\u30b5\u30fc\u30d3\u30b9\u540d\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("  \u6307\u5b9a\u3057\u306a\u3044\u5834\u5408\u306fNimbus#Interpreter\u3068\u307f\u306a\u3057\u307e\u3059\u3002");
        System.out.println();
        System.out.println(" [-file paths]");
        System.out.println("  \u5b9f\u884c\u3059\u308b\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println("  \u30d1\u30b9\u30bb\u30d1\u30ec\u30fc\u30bf\u533a\u5207\u308a\u3067\u8907\u6570\u6307\u5b9a\u53ef\u80fd\u3067\u3059\u3002");
        System.out.println("  \u3053\u306e\u30aa\u30d7\u30b7\u30e7\u30f3\u306e\u6307\u5b9a\u304c\u306a\u3044\u5834\u5408\u306f\u3001\u5f15\u6570source code\u3067\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println();
        System.out.println(" [-encoding path]");
        System.out.println("  \u5b9f\u884c\u3059\u308b\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u30d5\u30a1\u30a4\u30eb\u306e\u6587\u5b57\u30b3\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println();
        System.out.println(" [-help]");
        System.out.println("  \u30d8\u30eb\u30d7\u3092\u8868\u793a\u3057\u307e\u3059\u3002");
        System.out.println();
        System.out.println("[source code]");
        System.out.println(" \u5b9f\u884c\u3059\u308b\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        System.out.println();
        System.out.println(" \u4f7f\u7528\u4f8b : ");
        System.out.println("    java -classpath classes;lib/bsh-2.0b4.jar;lib/nimbus.jar jp.ossc.nimbus.service.interpreter.BeanShellInterpreterService System.out.println(\"test\");");
    }

    private static List parsePaths(String paths) {
        String pathSeparator = System.getProperty("path.separator");
        ArrayList<String> result = new ArrayList<String>();
        if (paths == null || paths.length() == 0) {
            return result;
        }
        if (paths.indexOf(pathSeparator) == -1) {
            result.add(paths);
            return result;
        }
        String tmpPaths = paths;
        int index = -1;
        while ((index = tmpPaths.indexOf(pathSeparator)) != -1) {
            result.add(tmpPaths.substring(0, index));
            if (index != tmpPaths.length() - 1) {
                tmpPaths = tmpPaths.substring(index + 1);
                continue;
            }
            tmpPaths = null;
            break;
        }
        if (tmpPaths != null && tmpPaths.length() != 0) {
            result.add(tmpPaths);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        int imax;
        if (args.length == 0 || args.length != 0 && args[0].equals("-help")) {
            BeanShellInterpreterService.usage();
            if (args.length == 0) {
                System.exit(-1);
            }
            return;
        }
        boolean option = false;
        String key = null;
        ServiceName serviceName = null;
        List servicePaths = null;
        List files = null;
        String encode = null;
        StringWriter code = new StringWriter();
        PrintWriter codeWriter = new PrintWriter(code);
        for (int i = 0; i < args.length; ++i) {
            if (option) {
                if (key.equals("-servicename")) {
                    ServiceNameEditor editor = new ServiceNameEditor();
                    editor.setAsText(args[i]);
                    serviceName = (ServiceName)editor.getValue();
                } else if (key.equals("-servicepath")) {
                    servicePaths = BeanShellInterpreterService.parsePaths(args[i]);
                } else if (key.equals("-file")) {
                    files = BeanShellInterpreterService.parsePaths(args[i]);
                } else if (key.equals("-encoding")) {
                    encode = args[i];
                }
                option = false;
                key = null;
                continue;
            }
            if (args[i].equals("-servicename") || args[i].equals("-servicepath") || args[i].equals("-file") || args[i].equals("-encoding")) {
                option = true;
                key = args[i];
                continue;
            }
            if (args[i].equals("-help")) {
                BeanShellInterpreterService.usage();
                return;
            }
            codeWriter.print(" " + args[i]);
        }
        Interpreter interpreter = null;
        if (servicePaths == null) {
            BeanShellInterpreterService service = new BeanShellInterpreterService();
            service.create();
            service.start();
            interpreter = service;
        } else {
            imax = servicePaths.size();
            for (int i = 0; i < imax; ++i) {
                if (ServiceManagerFactory.loadManager((String)servicePaths.get(i))) continue;
                System.out.println("Service load error." + servicePaths.get(i));
                return;
            }
            if (serviceName == null) {
                serviceName = new ServiceName("Nimbus", "Interpreter");
            }
            interpreter = (Interpreter)ServiceManagerFactory.getServiceObject(serviceName);
        }
        if (files != null) {
            code.flush();
            imax = files.size();
            for (int i = 0; i < imax; ++i) {
                FileInputStream fis = new FileInputStream((String)files.get(i));
                InputStreamReader isr = null;
                isr = encode == null ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, encode);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    codeWriter.println(line);
                }
                fis.close();
            }
        }
        codeWriter.flush();
        try {
            System.out.println(interpreter.evaluate(code.toString()));
        }
        catch (Throwable e) {
            StringBuffer buf = new StringBuffer();
            String lineSeparator = System.getProperty("line.separator");
            buf.append("Exception occuers :").append(e.toString()).append(lineSeparator);
            StackTraceElement[] elemss = e.getStackTrace();
            if (elemss != null) {
                for (int i = 0; i < elemss.length; ++i) {
                    buf.append('\t');
                    if (elemss[i] != null) {
                        buf.append(elemss[i].toString()).append(lineSeparator);
                        continue;
                    }
                    buf.append("null").append(lineSeparator);
                }
            }
            Throwable ee = BeanShellInterpreterService.getCause(e);
            while (ee != null) {
                buf.append("Caused by:").append(ee.toString()).append(lineSeparator);
                StackTraceElement[] elems = ee.getStackTrace();
                if (elems != null) {
                    for (int i = 0; i < elems.length; ++i) {
                        buf.append('\t');
                        if (elems[i] != null) {
                            buf.append(elems[i].toString()).append(lineSeparator);
                            continue;
                        }
                        buf.append("null").append(lineSeparator);
                    }
                }
                ee = BeanShellInterpreterService.getCause(ee);
            }
            System.out.println(buf.toString());
            System.exit(-1);
        }
    }

    private static Throwable getCause(Throwable th) {
        Throwable cause = th.getCause();
        return cause == th ? null : cause;
    }

    public static class Variable
    implements Serializable {
        private static final long serialVersionUID = -3344112113293549490L;
        boolean isPrimitive;
        boolean isServiceName;
        Object value;

        public Variable(ServiceName val) {
            this.isServiceName = true;
            this.value = val;
        }

        public Variable(Object val) {
            this.value = val;
        }

        public Variable(int val) {
            this.isPrimitive = true;
            this.value = new Integer(val);
        }

        public Variable(long val) {
            this.isPrimitive = true;
            this.value = new Long(val);
        }

        public Variable(float val) {
            this.isPrimitive = true;
            this.value = new Float(val);
        }

        public Variable(double val) {
            this.isPrimitive = true;
            this.value = new Double(val);
        }

        public Variable(boolean val) {
            this.isPrimitive = true;
            this.value = val ? Boolean.TRUE : Boolean.FALSE;
        }

        public String toString() {
            return this.value == null ? "null" : this.value.toString();
        }
    }
}

