/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.JournalRecord;
import jp.ossc.nimbus.service.journal.RequestJournal;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class JournalRecordImpl
implements JournalRecord,
Serializable {
    private static final long serialVersionUID = 4377038814532613910L;
    private String mKey = null;
    private transient EditorFinder mFinder = null;
    private ServiceName mFinderName;
    private Object mEditObj = null;
    private transient Object mParamObj = null;

    public String getKey() {
        return this.mKey;
    }

    public void setKey(String key) {
        this.mKey = key;
    }

    public void setEditorFinder(EditorFinder finder) {
        this.mFinder = finder;
        if (this.mFinder instanceof ServiceBase) {
            this.mFinderName = ((ServiceBase)((Object)this.mFinder)).getServiceNameObject();
        } else if (this.mFinder instanceof Service) {
            Service service = (Service)((Object)this.mFinder);
            this.mFinderName = new ServiceName(service.getServiceManagerName(), service.getServiceName());
        }
    }

    public void setParamObj(Object obj) {
        this.mParamObj = obj;
    }

    public void setInfoObj(Object obj) {
        this.mParamObj = obj;
        JournalEditor editor = this.getJournalEditor();
        this.mEditObj = editor.toObject(this.mFinder, this.mKey, obj);
    }

    public Object toObject() {
        if (this.mEditObj == null) {
            JournalEditor editor = this.getJournalEditor();
            this.mEditObj = editor.toObject(this.mFinder, this.mKey, this.mParamObj);
        }
        return this.mEditObj;
    }

    public Object toObject(EditorFinder finder) {
        Object ret = null;
        if (this.mEditObj == null) {
            JournalEditor editor = finder.findEditor((Object)this.mKey, this.mParamObj);
            ret = editor.toObject(finder, this.mKey, this.mParamObj);
        }
        return ret;
    }

    public Object getObject() {
        return this.mParamObj;
    }

    public EditorFinder getFinder() {
        return this.mFinder;
    }

    public JournalEditor getJournalEditor() {
        return this.mFinder == null ? null : this.mFinder.findEditor((Object)this.mKey, this.mParamObj);
    }

    public boolean isStep() {
        return this.mParamObj != null && this.mParamObj instanceof RequestJournal;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.mFinderName == null && this.mFinder != null) {
            out.writeObject(this.mFinder);
        }
        if (this.mParamObj != null && this.mParamObj instanceof RequestJournal) {
            out.writeObject(this.mParamObj);
        } else {
            out.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.mFinderName == null) {
            this.mFinder = (EditorFinder)in.readObject();
        } else {
            try {
                this.mFinder = (EditorFinder)ServiceManagerFactory.getServiceObject(this.mFinderName);
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        this.mParamObj = in.readObject();
    }
}

