/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import jp.ossc.nimbus.service.journal.editor.HttpServletRequestJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.ServletRequestJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpServletRequestJournalEditorService
extends ServletRequestJournalEditorService
implements HttpServletRequestJournalEditorServiceMBean,
Serializable {
    private static final long serialVersionUID = -9043912557706557947L;
    private static final String AUTH_TYPE_HEADER = "Authentication Type : ";
    private static final String REMOTE_USER_HEADER = "Remote User : ";
    private static final String USER_PRINCIPAL_HEADER = "User Principal : ";
    private static final String REQUEST_URL_HEADER = "Request URL : ";
    private static final String REQUEST_URI_HEADER = "Request URI : ";
    private static final String SERVLET_PATH_HEADER = "Servlet Path : ";
    private static final String SESSION_ID_HEADER = "Request Session ID : ";
    private static final String HTTP_METHOD_HEADER = "HTTP Method : ";
    private static final String HTTP_HEADER_HEADER = "HTTP Header : ";
    private static final String COOKIE_HEADER = "Cookie : ";
    private static final String CONTEXT_PATH_HEADER = "Context Path : ";
    private static final String PATH_INFO_HEADER = "Path Info : ";
    private static final String PATH_TRAN_HEADER = "Path Translated : ";
    private static final String QUERY_STRING_HEADER = "Query String : ";
    private static final String FROM_COOKIE = "From Cookie";
    private static final String FROM_URL = "From URL";
    private static final String HEADER_SEPARATOR = " = ";
    private static final String HEADER_VALUE_SEPARATOR = ", ";
    private static final String COOKIE_SEPARATOR = " = ";
    private static final String COOKIE_ATTR_SEPARATOR = "; ";
    private static final String COOKIE_COMMENT = "Comment";
    private static final String COOKIE_DOMAIN = "Domain";
    private static final String COOKIE_MAX_AGE = "MaxAge";
    private static final String COOKIE_PATH = "Path";
    private static final String COOKIE_SECURE = "Secure";
    private static final String COOKIE_VERSION = "Version";
    private static final String OPEN_BRACKET = "( ";
    private static final String CLOSE_BRACKET = " )";
    private static final String HEADER = "[HttpServletRequest]";
    private boolean isOutputRequestURL = true;
    private boolean isOutputRequestURI = true;
    private boolean isOutputServletPath = true;
    private boolean isOutputContextPath = true;
    private boolean isOutputPathInfo = true;
    private boolean isOutputPathTranslated = true;
    private boolean isOutputQueryString = true;
    private boolean isOutputSessionID = true;
    private boolean isOutputMethod = true;
    private boolean isOutputAuthType = true;
    private boolean isOutputRemoteUser = true;
    private boolean isOutputUserPrincipal = true;
    private boolean isOutputHeaders = true;
    private boolean isOutputCookies = true;
    private String[] secretHeaders;
    protected Set secretHeaderSet;
    private String[] enabledHeaders;
    protected Set enabledHeaderSet;
    private String[] secretCookies;
    protected Set secretCookieSet;
    private String[] enabledCookies;
    protected Set enabledCookieSet;

    public HttpServletRequestJournalEditorService() {
        this.setHeader(HEADER);
    }

    public void setOutputRequestURL(boolean isOutput) {
        this.isOutputRequestURL = isOutput;
    }

    public boolean isOutputRequestURL() {
        return this.isOutputRequestURL;
    }

    public void setOutputRequestURI(boolean isOutput) {
        this.isOutputRequestURI = isOutput;
    }

    public boolean isOutputRequestURI() {
        return this.isOutputRequestURI;
    }

    public void setOutputServletPath(boolean isOutput) {
        this.isOutputServletPath = isOutput;
    }

    public boolean isOutputServletPath() {
        return this.isOutputServletPath;
    }

    public void setOutputContextPath(boolean isOutput) {
        this.isOutputContextPath = isOutput;
    }

    public boolean isOutputContextPath() {
        return this.isOutputContextPath;
    }

    public void setOutputPathInfo(boolean isOutput) {
        this.isOutputPathInfo = isOutput;
    }

    public boolean isOutputPathInfo() {
        return this.isOutputPathInfo;
    }

    public void setOutputPathTranslated(boolean isOutput) {
        this.isOutputPathTranslated = isOutput;
    }

    public boolean isOutputPathTranslated() {
        return this.isOutputPathTranslated;
    }

    public void setOutputQueryString(boolean isOutput) {
        this.isOutputQueryString = isOutput;
    }

    public boolean isOutputQueryString() {
        return this.isOutputQueryString;
    }

    public void setOutputSessionID(boolean isOutput) {
        this.isOutputSessionID = isOutput;
    }

    public boolean isOutputSessionID() {
        return this.isOutputSessionID;
    }

    public void setOutputMethod(boolean isOutput) {
        this.isOutputMethod = isOutput;
    }

    public boolean isOutputMethod() {
        return this.isOutputMethod;
    }

    public void setOutputAuthType(boolean isOutput) {
        this.isOutputAuthType = isOutput;
    }

    public boolean isOutputAuthType() {
        return this.isOutputAuthType;
    }

    public void setOutputRemoteUser(boolean isOutput) {
        this.isOutputRemoteUser = isOutput;
    }

    public boolean isOutputRemoteUser() {
        return this.isOutputRemoteUser;
    }

    public void setOutputUserPrincipal(boolean isOutput) {
        this.isOutputUserPrincipal = isOutput;
    }

    public boolean isOutputUserPrincipal() {
        return this.isOutputUserPrincipal;
    }

    public void setOutputHeaders(boolean isOutput) {
        this.isOutputHeaders = isOutput;
    }

    public boolean isOutputHeaders() {
        return this.isOutputHeaders;
    }

    public void setOutputCookies(boolean isOutput) {
        this.isOutputCookies = isOutput;
    }

    public boolean isOutputCookies() {
        return this.isOutputCookies;
    }

    public void setSecretHeaders(String[] names) {
        this.secretHeaders = names;
    }

    public String[] getSecretHeaders() {
        return this.secretHeaders;
    }

    public void setEnabledHeaders(String[] names) {
        this.enabledHeaders = names;
    }

    public String[] getEnabledHeaders() {
        return this.enabledHeaders;
    }

    public void setSecretCookies(String[] names) {
        this.secretCookies = names;
    }

    public String[] getSecretCookies() {
        return this.secretCookies;
    }

    public void setEnabledCookies(String[] names) {
        this.enabledCookies = names;
    }

    public String[] getEnabledCookies() {
        return this.enabledCookies;
    }

    public void createService() throws Exception {
        super.createService();
        this.secretHeaderSet = new HashSet();
        this.enabledHeaderSet = new HashSet();
        this.secretCookieSet = new HashSet();
        this.enabledCookieSet = new HashSet();
    }

    public void startService() throws Exception {
        int i;
        super.startService();
        if (this.secretHeaders != null) {
            for (i = 0; i < this.secretHeaders.length; ++i) {
                this.secretHeaderSet.add(this.secretHeaders[i]);
            }
        }
        if (this.enabledHeaders != null) {
            for (i = 0; i < this.enabledHeaders.length; ++i) {
                this.enabledHeaderSet.add(this.enabledHeaders[i]);
            }
        }
        if (this.secretCookies != null) {
            for (i = 0; i < this.secretCookies.length; ++i) {
                this.secretCookieSet.add(this.secretCookies[i]);
            }
        }
        if (this.enabledCookies != null) {
            for (i = 0; i < this.enabledCookies.length; ++i) {
                this.enabledCookieSet.add(this.enabledCookies[i]);
            }
        }
    }

    public void stopService() throws Exception {
        super.stopService();
        this.secretHeaderSet.clear();
        this.enabledHeaderSet.clear();
        this.secretCookieSet.clear();
        this.enabledCookieSet.clear();
    }

    public void destroyService() throws Exception {
        super.destroyService();
        this.secretHeaderSet = null;
        this.enabledHeaderSet = null;
        this.secretCookieSet = null;
        this.enabledCookieSet = null;
    }

    protected boolean processBlock(EditorFinder finder, Object key, Object value, StringBuffer buf) {
        ServletRequest request = (ServletRequest)value;
        boolean isMake = super.processBlock(finder, key, request, buf);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isOutputRequestURL()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeRequestURLFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputRequestURI()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeRequestURIFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputServletPath()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeServletPathFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputContextPath()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeContextPathFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputPathInfo()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makePathInfoFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputPathTranslated()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makePathTranslatedFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputQueryString()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeQueryStringFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputSessionID()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeSessionIDFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputMethod()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeMethodFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputAuthType()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeAuthTypeFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputRemoteUser()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeRemoteUserFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputUserPrincipal()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeUserPrincipalFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputHeaders()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeHeadersFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        if (this.isOutputCookies()) {
            if (isMake) {
                buf.append(this.getLineSeparator());
            }
            this.makeCookiesFormat(finder, key, httpRequest, buf);
            isMake = true;
        }
        return isMake;
    }

    protected StringBuffer makeAuthTypeFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(AUTH_TYPE_HEADER).append(request.getAuthType());
    }

    protected StringBuffer makeRemoteUserFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(REMOTE_USER_HEADER).append(request.getRemoteUser());
    }

    protected StringBuffer makeUserPrincipalFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(USER_PRINCIPAL_HEADER).append(request.getUserPrincipal());
    }

    protected StringBuffer makeRequestURLFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(REQUEST_URL_HEADER).append(request.getRequestURL());
    }

    protected StringBuffer makeRequestURIFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(REQUEST_URI_HEADER).append(request.getRequestURI());
    }

    protected StringBuffer makeServletPathFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(SERVLET_PATH_HEADER).append(request.getServletPath());
    }

    protected StringBuffer makeContextPathFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(CONTEXT_PATH_HEADER).append(request.getContextPath());
    }

    protected StringBuffer makePathInfoFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(PATH_INFO_HEADER).append(request.getPathInfo());
    }

    protected StringBuffer makePathTranslatedFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(PATH_TRAN_HEADER).append(request.getPathTranslated());
    }

    protected StringBuffer makeQueryStringFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(QUERY_STRING_HEADER).append(request.getQueryString());
    }

    protected StringBuffer makeSessionIDFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        buf.append(SESSION_ID_HEADER).append(request.getRequestedSessionId());
        if (request.isRequestedSessionIdFromCookie()) {
            buf.append(OPEN_BRACKET).append(FROM_COOKIE).append(CLOSE_BRACKET);
        } else if (request.isRequestedSessionIdFromURL()) {
            buf.append(OPEN_BRACKET).append(FROM_URL).append(CLOSE_BRACKET);
        }
        return buf;
    }

    protected StringBuffer makeMethodFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        return buf.append(HTTP_METHOD_HEADER).append(request.getMethod());
    }

    protected StringBuffer makeHeadersFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        buf.append(HTTP_HEADER_HEADER);
        Enumeration headerNames = request.getHeaderNames();
        if (!headerNames.hasMoreElements()) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (!this.enabledHeaderSet.isEmpty() && !this.enabledHeaderSet.contains(name)) continue;
            subBuf.append(name);
            subBuf.append(" = ");
            if (this.secretHeaderSet.contains(name)) {
                subBuf.append(this.getSecretString());
            } else {
                Enumeration values = request.getHeaders(name);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    subBuf.append(value);
                    if (!values.hasMoreElements()) continue;
                    subBuf.append(HEADER_VALUE_SEPARATOR);
                }
            }
            if (!headerNames.hasMoreElements()) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }

    protected StringBuffer makeCookiesFormat(EditorFinder finder, Object key, HttpServletRequest request, StringBuffer buf) {
        buf.append(COOKIE_HEADER);
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            buf.append("null");
            return buf;
        }
        buf.append(this.getLineSeparator());
        StringBuffer subBuf = new StringBuffer();
        for (int i = 0; i < cookies.length; ++i) {
            if (!this.enabledCookieSet.isEmpty() && !this.enabledCookieSet.contains(this.name)) continue;
            subBuf.append(cookies[i].getName());
            subBuf.append(" = ");
            if (this.secretCookieSet.contains(cookies[i].getName())) {
                subBuf.append(this.getSecretString());
            } else {
                subBuf.append(cookies[i].getValue());
            }
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_COMMENT).append(" = ").append(cookies[i].getComment());
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_DOMAIN).append(" = ").append(cookies[i].getDomain());
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_MAX_AGE).append(" = ").append(cookies[i].getMaxAge());
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_PATH).append(" = ").append(cookies[i].getPath());
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_SECURE).append(" = ").append(cookies[i].getSecure());
            subBuf.append(COOKIE_ATTR_SEPARATOR).append(COOKIE_VERSION).append(" = ").append(cookies[i].getVersion());
            if (i == cookies.length - 1) continue;
            subBuf.append(this.getLineSeparator());
        }
        this.addIndent(subBuf);
        return buf.append(subBuf);
    }
}

