/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSession;
import jp.ossc.nimbus.service.journal.editor.HttpSessionJSONJournalEditorServiceMBean;
import jp.ossc.nimbus.service.journal.editor.JSONJournalEditorService;
import jp.ossc.nimbus.service.journal.editorfinder.EditorFinder;

public class HttpSessionJSONJournalEditorService
extends JSONJournalEditorService
implements HttpSessionJSONJournalEditorServiceMBean {
    private static final long serialVersionUID = 8220048416985842970L;
    protected String[] secretAttributes;
    protected Set secretAttributeSet;
    protected String[] enabledAttributes;
    protected Set enabledAttributeSet;
    protected String[] disabledAttributes;
    protected Set disabledAttributeSet;

    public void setSecretAttributes(String[] names) {
        this.secretAttributes = names;
    }

    public String[] getSecretAttributes() {
        return this.secretAttributes;
    }

    public void setEnabledAttributes(String[] names) {
        this.enabledAttributes = names;
    }

    public String[] getEnabledAttributes() {
        return this.enabledAttributes;
    }

    public void setDisabledAttributes(String[] names) {
        this.disabledAttributes = names;
    }

    public String[] getDisabledAttributes() {
        return this.disabledAttributes;
    }

    public void startService() throws Exception {
        int i;
        if (this.secretAttributes != null && this.secretAttributes.length != 0) {
            this.secretAttributeSet = new HashSet(this.secretAttributes.length);
            for (i = 0; i < this.secretAttributes.length; ++i) {
                this.secretAttributeSet.add(this.secretAttributes[i]);
            }
        }
        if (this.enabledAttributes != null && this.enabledAttributes.length != 0) {
            this.enabledAttributeSet = new HashSet(this.enabledAttributes.length);
            for (i = 0; i < this.enabledAttributes.length; ++i) {
                this.enabledAttributeSet.add(this.enabledAttributes[i]);
            }
        }
        if (this.disabledAttributes != null && this.disabledAttributes.length != 0) {
            this.disabledAttributeSet = new HashSet(this.disabledAttributes.length);
            for (i = 0; i < this.disabledAttributes.length; ++i) {
                this.disabledAttributeSet.add(this.disabledAttributes[i]);
            }
        }
    }

    protected boolean isOutputAttribute(String name) {
        if (name != null && this.disabledAttributeSet != null && this.disabledAttributeSet.contains(name)) {
            return false;
        }
        return name == null || this.enabledAttributeSet == null || this.enabledAttributeSet.contains(name);
    }

    protected boolean isSecretAttribute(String name) {
        return name != null && this.secretAttributeSet != null && this.secretAttributeSet.contains(name);
    }

    protected StringBuffer appendUnknownValue(StringBuffer buf, EditorFinder finder, Class type, Object value) {
        if (!(value instanceof HttpSession)) {
            return super.appendUnknownValue(buf, finder, type, value);
        }
        HttpSession session = (HttpSession)value;
        buf.append("{");
        this.appendHttpSession(buf, finder, session, false);
        buf.append("}");
        return buf;
    }

    protected boolean appendHttpSession(StringBuffer buf, EditorFinder finder, HttpSession session, boolean isAppended) {
        isAppended |= this.appendId(buf, finder, session, isAppended);
        isAppended |= this.appendCreationTime(buf, finder, session, isAppended);
        isAppended |= this.appendLastAccessedTime(buf, finder, session, isAppended);
        isAppended |= this.appendMaxInactiveInterval(buf, finder, session, isAppended);
        isAppended |= this.appendIsNew(buf, finder, session, isAppended);
        isAppended |= this.appendAttributes(buf, finder, session, isAppended);
        return isAppended;
    }

    protected boolean appendId(StringBuffer buf, EditorFinder finder, HttpSession session, boolean isAppended) {
        if (this.isOutputProperty("Id")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "Id", session.getId());
            return true;
        }
        return false;
    }

    protected boolean appendCreationTime(StringBuffer buf, EditorFinder finder, HttpSession session, boolean isAppended) {
        if (this.isOutputProperty("CreationTime")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "CreationTime", new Date(session.getCreationTime()));
            return true;
        }
        return false;
    }

    protected boolean appendLastAccessedTime(StringBuffer buf, EditorFinder finder, HttpSession session, boolean isAppended) {
        if (this.isOutputProperty("LastAccessedTime")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "LastAccessedTime", new Date(session.getLastAccessedTime()));
            return true;
        }
        return false;
    }

    protected boolean appendMaxInactiveInterval(StringBuffer buf, EditorFinder finder, HttpSession session, boolean isAppended) {
        if (this.isOutputProperty("MaxInactiveInterval")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "MaxInactiveInterval", new Integer(session.getMaxInactiveInterval()));
            return true;
        }
        return false;
    }

    protected boolean appendIsNew(StringBuffer buf, EditorFinder finder, HttpSession session, boolean isAppended) {
        if (this.isOutputProperty("IsNew")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendProperty(buf, finder, "IsNew", session.isNew() ? Boolean.TRUE : Boolean.FALSE);
            return true;
        }
        return false;
    }

    protected boolean appendAttributes(StringBuffer buf, EditorFinder finder, HttpSession session, boolean isAppended) {
        if (this.isOutputProperty("Attributes")) {
            if (isAppended) {
                buf.append(",");
            }
            this.appendName(buf, "Attributes");
            buf.append(":");
            buf.append("{");
            Enumeration names = session.getAttributeNames();
            boolean isOutput = false;
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!this.isOutputAttribute(name)) continue;
                if (isOutput) {
                    buf.append(",");
                }
                isOutput = true;
                this.appendName(buf, name);
                buf.append(":");
                if (this.isSecretAttribute(name)) {
                    this.appendValue(buf, finder, null, this.secretString);
                    continue;
                }
                this.appendValue(buf, finder, null, session.getAttribute(name));
            }
            buf.append("}");
            return true;
        }
        return false;
    }
}

