/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceProxy;
import jp.ossc.nimbus.service.repository.MBeanServerRepositoryServiceMBean;

public class MBeanServerRepositoryService
extends ServiceBase
implements Serializable,
NotificationListener,
NotificationFilter,
MBeanServerRepositoryServiceMBean {
    private static final long serialVersionUID = -6480474182037404159L;
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private final Map mbeanNames = new Hashtable();
    private final Map mbeans = new Hashtable();
    private String serverDomain;
    private String serverDefaultDomain;
    private String objectNameDomain;
    private MBeanServer server;
    private boolean isCreateMBeanServer;

    public void setMBeanServerDomain(String domain) {
        this.serverDomain = domain;
    }

    public String getMBeanServerDomain() {
        return this.serverDomain;
    }

    public void setMBeanServerDefaultDomain(String domain) {
        this.serverDefaultDomain = domain;
    }

    public String getMBeanServerDefaultDomain() {
        return this.serverDefaultDomain;
    }

    public void setObjectNameDomain(String domain) {
        this.objectNameDomain = domain;
    }

    public String getObjectNameDomain() {
        return this.objectNameDomain;
    }

    public void setCreateMBeanServer(boolean isCreate) {
        this.isCreateMBeanServer = isCreate;
    }

    public boolean isCreateMBeanServer() {
        return this.isCreateMBeanServer;
    }

    public void startService() throws Exception {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(this.serverDomain);
        if (servers == null || servers.size() == 0) {
            if (this.isCreateMBeanServer) {
                MBeanServer server = MBeanServerFactory.createMBeanServer(this.serverDomain);
                servers = new ArrayList();
                servers.add(server);
            } else {
                throw new Exception("MBeanServer not found : " + this.serverDomain);
            }
        }
        if (this.serverDefaultDomain != null) {
            for (int i = 0; i < servers.size(); ++i) {
                if (!this.serverDefaultDomain.equals(((MBeanServer)servers.get(i)).getDefaultDomain())) continue;
                this.server = (MBeanServer)servers.get(i);
                break;
            }
            if (this.server == null) {
                throw new Exception("MBeanServer not found : " + this.serverDefaultDomain);
            }
        } else {
            this.server = (MBeanServer)servers.get(0);
        }
    }

    public void destroyService() throws Exception {
        this.server = null;
    }

    public Object get(String name) {
        ObjectName mbeanName = (ObjectName)this.mbeanNames.get(name);
        if (mbeanName == null) {
            return null;
        }
        if (!this.server.isRegistered(mbeanName)) {
            return null;
        }
        return this.mbeans.get(name);
    }

    public boolean register(String name, Object obj) {
        try {
            ObjectName mbeanName = this.convertStringToObjectName(name, obj);
            if (this.isRegistered(name)) {
                this.unregister(name);
            }
            this.server.registerMBean(obj, mbeanName);
            this.mbeanNames.put(name, mbeanName);
            this.mbeans.put(name, obj);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            return false;
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            return false;
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            return false;
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean unregister(String name) {
        ObjectName mbeanName = (ObjectName)this.mbeanNames.get(name);
        if (mbeanName == null) {
            return false;
        }
        try {
            this.server.unregisterMBean(mbeanName);
            this.mbeanNames.remove(name);
            this.mbeans.remove(name);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isRegistered(String name) {
        ObjectName mbeanName = (ObjectName)this.mbeanNames.get(name);
        if (mbeanName == null) {
            return false;
        }
        return this.server.isRegistered(mbeanName);
    }

    public Set nameSet() {
        return new HashSet(this.mbeanNames.keySet());
    }

    public Set registeredSet() {
        return new HashSet(this.mbeans.values());
    }

    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if ("JMX.mbean.registered".equals(type)) {
            ObjectName mbeanName = ((MBeanHandback)handback).name;
            String name = this.convertObjectNameToString(mbeanName);
            Object obj = ((MBeanHandback)handback).mbean;
            this.mbeanNames.put(name, mbeanName);
            this.mbeans.put(name, obj);
        } else if ("JMX.mbean.unregistered".equals(type)) {
            ObjectName name = ((MBeanHandback)handback).name;
            this.mbeanNames.remove(name);
            this.mbeans.remove(name);
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        String type = notification.getType();
        return "JMX.mbean.registered".equals(type) || "JMX.mbean.unregistered".equals(type);
    }

    private ObjectName convertStringToObjectName(String name, Object obj) throws MalformedObjectNameException {
        Object child;
        Hashtable<String, String> prop = new Hashtable<String, String>();
        Object target = obj;
        while (target instanceof ServiceProxy && (child = ((ServiceProxy)target).getTarget()) != target) {
            target = child;
        }
        String className = target.getClass().getName();
        prop.put(CLASS, className);
        prop.put(NAME, name);
        String domainName = this.objectNameDomain;
        if (domainName == null) {
            domainName = this.getServiceManagerName();
        }
        return new ObjectName(domainName, prop);
    }

    private String convertObjectNameToString(ObjectName name) {
        return name.getKeyProperty(NAME);
    }

    private class MBeanHandback {
        public ObjectName name;
        public Object mbean;

        public MBeanHandback(ObjectName name, Object mbean) {
            this.name = name;
            this.mbean = mbean;
        }
    }
}

