/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.scheduler2;

import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.queue.DefaultQueueService;
import jp.ossc.nimbus.service.queue.Queue;
import jp.ossc.nimbus.service.queue.QueueHandler;
import jp.ossc.nimbus.service.queue.QueueHandlerContainerService;
import jp.ossc.nimbus.service.scheduler2.AbstractSchedulerService;
import jp.ossc.nimbus.service.scheduler2.DefaultSchedulerServiceMBean;

public class DefaultSchedulerService
extends AbstractSchedulerService
implements DefaultSchedulerServiceMBean {
    private static final long serialVersionUID = 1536820942062675121L;
    protected QueueHandlerContainerService queueHandlerContainer;
    protected ServiceName queueServiceName;
    protected Queue requestQueue;
    protected int scheduleDispatcherSize = 1;
    protected boolean isDaemonScheduleDispatcher = true;

    public void setQueueServiceName(ServiceName name) {
        this.queueServiceName = name;
    }

    public ServiceName getQueueServiceName() {
        return this.queueServiceName;
    }

    public void setScheduleDispatcherSize(int size) {
        this.scheduleDispatcherSize = size;
    }

    public int getScheduleDispatcherSize() {
        return this.scheduleDispatcherSize;
    }

    public int getActiveScheduleDispatcherSize() {
        return this.queueHandlerContainer == null ? 0 : this.queueHandlerContainer.getActiveQueueHandlerSize();
    }

    public void setDaemonScheduleDispatcher(boolean isDaemon) {
        this.isDaemonScheduleDispatcher = isDaemon;
    }

    public boolean isDaemonScheduleDispatcher() {
        return this.isDaemonScheduleDispatcher;
    }

    public void createService() throws Exception {
        this.queueHandlerContainer = new QueueHandlerContainerService();
        this.queueHandlerContainer.create();
    }

    public void startService() throws Exception {
        this.queueHandlerContainer.setQueueHandlerSize(this.scheduleDispatcherSize);
        this.queueHandlerContainer.setDaemonQueueHandler(this.isDaemonScheduleDispatcher);
        if (this.queueServiceName != null) {
            this.queueHandlerContainer.setQueueServiceName(this.queueServiceName);
        } else if (this.requestQueue != null) {
            this.queueHandlerContainer.setQueueService(this.requestQueue);
        } else {
            DefaultQueueService queue = new DefaultQueueService();
            queue.create();
            queue.start();
            this.queueHandlerContainer.setQueueService(queue);
        }
        this.queueHandlerContainer.setQueueHandler(new ScheduleDispatcher());
        this.queueHandlerContainer.start();
    }

    public void stopService() throws Exception {
        this.queueHandlerContainer.stop();
    }

    public void destroyService() throws Exception {
        this.queueHandlerContainer.destroy();
        this.queueHandlerContainer = null;
    }

    public void setQueue(Queue queue) {
        this.requestQueue = queue;
    }

    protected Queue getQueue() {
        return this.requestQueue;
    }

    protected boolean isTransactableQueue() {
        return false;
    }

    protected void entrySchedule(AbstractSchedulerService.ScheduleRequest request) throws Throwable {
        this.queueHandlerContainer.getQueueService().push(request);
    }

    protected class ScheduleDispatcher
    implements QueueHandler {
        protected ScheduleDispatcher() {
        }

        public void handleDequeuedObject(Object obj) throws Throwable {
            if (obj == null) {
                return;
            }
            DefaultSchedulerService.this.dispatchSchedule((AbstractSchedulerService.ScheduleRequest)obj);
        }

        public boolean handleError(Object obj, Throwable th) throws Throwable {
            throw th;
        }

        public void handleRetryOver(Object obj, Throwable th) throws Throwable {
            throw th;
        }
    }
}

