/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.ossc.nimbus.beans.ServiceNameEditor;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.service.aop.interceptor.servlet.StreamExchangeInterceptorServiceMBean;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvoker;
import jp.ossc.nimbus.service.beancontrol.interfaces.BeanFlowInvokerFactory;
import jp.ossc.nimbus.servlet.BeanFlowSelector;
import jp.ossc.nimbus.servlet.BeanFlowServletContext;
import jp.ossc.nimbus.servlet.DefaultBeanFlowSelectorService;

public class BeanFlowServlet
extends HttpServlet {
    private static final long serialVersionUID = -5548272719656324613L;
    public static final String INIT_PARAM_NAME_BEAN_FLOW_SELECTOR_SERVICE_NAME = "BeanFlowSelectorServiceName";
    public static final String INIT_PARAM_NAME_BEAN_FLOW_INVOKER_FACTORY_SERVICE_NAME = "BeanFlowInvokerFactoryServiceName";
    public static final String INIT_PARAM_NAME_VALIDATE = "Validate";
    public static final String INIT_PARAM_NAME_VALIDATE_FLOW_PREFIX = "ValidateFlowPrefix";
    public static final String INIT_PARAM_NAME_INPUT_ATTRIBUTE_NAME = "InputAttributeName";
    public static final String INIT_PARAM_NAME_OUTPUT_ATTRIBUTE_NAME = "OutputAttributeName";
    public static final String DEFAULT_VALIDATE_FLOW_PREFIX = "validate";
    protected ServiceName beanFlowInvokerFactoryServiceName;
    protected ServiceName beanFlowSelectorServiceName;
    protected DefaultBeanFlowSelectorService defaultBeanFlowSelector;
    protected boolean isValidate;
    protected String validateFlowPrefix = "validate";
    protected String inputAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_REQUEST_OBJECT_ATTRIBUTE_NAME;
    protected String outputAttributeName = StreamExchangeInterceptorServiceMBean.DEFAULT_RESPONSE_OBJECT_ATTRIBUTE_NAME;

    public void init() throws ServletException {
        String outputName;
        String inputName;
        this.beanFlowInvokerFactoryServiceName = this.getBeanFlowInvokerFactoryServiceName();
        if (this.beanFlowInvokerFactoryServiceName == null) {
            throw new ServletException("BeanFlowInvokerFactoryServiceName is null.");
        }
        this.beanFlowSelectorServiceName = this.getBeanFlowSelectorServiceName();
        if (this.beanFlowSelectorServiceName == null) {
            this.defaultBeanFlowSelector = new DefaultBeanFlowSelectorService();
            try {
                this.defaultBeanFlowSelector.create();
                this.defaultBeanFlowSelector.start();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        this.isValidate = this.isValidate();
        String prefix = this.getValidateFlowPrefix();
        if (prefix != null && prefix.length() != 0) {
            this.validateFlowPrefix = prefix;
        }
        if ((inputName = this.getInputAttributeName()) != null) {
            this.inputAttributeName = inputName;
        }
        if ((outputName = this.getOutputAttributeName()) != null) {
            this.outputAttributeName = outputName;
        }
    }

    protected ServiceName getBeanFlowSelectorServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_BEAN_FLOW_SELECTOR_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    protected ServiceName getBeanFlowInvokerFactoryServiceName() {
        ServletConfig config = this.getServletConfig();
        String serviceNameStr = config.getInitParameter(INIT_PARAM_NAME_BEAN_FLOW_INVOKER_FACTORY_SERVICE_NAME);
        if (serviceNameStr == null) {
            return null;
        }
        ServiceNameEditor editor = new ServiceNameEditor();
        editor.setAsText(serviceNameStr);
        return (ServiceName)editor.getValue();
    }

    protected boolean isValidate() {
        ServletConfig config = this.getServletConfig();
        String isValidateStr = config.getInitParameter(INIT_PARAM_NAME_VALIDATE);
        return isValidateStr == null ? false : Boolean.valueOf(isValidateStr);
    }

    protected String getValidateFlowPrefix() {
        ServletConfig config = this.getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_VALIDATE_FLOW_PREFIX);
    }

    protected String getInputAttributeName() {
        ServletConfig config = this.getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_INPUT_ATTRIBUTE_NAME);
    }

    protected String getOutputAttributeName() {
        ServletConfig config = this.getServletConfig();
        return config.getInitParameter(INIT_PARAM_NAME_OUTPUT_ATTRIBUTE_NAME);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doService(req, resp);
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BeanFlowInvoker validateFlow;
        String validateFlowName;
        String flowName = this.processSelectBeanFlow(req, resp);
        if (flowName == null || flowName.length() == 0) {
            this.handleNotFound(req, resp, flowName);
            return;
        }
        BeanFlowInvokerFactory beanFlowInvokerFactory = (BeanFlowInvokerFactory)ServiceManagerFactory.getServiceObject(this.beanFlowInvokerFactoryServiceName);
        if (!beanFlowInvokerFactory.containsFlow(flowName)) {
            this.handleNotFound(req, resp, flowName);
            return;
        }
        BeanFlowServletContext context = new BeanFlowServletContext(req, resp, req.getAttribute(this.inputAttributeName));
        if (this.validateFlowPrefix != null && beanFlowInvokerFactory.containsFlow(validateFlowName = this.validateFlowPrefix + flowName) && !this.processValidate(req, resp, context, validateFlow = beanFlowInvokerFactory.createFlow(validateFlowName)) && !this.handleValidateError(req, resp, context)) {
            return;
        }
        BeanFlowInvoker flow = beanFlowInvokerFactory.createFlow(flowName);
        this.processAction(req, resp, context, flow);
    }

    protected String processSelectBeanFlow(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BeanFlowSelector beanFlowSelector = this.defaultBeanFlowSelector;
        if (this.beanFlowSelectorServiceName != null) {
            beanFlowSelector = (BeanFlowSelector)ServiceManagerFactory.getServiceObject(this.beanFlowSelectorServiceName);
        }
        return beanFlowSelector.selectBeanFlow(req);
    }

    protected void handleNotFound(HttpServletRequest req, HttpServletResponse resp, String flowName) throws ServletException, IOException {
        resp.sendError(404, "Flow '" + flowName + "' is not found.");
    }

    protected boolean processValidate(HttpServletRequest req, HttpServletResponse resp, BeanFlowServletContext context, BeanFlowInvoker validateFlow) throws ServletException, IOException {
        try {
            Object ret = validateFlow.invokeFlow(context);
            boolean result = false;
            if (ret != null && ret instanceof Boolean) {
                result = (Boolean)ret;
            }
            if (!result && context.getOutput() != null) {
                req.setAttribute(this.outputAttributeName, context.getOutput());
            }
            return result;
        }
        catch (Exception e) {
            return this.handleValidateException(req, resp, context, e);
        }
    }

    protected boolean handleValidateException(HttpServletRequest req, HttpServletResponse resp, BeanFlowServletContext context, Exception e) throws ServletException, IOException {
        throw new ServletException("Validate error.", (Throwable)e);
    }

    protected boolean handleValidateError(HttpServletRequest req, HttpServletResponse resp, BeanFlowServletContext context) throws ServletException, IOException {
        return false;
    }

    protected void processAction(HttpServletRequest req, HttpServletResponse resp, BeanFlowServletContext context, BeanFlowInvoker flow) throws ServletException, IOException {
        try {
            Object ret = flow.invokeFlow(context);
            if (context.getOutput() == null) {
                if (ret != null) {
                    req.setAttribute(this.outputAttributeName, ret);
                }
            } else {
                req.setAttribute(this.outputAttributeName, context.getOutput());
            }
        }
        catch (Exception e) {
            this.handleActionException(req, resp, context, e);
        }
    }

    protected boolean handleActionException(HttpServletRequest req, HttpServletResponse resp, BeanFlowServletContext context, Exception e) throws ServletException, IOException {
        throw new ServletException("Flow error.", (Throwable)e);
    }
}

