/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.util.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import jp.ossc.nimbus.beans.NoSuchPropertyException;
import jp.ossc.nimbus.beans.Property;
import jp.ossc.nimbus.beans.PropertyFactory;
import jp.ossc.nimbus.util.net.SSLServerSocketWrapper;

public class SSLServerSocketFactory
extends javax.net.ssl.SSLServerSocketFactory {
    public static final String DEFAULT_PROTOCOL = "TLS";
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String DEFAULT_ALGORITHM = "SunX509";
    protected javax.net.ssl.SSLServerSocketFactory serverSocketFactory;
    protected Map serverSocketProperties;
    protected Map socketProperties;
    protected String protocol = "TLS";
    protected String keyAlias;
    protected String keyStoreType = "JKS";
    protected String keyStoreAlgorithm = "SunX509";
    protected String keyStoreFile = System.getProperty("user.home") + "/.keystore";
    protected String keyStorePassword = "changeit";
    protected String keyPassword = "";
    protected String trustKeyStoreType = "JKS";
    protected String trustKeyStoreAlgorithm = "SunX509";
    protected String trustKeyStoreFile;
    protected String trustKeyStorePassword;
    protected boolean initialized = false;

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setKeyStoreType(String storeType) {
        this.keyStoreType = storeType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreAlgorithm(String algorithm) {
        this.keyStoreAlgorithm = algorithm;
    }

    public String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreFile(String path) {
        this.keyStoreFile = path;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStorePassword(String password) {
        this.keyStorePassword = password;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyAlias(String alias) {
        this.keyAlias = alias;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyPassword(String password) {
        this.keyPassword = password;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setTrustKeyStoreType(String storeType) {
        this.trustKeyStoreType = storeType;
    }

    public String getTrustKeyStoreType() {
        return this.trustKeyStoreType;
    }

    public void setTrustKeyStoreAlgorithm(String algorithm) {
        this.trustKeyStoreAlgorithm = algorithm;
    }

    public String getTrustKeyStoreAlgorithm() {
        return this.trustKeyStoreAlgorithm;
    }

    public void setTrustKeyStoreFile(String path) {
        this.trustKeyStoreFile = path;
    }

    public String getTrustKeyStoreFile() {
        return this.trustKeyStoreFile;
    }

    public void setTrustKeyStorePassword(String password) {
        this.trustKeyStorePassword = password;
    }

    public String getTrustKeyStorePassword() {
        return this.trustKeyStorePassword;
    }

    public void setServerSocketProperties(Map props) {
        if (props == null || props.size() == 0) {
            if (this.serverSocketProperties != null) {
                this.serverSocketProperties = null;
            }
            return;
        }
        Iterator names = props.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.setServerSocketProperty(name, props.get(name));
        }
    }

    public void setServerSocketProperty(String name, Object value) {
        if (this.serverSocketProperties == null) {
            this.serverSocketProperties = new LinkedHashMap();
        }
        Property prop = PropertyFactory.createProperty(name);
        this.serverSocketProperties.put(prop, value);
    }

    public Object getServerSocketProperty(String name) {
        if (this.serverSocketProperties == null) {
            return null;
        }
        Iterator props = this.serverSocketProperties.keySet().iterator();
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            if (!prop.getPropertyName().equals(name)) continue;
            return this.serverSocketProperties.get(prop);
        }
        return null;
    }

    protected synchronized void init() throws IOException {
        if (this.initialized) {
            return;
        }
        try {
            SSLContext context = SSLContext.getInstance(this.protocol);
            context.init(this.getKeyManagers(), this.getTrustManagers(), new SecureRandom());
            this.serverSocketFactory = context.getServerSocketFactory();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            e.printStackTrace();
            throw new IOException(e.toString());
        }
        this.initialized = true;
    }

    protected KeyManager[] getKeyManagers() throws Exception {
        KeyManager[] keyManager = null;
        KeyStore store = this.getKeyStore();
        if (this.keyAlias != null && !store.isKeyEntry(this.keyAlias)) {
            throw new IOException("KeyAlias is not entried. " + this.keyAlias);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.keyStoreAlgorithm);
        keyManagerFactory.init(store, this.keyPassword.toCharArray());
        keyManager = keyManagerFactory.getKeyManagers();
        if (this.keyAlias != null) {
            if (DEFAULT_KEYSTORE_TYPE.equals(this.keyStoreType)) {
                this.keyAlias = this.keyAlias.toLowerCase();
            }
            for (int i = 0; i < keyManager.length; ++i) {
                keyManager[i] = new X509KeyManagerWrapper((X509KeyManager)keyManager[i], this.keyAlias);
            }
        }
        return keyManager;
    }

    protected TrustManager[] getTrustManagers() throws Exception {
        TrustManager[] trustManager = null;
        KeyStore trustStore = this.getTrustStore();
        if (trustStore != null) {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.trustKeyStoreAlgorithm);
            trustManagerFactory.init(trustStore);
            trustManager = trustManagerFactory.getTrustManagers();
        }
        return trustManager;
    }

    protected KeyStore getKeyStore() throws IOException {
        return this.getStore(this.keyStoreType, this.keyStoreFile, this.keyStorePassword);
    }

    protected KeyStore getTrustStore() throws IOException {
        KeyStore trustStore = null;
        if (this.trustKeyStoreFile == null) {
            this.trustKeyStoreFile = System.getProperty("javax.net.ssl.trustStore");
        }
        if (this.trustKeyStorePassword == null) {
            this.trustKeyStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (this.trustKeyStorePassword == null) {
            this.trustKeyStorePassword = this.keyStorePassword;
        }
        if (this.trustKeyStoreFile != null && this.trustKeyStorePassword != null) {
            trustStore = this.getStore(this.trustKeyStoreType, this.trustKeyStoreFile, this.trustKeyStorePassword);
        }
        return trustStore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyStore getStore(String type, String path, String password) throws IOException {
        KeyStore keyStore = null;
        InputStream is = null;
        try {
            try {
                keyStore = KeyStore.getInstance(type);
                File keyStoreFile = new File(path);
                is = new FileInputStream(keyStoreFile);
                keyStore.load(is, password.toCharArray());
                is.close();
                return keyStore;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("Exception trying to load keystore " + path + " : " + e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public ServerSocket createServerSocket() throws IOException {
        if (!this.initialized) {
            this.init();
        }
        return this.applyServerSocketProperties(new SSLServerSocketWrapper((SSLServerSocket)this.serverSocketFactory.createServerSocket()));
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        return this.applyServerSocketProperties(new SSLServerSocketWrapper((SSLServerSocket)this.serverSocketFactory.createServerSocket(port)));
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        return this.applyServerSocketProperties(new SSLServerSocketWrapper((SSLServerSocket)this.serverSocketFactory.createServerSocket(port, backlog)));
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        return this.applyServerSocketProperties(new SSLServerSocketWrapper((SSLServerSocket)this.serverSocketFactory.createServerSocket(port, backlog, bindAddr)));
    }

    public String[] getDefaultCipherSuites() {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (IOException e) {
                return new String[0];
            }
        }
        return this.serverSocketFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (IOException e) {
                return new String[0];
            }
        }
        return this.serverSocketFactory.getSupportedCipherSuites();
    }

    protected ServerSocket applyServerSocketProperties(SSLServerSocketWrapper serverSocket) throws IOException {
        try {
            if (this.socketProperties != null && this.socketProperties.size() != 0) {
                Iterator names = this.socketProperties.keySet().iterator();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    serverSocket.setSocketProperty(name, this.socketProperties.get(name));
                }
            }
            if (this.serverSocketProperties != null && this.serverSocketProperties.size() != 0) {
                Iterator props = this.serverSocketProperties.keySet().iterator();
                while (props.hasNext()) {
                    Property prop = (Property)props.next();
                    prop.setProperty(serverSocket, this.serverSocketProperties.get(prop));
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new UndeclaredThrowableException(target);
        }
        catch (NoSuchPropertyException e) {
            throw new UndeclaredThrowableException(e);
        }
        return serverSocket;
    }

    private static class X509KeyManagerWrapper
    implements X509KeyManager {
        private X509KeyManager keyManager;
        private String serverKeyAlias;

        public X509KeyManagerWrapper(X509KeyManager mgr, String serverKeyAlias) {
            this.keyManager = mgr;
            this.serverKeyAlias = serverKeyAlias;
        }

        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.keyManager.chooseClientAlias(keyType, issuers, socket);
        }

        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.serverKeyAlias;
        }

        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }

        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }
    }
}

