
import java.io.*;
import java.sql.*;
import java.util.*;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.io.CSVReader;
import jp.ossc.nimbus.service.connection.ConnectionFactory;
import jp.ossc.nimbus.service.connection.ConnectionFactoryException;
import jp.ossc.nimbus.service.connection.PersistentManager;
import jp.ossc.nimbus.service.connection.PersistentException;

/**
 * TvVsNXB
 */
public class Main{
    
    public static final void main(String[] args){
        
        // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // ConnectionFactoryT[rX擾
            ConnectionFactory factory = (ConnectionFactory)ServiceManagerFactory
                .getServiceObject("ConnectionFactory");
            
            // PersistentManagerT[rX擾
            PersistentManager pm = (PersistentManager)ServiceManagerFactory
                .getServiceObject("PersistentManager");
            
            Connection con = null;
            FileInputStream fis = null;
            try{
                // ͂ƂȂ郆[UXgCSVt@CI[v
                fis = new FileInputStream("userlist.csv");
                
                // Xg[CSVReaderŃbv
                CSVReader reader = new CSVReader(new InputStreamReader(fis));
                reader.setCommentPrefix("#");
                
                // Connection̎擾
                con = factory.getConnection();
                
                // f[^x[Xւ̃ob`݂sBatchExecutor𐶐
                PersistentManager.BatchExecutor executor = pm.createBatchExecutor(con, "insert into MYUSER(name, age, sex) values(?, ?, ?)", null);
                // 5ob`s悤ɐݒ
                executor.setAutoBatchPersistCount(5);
                
                // CSVt@CPsǂݍ݂Ȃf[^x[XɃob`sINSERT
                List csv = new ArrayList();
                int updateCount = 0;
                int total = 0;
                System.out.println("f[^x[Xւ̏݊Jn");
                while((csv = reader.readCSVLineList(csv)) != null){
                    updateCount = executor.addBatch(csv);
                    if(updateCount > 0){
                        System.out.println("MYUSERe[u " + updateCount + " INSERT܂B");
                    }
                    total+=updateCount;
                }
                updateCount = executor.persist();
                if(updateCount > 0){
                    System.out.println("MYUSERe[u " + updateCount + " INSERT܂B");
                }
                total+=updateCount;
                System.out.println("MYUSERe[uɍv " + total + " INSERT܂B");
                executor.close();
                fis.close();
                fis = null;
                
                // f[^x[X̃J[\ǂݏosCursor𐶐
                PersistentManager.Cursor cursor = pm.createCursor(con, "select name, age, sex from MYUSER", null, null, null);
                
                // f[^x[XSELECTR[hPsJ[\ړȂo͂
                User user = new User();
                System.out.println("f[^x[X̓ǂݍ݊Jn");
                while(cursor.next()){
                    cursor.load(user);
                    System.out.println("    " + user);
                }
                cursor.close();
            }catch(IOException e){
                e.printStackTrace();
                System.exit(-1);
            }catch(ConnectionFactoryException e){
                e.printStackTrace();
                System.exit(-1);
            }catch(PersistentException e){
                e.printStackTrace();
                System.exit(-1);
            }finally{
                if(fis != null){
                    try{
                        fis.close();
                    }catch(IOException e){
                        e.printStackTrace();
                    }
                }
                if(con != null){
                    try{
                        con.close();
                    }catch(SQLException e){
                        e.printStackTrace();
                    }
                }
            }
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
        
        // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
    
    public static class User{
        private String name;
        private int age;
        private String sex;
        
        public User(){}
        
        public User(String name, int age, String sex){
            this.name = name;
            this.age = age;
            this.sex = sex;
        }
        
        public void setName(String name){
            this.name = name;
        }
        public String getName(){
            return name;
        }
        public void setAge(int age){
            this.age = age;
        }
        public int getAge(){
            return age;
        }
        public void setSex(String sex){
            this.sex = sex;
        }
        public String getSex(){
            return sex;
        }
        public String toString(){
            return '{' + name + ", " + age + ", " + sex + '}';
        }
    }
}