
import java.awt.*;
import java.util.Random;
import java.util.List;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.*;

import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.service.ga.GeneticAlgorithm;
import jp.ossc.nimbus.service.ga.Generation;
import jp.ossc.nimbus.service.ga.Genom;
import jp.ossc.nimbus.service.ga.Gene;
import jp.ossc.nimbus.service.ga.DefaultGenom;
import jp.ossc.nimbus.service.ga.ComplexGene;
import jp.ossc.nimbus.service.ga.IntegerGene;
import jp.ossc.nimbus.service.ga.Seed;

/**
 * TvPsNXB
 */
public class Main extends JFrame{
    
    public Main(){
        this.setSize(900, 900);
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
     
    public static final void main(String[] args) throws Exception{
         
         // T[rX`t@C[h
        if(ServiceManagerFactory.loadManager("service-definition.xml")){
            System.out.println("T[rX`̓ǂݍ݂ɐ܂B");
            
            // T[rX擾
            GeneticAlgorithm ga  = (GeneticAlgorithm)ServiceManagerFactory.getServiceObject("GeneticAlgorithm");
            
            final int seedNum = Integer.parseInt(args[0]);
            boolean isAsc = Boolean.valueOf(args[1]).booleanValue();
            final int pointNum = Integer.parseInt(args[2]);
            
            // V[h𐶐
            Random random = new Random();
            
            // ev[gƂȂSeed𐶐
            AreaSeed areaSeed = new AreaSeed(pointNum, 850, 10, 850, 10);
            
            // 𐶐
            Generation generation = ga.createGeneration(random, areaSeed, seedNum, isAsc);
            
            Generation newGeneration = null;
            JFrame frame = new Main();
            AreaPanel areaPanel = new AreaPanel();
            frame.getContentPane().add(areaPanel);
            frame.setVisible(true);
            do{
                // ŋāA𐶂
                newGeneration = ga.compete(random, generation);
                
                // plɈ`qݒ肵āÄ`悳
                areaPanel.setGenom(generation.getSurvivor().getGenom());
                
                // 㐔ƓKl\
                String out = "" + generation.getGenerationNo() + "" + "  " + "KlF" + generation.getSurvivor().getFitness();
                frame.setTitle(out);
                System.out.println(out);
                
                Thread.sleep(1000);
                
                generation = newGeneration;
            }while(generation != null);
        }else{
            System.out.println("T[rX`̓ǂݍ݂Ɏs܂B");
        }
         // T[rX`t@CA[h
        ServiceManagerFactory.unloadManager("service-definition.xml");
    }
}

/**
 * ̈V[hB<p>
 * ̍WȂ̖̈ʐς߂B<br>
 */
class AreaSeed implements Seed, Cloneable{
    
    /**
     * ̈\WW`B<p>
     */
    private DefaultGenom genom;
    
    /**
     * KlF̖̈ʐρB<p>
     */
    private Number fitness;
    
    /**
     * RXgN^B<p>
     *
     * @param pointNum W̐
     * @param xMax xW̍ől
     * @param xMin xW̍ŏl
     * @param yMax yW̍ől
     * @param yMin yW̍ŏl
     */
    public AreaSeed(int pointNum, int xMax, int xMin, int yMax, int yMin){
        
        // `𐶐
        genom = new DefaultGenom();
        for(int i = 0; i < pointNum; i++){
            
            // W𕡍`qƂĐ
            ComplexGene pointGene = new ComplexGene();
            pointGene.setName("xy" + (i + 1));
            
            // XWint^`qƂĐ
            // ˑRψٗ 1%
            // V 30%
            IntegerGene xGene = new IntegerGene();
            xGene.setName("x");
            xGene.setMutateRate(0.01f);
            xGene.setRandomRangeMargin(0.3f);
            xGene.setMaxValue(xMax);
            xGene.setMinValue(xMin);
            
            // YWint^`qƂĐ
            // ˑRψٗ 1%
            // V 30%
            IntegerGene yGene = new IntegerGene();
            yGene.setName("y");
            yGene.setMutateRate(0.01f);
            yGene.setRandomRangeMargin(0.3f);
            yGene.setMaxValue(yMax);
            yGene.setMinValue(yMin);
            
            pointGene.setGene("x", xGene);
            pointGene.setGene("y", yGene);
            
            genom.addGene(pointGene);
        }
    }
    
    /**
     * `擾B<p>
     *
     * @return `
     */
    public Genom getGenom(){
        return genom;
    }
    
    /**
     * KlZoB<p>
     * `񂪎̍WȂ̖̈ʐςvZāAKlƂĊi[B<br>
     * 
     * @param generation 
     * @exception Exception KľvZɎsꍇ
     */
    public void fit(Generation generation) throws Exception{
        List geneList = new ArrayList();
        geneList.addAll(genom.getGeneMap().values()); 
        Collections.sort(geneList, new XDescComparator());
        
        ComplexGene maxComplexGene = (ComplexGene)(ComplexGene)geneList.get(0);
        ComplexGene minComplexGene = (ComplexGene)(ComplexGene)geneList.get(geneList.size()-1);
        
        Collections.sort(geneList, new AreaCalculationComparator(minComplexGene, maxComplexGene));
        genom.getGeneMap().clear();
          int total=0;
        for(int i = 0; i < geneList.size(); i ++){
            ComplexGene gene1 = (ComplexGene)geneList.get(i);
            gene1.setName("xy" + (i + 1));
            genom.addGene(gene1);
            
            ComplexGene gene2 = i != geneList.size() - 1 ? (ComplexGene)geneList.get(i + 1) : (ComplexGene)geneList.get(0);
            
            total+=((((Integer)gene1.getGene("x").getValue()).intValue() - ((Integer)gene2.getGene("x").getValue()).intValue())*
                   (((Integer)gene1.getGene("y").getValue()).intValue() + ((Integer)gene2.getGene("y").getValue()).intValue()));
        }
        fitness = (Number)new Integer(Math.abs(total)/2);
    }
    
    /**
     * Kl擾B<p>
     *
     * @return Kl
     */
    public Number getFitness(){
        return fitness;
    }
    
    /**
     * ̃V[h̕쐬B<p>
     *
     * @return ꂽV[h
     */
    public Seed cloneSeed(){
         AreaSeed clone = null;
         try{
             clone = (AreaSeed)super.clone();
         }catch(CloneNotSupportedException e){
             return null;
         }
         clone.genom = (DefaultGenom)genom.cloneGenom();
         clone.fitness = null;
         return clone;
    }
    
    /**
     * W\`qAxW̍~Ń\[gComparatorB<p>
     */
    private static class XDescComparator implements Comparator{
        public int compare(Object o1, Object o2){
            ComplexGene cg1 = (ComplexGene)o1;
            ComplexGene cg2 = (ComplexGene)o2;
            return ((Integer)cg2.getGene("x").getValue()).intValue() - ((Integer)cg1.getGene("x").getValue()).intValue();
        }
    }
    
    /**
     * W\`qAʐόvZɕKvȕяŃ\[gComparatorB<p>
     */
    private static class AreaCalculationComparator implements Comparator{
        
        private ComplexGene baseGene;
        private double baseSlope;
        
        public AreaCalculationComparator(ComplexGene minComplexGene, ComplexGene maxComplexGene){
            double basedifferntX = ((Integer)maxComplexGene.getGene("x").getValue()).intValue() - ((Integer)minComplexGene.getGene("x").getValue()).intValue();
            double basediffrentY = ((Integer)maxComplexGene.getGene("y").getValue()).intValue() - ((Integer)minComplexGene.getGene("y").getValue()).intValue();
            baseSlope = basedifferntX == 0.0d ? 0.0d : (basediffrentY / basedifferntX);
            baseGene = minComplexGene;
        }
        
        public int compare(Object o1, Object o2) {
            ComplexGene cg1 = (ComplexGene)o1;
            ComplexGene cg2 = (ComplexGene)o2;
            double differntX = ((Integer)cg1.getGene("x").getValue()).intValue() - ((Integer)baseGene.getGene("x").getValue()).intValue();
            double diffrentY = ((Integer)cg1.getGene("y").getValue()).intValue() - ((Integer)baseGene.getGene("y").getValue()).intValue();
            double slope1 = differntX == 0.0d ? 0.0d : (diffrentY / differntX);
            differntX = ((Integer)cg2.getGene("x").getValue()).intValue() - ((Integer)baseGene.getGene("x").getValue()).intValue();
            diffrentY = ((Integer)cg2.getGene("y").getValue()).intValue() - ((Integer)baseGene.getGene("y").getValue()).intValue();
            double slope2 = differntX == 0.0d ? 0.0d : (diffrentY / differntX);
            if(slope1 > baseSlope && slope2 > baseSlope){
                return ((Integer)cg1.getGene("x").getValue()).intValue() - ((Integer)cg2.getGene("x").getValue()).intValue();
            }else if(slope1 <= baseSlope && slope2 <= baseSlope){
                return ((Integer)cg2.getGene("x").getValue()).intValue() - ((Integer)cg1.getGene("x").getValue()).intValue();
            }else if(slope1 > baseSlope && slope2 <= baseSlope){
                return 1;
            }else{
                return -1;
            }
        }
    }
}

/**
 * ̈plB<p>
 */
class AreaPanel extends JPanel{
    
    private Genom genom;
    
    public void setGenom(Genom genom){
        this.genom = genom;
        repaint();
    }
    
    public void paintComponent(Graphics g){
        super.paintComponent(g);
        if(genom == null){
            return;
        }
        g.setColor(Color.BLACK);
        ComplexGene[] genes = (ComplexGene[])genom.getGeneMap().values().toArray(new ComplexGene[genom.getGeneMap().size()]);
        for(int i = 0; i < genes.length; i ++){
            ComplexGene gene1 = (ComplexGene)genes[i];
            ComplexGene gene2 = i != genes.length - 1 ? genes[i + 1] : genes[0];
            g.drawString(
                gene1.getName() + "(" + ((Integer)gene1.getGene("x").getValue()).intValue() + ", " + ((Integer)gene1.getGene("y").getValue()).intValue() + ")",
                ((Integer)gene1.getGene("x").getValue()).intValue(),
                ((Integer)gene1.getGene("y").getValue()).intValue()
            );
            
            g.drawLine(
                ((Integer)gene1.getGene("x").getValue()).intValue(),
                ((Integer)gene1.getGene("y").getValue()).intValue(),
                ((Integer)gene2.getGene("x").getValue()).intValue(),
                ((Integer)gene2.getGene("y").getValue()).intValue()
            );
        }
    }
}