package jp.ossc.nimbus.service.scheduler2.sample;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import jp.ossc.nimbus.service.scheduler2.Schedule;

/**
 * tH[}bg[eBeB
 *
 */
public class FormatUtil {

    public static final String DATE_FORMAT_PATTERN_DATE8 = "yyyyMMdd";
    public static final String DATE_FORMAT_PATTERN_DATE6 = "yyyyMM";
    public static final String DATE_FORMAT_PATTERN_DATE8_TIME4 = "yyyyMMddHHmm";
    public static final String DATE_FORMAT_PATTERN_DATE8_TIME6 = "yyyyMMddHHmmss";
    public static final String DATE_FORMAT_PATTERN_DATE8_TIME9 = "yyyyMMddHHmmssSSS";
    public static final String DATE_FORMAT_PATTERN_TIME6 = "HHmmss";
    public static final String DATE_FORMAT_PATTERN_TIME9 = "HHmmssSSS";

    public static final String DATE_FORMAT_PATTERN_YEAR4 = "yyyy";
    public static final String DATE_FORMAT_PATTERN_DAY = "dd";
    public static final String DATE_FORMAT_PATTERN_DAY2 = "d";

    public static final String DATE_FORMAT_PATTERN_DATE8_SIGN = "yyyy/MM/dd";
    public static final String DATE_FORMAT_PATTERN_DATE6_SIGN = "yyyy/MM";
    public static final String DATE_FORMAT_PATTERN_DATE4_SIGN = "MM/dd";
    public static final String DATE_FORMAT_PATTERN_DATE8_TIME4_SIGN = "yyyy/MM/dd HH:mm";
    public static final String DATE_FORMAT_PATTERN_DATE8_TIME6_SIGN = "yyyy/MM/dd HH:mm:ss";

    public static final String DATE_FORMAT_PATTERN_TIME6_COLON = "HH:mm:ss";
    public static final String DATE_FORMAT_PATTERN_TIME4_COLON = "HH:mm";
    public static final String DATE_FORMAT_PATTERN_TIME4S_COLON = "mm:ss";

    public static final String NUMBER_FORMAT_PATTERN_POINT2 = "%.2f";
    public static final String NUMBER_FORMAT_PATTERN_POINT0 = "%.0f";

    /**
     * String  Date ɕϊ
     * @param format_str
     * @param date_str
     * @return date
     */
    public static Date toDate(String format_str, String date_str) {
        if (date_str == null || date_str.length() == 0) {
            return null;
        }

        SimpleDateFormat format = new SimpleDateFormat(format_str);
        Date date = null;
        try {
            date = format.parse(date_str);
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return date;
    }

    /**
     * ,,N  Date ɕϊ
     * @param day
     * @param month
     * @param year
     * @return date
     */
    public static Date toDate(final int day, final int month, final int year) {

        final Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
//        calendar.set(year, month, day, 0, 0, 0);
        final Date result = calendar.getTime();

        return result;
    }

    /**
     * ,,N  long ɕϊ
     * @param day
     * @param month
     * @param year
     * @return long
     */
    public static long toDateLong(final int day, final int month, final int year) {

        final Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        calendar.set(year, month, day, 0, 0, 0);
        final Date result = calendar.getTime();

        return result.getTime();
    }

    /**
     * Calneder  String ɕϊ
     * @param format
     * @param calendar
     * @return str
     */
    public static String format(String format, Calendar calendar) {
        if (calendar == null) {
            return "";
        }

        String str = format(format, calendar.getTime());

        return str;
    }

    /**
     * Date  String ɕϊ
     * @param format
     * @param date
     * @return str
     */
    public static String format(String format, Date date) {
        if (date == null) {
            return "";
        }

        SimpleDateFormat sf = new SimpleDateFormat(format);
        String str = sf.format(date);

        return str;
    }

    /**
     * long  Ԃɕϊ
     * @param time
     * @return time_str                                      
     */
    public static String execTime(long time) {
        if (time == Long.MIN_VALUE) {
            return "";
        }

        DecimalFormat df = new DecimalFormat("00");

        String time_str = (String)(df.format(time/60)) + ":" + (String)(df.format(time%60));

        return time_str;
    }

    /**
     * long  Ԃɕϊ
     * @param time
     * @param flg (trueF_ȉľܓAfalseF_ȉ؂̂)
     * @return time_str
     */
    public static String execTime(double time, boolean flg) {
        if (time == Double.NaN) {
            return "";
        }

        DecimalFormat df = new DecimalFormat("00");
        
        long etime = (flg == true ? (long)Math.round(time) : (long)time);
        String time_str = (String)(df.format (etime/60)) + ":" + (String)(df.format(etime%60));

        return time_str;
    }

    /**
     * sR[hsɕϊ
     * @param str
     * @return str
     */
    public static String escape(String str) {
        if (str == null) {
            return str;
        }

        str = str.replaceAll("\r", "\\\\r");
        str = str.replaceAll("\n", "\\\\n");

        return str;
    }

    /**
     * tj擾
     *
     * @param date
     * @return j
     */
    public static String getWeekOfDay(Date date) {

        final Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);

        return getWeekOfDay(calendar.get(Calendar.DAY_OF_WEEK));
    }

    /**
     * Calendar̒萔j擾
     * @param idx
     * @return j
     */
    public static String getWeekOfDay(int idx) {

        switch (idx) {
          case Calendar.SUNDAY:   return "";
          case Calendar.MONDAY:   return "";
          case Calendar.TUESDAY:  return "";
          case Calendar.WEDNESDAY:return "";
          case Calendar.THURSDAY: return "";
          case Calendar.FRIDAY:   return "";
          case Calendar.SATURDAY: return "y";
        }
        return "";
    }

    /**
     * Xe[^X̂擾܂B
     * @param state
     * @return Xe[^X
     */
    public static String getStateKana(int state) {
        switch(state){
        case Schedule.STATE_INITIAL:
            return "";
        case Schedule.STATE_ENTRY:
            return "";
        case Schedule.STATE_RUN:
            return "s";
        case Schedule.STATE_END:
            return "I";
        case Schedule.STATE_FAILED:
            return "ُI";
        case Schedule.STATE_PAUSE:
            return "ꎞ~";
        case Schedule.STATE_ABORT:
            return "~";
        case Schedule.STATE_RETRY:
            return "gC";
        case Schedule.STATE_UNKNOWN:
        default:
            return "s";
        }
    }

    /**
     * Xe[^X̂擾܂B
     * @param state
     * @param check_state
     * @return Xe[^X
     */
    public static String getStateKana(int state, int check_state) {
        if (state == Schedule.STATE_RUN  && check_state == Schedule.CHECK_STATE_TIMEOVER ) {
            return "x";
        }
        else if (state == Schedule.STATE_END && check_state == Schedule.CHECK_STATE_TIMEOVER) {
            return "xI";
        } else {
            return getStateKana(state);
        }
    }

    /**
     * Ԃ擾܂B
     * @param state
     * @return Xe[^X
     */
    public static String getControlStateKana(int state){
        switch(state){
        case Schedule.CONTROL_STATE_INITIAL:
            return "";
        case Schedule.CONTROL_STATE_PAUSE:
            return "ꎞ~";
        case Schedule.CONTROL_STATE_RESUME:
            return "ĊJ";
        case Schedule.CONTROL_STATE_ABORT:
            return "~";
        case Schedule.CONTROL_STATE_FAILED:
            return "䎸s";
        case Schedule.CONTROL_STATE_UNKNOWN:
        default:
            return "s";
        }
    }

    /**
     * `FbNԂ擾܂B
     * @param state
     * @return Xe[^X
     */
    public static String getCheckStateKana(int state){
        switch(state){
        case Schedule.CHECK_STATE_INITIAL:
            return "";
        case Schedule.CHECK_STATE_TIMEOVER:
            return "^CI[o[";
        case Schedule.CHECK_STATE_UNKNOWN:
        default:
            return "s";
        }
    }
}
