﻿////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//
//	danmaq Nineball-Library
//		Copyright (c) 2008-2010 danmaq all rights reserved.
//
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

using danmaq.nineball.state;

namespace danmaq.nineball.entity.input
{

	//* ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ *
	/// <summary>マンマシンI/F入力制御・管理機能の空実装クラス。</summary>
	/// <remarks>
	/// ヌルデバイスに接続されている状況を再現しています。また、このクラスを継承するか、
	/// <c>CInput</c>抽象クラスを実装することで、独自の入力制御・管理クラスを構築できます。
	/// </remarks>
	public class CInputEmpty : CInput
	{

		//* ────────────-＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿*
		//* constructor & destructor ───────────────────────*

		//* -----------------------------------------------------------------------*
		/// <summary>コンストラクタ。</summary>
		/// 
		/// <param name="playerNumber">プレイヤー番号。</param>
		public CInputEmpty(short playerNumber)
			: base(playerNumber, CState.empty)
		{
		}

		//* ─────-＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿*
		//* properties ──────────────────────────────*

		//* -----------------------------------------------------------------------*
		/// <summary>
		/// <para>接続されているかどうかを取得します。</para>
		/// <para>
		/// 常にヌルデバイスに接続されている状況を再現して
		/// いるため、戻り値は常に<c>true</c>となります。
		/// </para>
		/// </summary>
		/// 
		/// <value>常に<c>true</c>。</value>
		public override bool connect
		{
			get
			{
				return true;
			}
		}
	}
}
