//------------------------------------------------
// Collision.c 蔻菈
//------------------------------------------------

#include <math.h>
#include <stdlib.h>
#include "funcs.h"

#ifndef __Collision__
#define __Collision__

// `
#ifndef EPS
#define EPS  1e-10		// ̌덷el
#endif

#ifndef BIGNUM
#define BIGNUM  1e30		// Iɂ鏉l
#endif

#ifndef sinf
#define sinf sin
#endif

#ifndef cosf
#define cosf cos
#endif


/*
//-----------------------------------------------------------------
// LineCircleTime
// @\Fړ~̊OڂƐ̐ڐG
// FMyObject *obj, Line *line, vector *vy
//       *obj  : ~̏
//       *line : 
//       *vy   : ړxNg
// ԒlFڐGԁiPt[PƂĊōlj
//       ڐGȂꍇ͕Ԃ
// ӁF̊֐͂܂ł
// QlFhttp://marupeke296.com/COL_3D_No16_MoveShereAndSepLine.html
float LineCircleTime(MyObject *obj, Line *line, Vector *vy)
{
	float a, t, b, o;
	Vector A, C;
	
	if(vy->x==0 && vy->y==0) return -1;
	
	// Ql̂`߂
	A = line->ed;
	a = VectorDotProduct(vy, &A);
	VectorMult(&A, &A, a);
	VectorSub(&A, &A, vy);
	
	// Ql̂b߂
	VectorSub(&C, &obj->xy, &line->st);
	VectorMult(&C, &C, VectorDotProduct(&C, &line->ed));
	VectorAdd(&C, &C, &line->st);
	VectorSub(&C, &C, &obj->xy);
	
	// 
	a = VectorLengthNoSquare(&A);
	b = VectorDotProduct(&A, &C);
	o = VectorLengthNoSquare(&C) - obj->r*obj->r;
	t = b*b-a*o;
	
	if(t < 0)	return -1;
	if(t == 0)	return -b/a;
	return (-b-sqrt(t))/a;
}
*/

//-----------------------------------------------------------------
// @\FNCbN\[gpr֐
//       ̍ɗp
// FLine *L1, Line *L2
// ԒlFr
// QlFhttp://www.bohyoh.com/CandCPP/FAQ/FAQ00047.html
// ⑫Fn_yWɂď
int LineCmpYst(const Line *L1, const Line *L2)
{
    return (L1->st.y < L2->st.y ? -1 :
            L1->st.y > L2->st.y ?  1 : 0);
}
// ⑫FI_yWɂď
int LineCmpYed(const Line *L1, const Line *L2)
{
    return (L1->ed.y < L2->ed.y ? -1 :
            L1->ed.y > L2->ed.y ?  1 : 0);
}
// ⑫Fn_xWɂď
int LineCmpXst(const Line *L1, const Line *L2)
{
    return (L1->st.x < L2->st.x ? -1 :
            L1->st.x > L2->st.x ?  1 : 0);
}
// ⑫FI_xWɂď
int LineCmpXed(const Line *L1, const Line *L2)
{
    return (L1->ed.x < L2->ed.x ? -1 :
            L1->ed.x > L2->ed.x ?  1 : 0);
}

//-----------------------------------------------------------------
// LineUpSwap
// @\F蔻Cn_yWɗ悤ɕёւ
// FLine *lines, int num;
//       *lines : z
//       num    : z̗vf
// ԒlFȂ
void LineUpSwap(Line *lines, int num)
{
	int i;
	Vector tmp;
	for(i=0; i<num; i++){
		if(lines[i].st.y < lines[i].ed.y){
			tmp         = lines[i].st;
			lines[i].st = lines[i].ed;
			lines[i].ed = tmp;
		}
	}
}

//-----------------------------------------------------------------
// LineRightSwap
// @\F蔻Cn_xWEɗ悤ɕёւ
// FLine *lines, int num;
//       *lines : z
//       num    : z̗vf
// ԒlFȂ
void LineRightSwap(Line *lines, int num)
{
	int i;
	Vector tmp;
	for(i=0; i<num; i++){
		if(lines[i].st.x < lines[i].ed.x){
			tmp         = lines[i].st;
			lines[i].st = lines[i].ed;
			lines[i].ed = tmp;
		}
	}
}

//-----------------------------------------------------------------
// LineLowerBound
// @\Fw肳ꂽlȏ̒lŏɂłvfԍԂ
//       񕪒TpD
// ӁFz͏\[gĂKv
// FLine *lines, int array, float num
//       *lines : Cz
//       array  : z̗vf
//       num    : rɗpl
// ԒlFl傫ŏ̗vfԍ
//       Ȃꍇ-1Ԃ
// ⑫FI_xWɂĒT
int LineLowerBoundXed(Line *lines, int array, float num)
{
	int start = 0,
	    end   = array-1,
	    center;
	
	if(num < lines[start].ed.x) return 0;	// ŏlTl
	if(num > lines[end].ed.x) return -1;	// őlTl傫
	
	while(start != end){
		center = (start+end)>>1;
		if(lines[center].ed.x < num)
			start = center;
		else
			end = center;
	}
	if(end-start == 1)
		return start>num ? start : end;
	return start;
}
// ⑫FI_yWɂĒT
int LineLowerBoundYst(Line *lines, int array, float num)
{
	int start = 0,
	    end   = array-1,
	    center;
	
	if(num <= lines[start].st.y) return 0;	// ŏlTl
	if(num >  lines[end].st.y) return -1;	// őlTl傫
	
	while(end-start > 1){
		center = (start+end)>>1;
		if(lines[center].st.y < num)
			start = center;
		else
			end = center;
	}
	if(end-start == 1)
		return start>num ? start : end;
	return start;
}

//-----------------------------------------------------------------
// LineUpperBound
// @\Fw肳ꂽlȉ̒lŏɂłvfԍԂ
//       񕪒TpD
// ӁFz͏\[gĂKv
// FLine *lines, int array, float num
//       *lines : Cz
//       array  : z̗vf
//       num    : rɗpl
// ԒlFl菬ő̗vfԍ
//       Ȃꍇ-1Ԃ
// ⑫Fn_xWɂĒT
int LineUpperBoundXst(Line *lines, int array, float num)
{
	int start = 0,
	    end   = array-1,
	    center;
	
	if(num < lines[start].st.x) return -1;	// ŏlTl
	if(num > lines[end].st.x) return end;	// őlTl傫
	
	while(end-start > 1){
		center = (start+end)>>1;
		if(lines[center].st.x > num)
			end = center;
		else
			start = center;
	}
	if(end-start == 1)
		return start<=num ? start : end;
	return start;
}
// ⑫Fn_yWɂĒT
int LineUpperBoundYst(Line *lines, int array, float num)
{
	int start = 0,
	    end   = array-1,
	    center;
	
	if(num < lines[start].st.y) return -1;	// ŏlTl
	if(num > lines[end].st.y) return array;	// őlTl傫
	
	while(end-start > 1){
		center = (start+end)>>1;
		if(lines[center].st.y > num)
			end = center;
		else
			start = center;
	}
	if(end-start == 1)
		return start<=num ? start : end;
	return start;
}

/*
//-----------------------------------------------------------------
// CollisionAreaDelete
// @\FsKvȗ̈폜
// lFCollisionProcess̕ɂč쐬
//       lines ɂ͒Tׂŏ̗vf
//       num ɂ͒Tׂvf
// ԒlFȂ
void CollisionAreaDelete(MyObject *obj, Line **lines, int *num){
	
	int //  start = 0,	// ̈̎n
	    //  end = *num-1,	// ̈̏I
	      tmp;
	float upm,		// ̈폜p̏̒l
	      downm,		//             ̒l
	      leftm,		//             ̒l
	      rightm;		//             E̒l
	
	if(obj->velocity.x > 0){
		rightm = obj->xy.x + obj->r + obj->velocity.x;
		leftm  = obj->xy.x - obj->r;
	} else {
		rightm = obj->xy.x + obj->r;
		leftm  = obj->xy.x - obj->r + obj->velocity.x;
	}
	if(obj->velocity.y > 0){
		upm    = obj->xy.y + obj->r + obj->velocity.y;
		downm  = obj->xy.y - obj->r;
	} else {
		upm    = obj->xy.y + obj->r;
		downm  = obj->xy.y - obj->r + obj->velocity.y;
	}
		

	// ̈폜
	LineUpSwap(*lines, *num);
	qsort(*lines, *num, sizeof(Line), (int(*)(const void*, const void*))LineCmpYst);
	tmp    = LineLowerBoundYst(*lines, *num, downm);
	if(tmp != -1){
		*num   -= tmp;
		*lines += tmp;
	//	end   = tmp;
	} else {
		*num = 0;
		return;
	}



	// ̈폜
	qsort(*lines, *num, sizeof(Line), (int(*)(const void*, const void*))LineCmpYed);
	tmp    = LineLowerBoundYed(*lines, *num, upm);
	if(tmp != -1){
		*num   -= tmp;
		*lines += tmp;
	//	start   = tmp;
	}
	
	
	// ̈폜 
	LineLeftSwap(*lines, *num);
	qsort(*lines, *num, sizeof(Line), (int(*)(const void*, const void*))LineCmpXed);
	tmp  = LineLowerBoundXed(*lines, *num, leftm);
	if(tmp != -1){
		*num   -= tmp;
		*lines += tmp;
	//	start   = tmp;
	}
	
	// Ë폜
	qsort(*lines, *num, sizeof(Line), (int(*)(const void*, const void*))LineCmpXst);
	tmp   = LineUpperBoundXst(*lines, *num, rightm);
	if(tmp != -1){
		*num -= *num-tmp;
	//	end   = tmp;
	}
	
}
*/

//-----------------------------------------------------------------
// CollisionRotate
// @\F]ɂ铖蔻
// FMyObject *obj, Line *lines, int num, float rad
//       *obj   : @
//       *lines : Cz
//       num    : z̗vf
//       rad    : ]px
// ԒlFȂ
void CollisionRotate(MyObject *obj, Line *lines, int num, float rad)
{
	Vector befXY,
	       befVel,
	       tmv;
	int i;

	befXY  = obj->xy;
	befVel = obj->velocity;
	VectorRotate(&obj->xy, &obj->xy, rad);
	VectorSub(&obj->velocity, &obj->xy, &befXY);
	VectorMult(&obj->velocity, &obj->velocity, FRAME_RATE);
	tmv = obj->velocity;
	CollisionProcess(obj, lines, num, COLLISION_ROTATE);
	if(VectorEqu(&obj->velocity, &tmv) == true){
		obj->velocity = befVel;
		obj->xy = befXY;
	} else {
		VectorAdd(&obj->velocity, &obj->velocity, &befVel);
	}
}
	


//-----------------------------------------------------------------
// CollisionProcess
// @\F@̓蔻
// FMyObject *obj, Line *lines, int num, int type
//       *obj   : @
//       *lines : Cz
//       num    : z̗vf
//       type   : Փ˂̎
// ԒlFȂ
// QlFhttp://hakuhin.hp.infoseek.co.jp/main/as/collide.html#COLLIDE_02
void CollisionProcess(MyObject *obj, Line *lines, int num, int type)
{
	const float dt = 1.0f/FRAME_RATE;	//Ԃ̕ω
	int i;
	Vector vecN, vecC, vecS, vecAC, vecBC, vecV;
	Vector tmv, vel, tmv1, tmv2;
	float fl, fd, ft, tmf;
	
	VectorMult(&vel, &obj->velocity, dt);
	VectorAdd(&obj->xy, &obj->xy, &vel);
	
	// ړƂɂ铖蔻
	for(i=0; i<num; i++){
		VectorSub(&tmv1, &lines[i].st, &obj->xy);				// n_ړOWւ̃xNg
		VectorSub(&tmv2, &lines[i].st, &lines[i].ed);				// n_画I_ւ̃xNg
		tmf = VectorCrossProduct(&tmv1, &tmv2);					// ̂ǂɂ邩
		VectorNormalize(&vecN, VectorRotate90(&tmv1, &tmv2, tmf>0 ? 1 : -1));	// ̂ɌĖ@
		//VectorNormalize(&vecN, VectorRotate90(&tmv, VectorSub(&tmv, &lines[i].st, &lines[i].ed), -1));

		VectorMult(&vecS, &vecN, -obj->r);
		fd = -(lines[i].st.x*vecN.x + lines[i].st.y*vecN.y);
		ft = -(vecN.x*obj->xy.x + vecN.y*obj->xy.y + fd) / (vecN.x*vecS.x + vecN.y*vecS.y);
		
		if(ft > -EPS && ft < 1+EPS){
			VectorMult(&vecC, &vecS, ft);
			VectorAdd(&vecC, &vecC, &obj->xy);
			VectorSub(&vecAC, &vecC, &lines[i].st);
			VectorSub(&vecBC, &vecC, &lines[i].ed);
			
			// _̒ɓĂ邩ׂ
			if(VectorDotProduct(&vecBC,&vecAC) <= EPS){
				VectorMult(&obj->xy, &vecN, obj->r);
				VectorAdd(&obj->xy, &obj->xy, &vecC);
				
				// ˃xNg
				ft = -(vecN.x*vel.x + vecN.y*vel.y) / (vecN.x*vecN.x + vecN.y*vecN.y);
				VectorAdd(&vel, &vel, VectorMult(&tmv, &vecN, ft*2.0f*0.95f));
				//obj->velocity.x=0;
				continue;
			}
		}
	}

	if(type == COLLISION_ROTATE)	return;

	for(i=0; i<num; i++){
		VectorSub(&tmv1, &lines[i].st, &obj->xy);				// n_ړOWւ̃xNg
		VectorSub(&tmv2, &lines[i].st, &lines[i].ed);				// n_画I_ւ̃xNg
		tmf = VectorCrossProduct(&tmv1, &tmv2);					// ̂ǂɂ邩
		VectorNormalize(&vecN, VectorRotate90(&tmv1, &tmv2, tmf>0 ? 1 : -1));	// ̂ɌĖ@
		//VectorNormalize(&vecN, VectorRotate90(&tmv, VectorSub(&tmv, &lines[i].st, &lines[i].ed), -1));
		VectorSub(&vecV, &obj->xy, &lines[i].st);
		fl = VectorLength(&vecV);
		
		// ~n_ƏdȂĂ邩ׂ
		if(fl < obj->r){
			VectorNormalize(&vecV, &vecV);
			VectorMult(&vecV, &vecV, obj->r);
			
			// ʒu␳
			VectorAdd(&obj->xy, &vecV, &lines[i].st);
			
			// ˕
			VectorNormalize(&vecV, &vecV);
			fl = VectorLength(&vel);
			VectorMult(&vel, &vecV, fl*1.5f);

			continue;
		}

		// ~I_ƏdȂĂ邩ׂ
		VectorSub(&vecV, &obj->xy, &lines[i].ed);
		fl = VectorLength(&vecV);
		if(fl < obj->r){
			VectorNormalize(&vecV, &vecV);
			VectorMult(&vecV, &vecV, obj->r);
			
			// ʒu␳
			VectorAdd(&obj->xy, &vecV, &lines[i].ed);
			
			// ˕
			VectorNormalize(&vecV, &vecV);
			fl = VectorLength(&vel);
			VectorMult(&vel, &vecV, fl*1.5f);

			continue;
		}
	}
	VectorMult(&obj->velocity, &vel, FRAME_RATE);
	
	/*
	const float dt = 1.0f/FRAME_RATE;	//Ԃ̕ω
	float  tmf,	// ꎞϐ
	       bn,	// ŏǏݒl
	       zoomf;	// ʒu{
	int    i,
	       sel;	// ŏI̗vfԍ
	Vector tmv1,	// ꎞxNg
	       tmv2,
	       vel,	// cړxNg
	       veln,	// ړPʃxNg
	       afterXY;	// ړʒuxNg
	Line   lineXY;	// ړC

	VectorMult(&vel, &obj->velocity, dt);
	VectorNormalize(&veln, &vel);

	//CollisionAreaDelete(obj, &lines, &num);
	
	// 蔻
	while(1){
		// ړՓː쐬
		VectorAdd(&afterXY, &obj->xy, &vel);
		VectorAdd(&afterXY, &afterXY, VectorMult(&tmv1, &veln, obj->r));	// a΂
		lineXY.st = obj->xy;
		lineXY.ed = afterXY;
		
		// Փ˓_ɂĈړOɍł߂̂I
		for(i=0, bn=BIGNUM, sel=-1; i<num; i++){
			if(LineCrossCheck(&lineXY, &lines[i]) == true){
				LineCrossGet(&tmv1, &lineXY, &lines[i]);	// _擾
				VectorSub(&tmv1, &lineXY.st, &tmv1);
				tmf = VectorLengthNoSquare(&tmv1);		// _̋擾
				if(bn > tmf){
					tmv2 = tmv1;		// ŒZ̃xNgi[
					bn = tmf;		// ŒẐQ
					sel = i;		// ŒZ̔vfԍ
				}
			}
		}
		
		// Փ˂Ȃ̏ꍇ͈ړďI
		if(sel == -1){
			VectorAdd(&obj->xy, &obj->xy, &vel);
			break;
		}

		// cړxNg쐬
		VectorSub(&tmv1, &tmv2, &obj->xy);		// Փ˓_܂ł̃xNg
		zoomf = sqrt(bn/VectorLengthNoSquare(&vel));	// Փ˃xNgƈړxNg̔

		// ɑ΂Pʖ@xNg쐬
		VectorSub(&tmv1, &lines[sel].st, &obj->xy);			// n_ړOWւ̃xNg
		VectorSub(&tmv2, &lines[sel].st, &lines[sel].ed);		// n_画I_ւ̃xNg
		tmf = VectorCrossProduct(&tmv1, &tmv2);				// ̂ǂɂ邩
		VectorNormalize(&tmv1, VectorRotate90(&tmv1, &tmv2, tmf>0 ? 1 : -1));	// ̂ɌĖ@

		// ʒuxNgړ
		VectorAdd(&obj->xy, &obj->xy, VectorMult(&tmv2, &vel, 1.0f-zoomf));
		VectorAdd(&obj->xy, &obj->xy, VectorMult(&tmv2, &veln, obj->r));
		
		// Փˌ̈ړxNg쐬
		VectorMult(&tmv2, &vel, -zoomf);
		VectorMult(&tmv1, &tmv1, VectorDotProduct(&tmv1, &tmv2));
		VectorSub(&tmv2, &tmv1, &tmv2);
		VectorMult(&tmv2, &tmv2, 2.0f);
		VectorAdd(&vel, &tmv1, &tmv2);
		
		// Փˌ̑xxNg
		tmf = sqrt(VectorLengthNoSquare(&obj->velocity)/VectorLengthNoSquare(&vel));
		VectorMult(&obj->velocity, &vel, -tmf*0.8f);
		break;
	}
	*/
}
#endif
